import { Prop, Provide, Emit, Model } from 'vue-property-decorator';
import { Subject, Subscription } from 'rxjs';
import { Watch, ListControlBase } from '@/studio-core';
import EAMLocationStateService from '@/service/eamlocation-state/eamlocation-state-service';
import ExpListService from './exp-list-list-service';
import EAMLocationStateUIService from '@/uiservice/eamlocation-state/eamlocation-state-ui-service';


/**
 * listexpbar_list部件基类
 *
 * @export
 * @class ListControlBase
 * @extends {ExpListListBase}
 */
export class ExpListListBase extends ListControlBase {

    /**
     * 获取部件类型
     *
     * @protected
     * @type {string}
     * @memberof ExpListListBase
     */
    protected controlType: string = 'LIST';

    /**
     * 建构部件服务对象
     *
     * @type {ExpListService}
     * @memberof ExpListListBase
     */
    public service: ExpListService = new ExpListService({ $store: this.$store });

    /**
     * 实体服务对象
     *
     * @type {EAMLocationStateService}
     * @memberof ExpListListBase
     */
    public appEntityService: EAMLocationStateService = new EAMLocationStateService({ $store: this.$store });

    /**
     * 应用实体名称
     *
     * @protected
     * @type {string}
     * @memberof ExpListListBase
     */
    protected appDeName: string = 'eamlocationstate';

    /**
     * 分页条数
     *
     * @type {number}
     * @memberof ExpListListBase
     */
    public limit: number = 1000;

    /**
     * 排序方向
     *
     * @type {string}
     * @memberof ExpListListBase
     */
    public minorSortDir: string = '';
}