import { Prop, Provide, Emit, Model } from 'vue-property-decorator';
import { Subject, Subscription } from 'rxjs';
import { Watch, EditFormControlBase } from '@/studio-core';
import EAMSparePartsGroupService from '@/service/eamspare-parts-group/eamspare-parts-group-service';
import IF_001Service from './if-001-form-service';
import EAMSparePartsGroupUIService from '@/uiservice/eamspare-parts-group/eamspare-parts-group-ui-service';
import { FormButtonModel, FormPageModel, FormItemModel, FormDRUIPartModel, FormPartModel, FormGroupPanelModel, FormIFrameModel, FormRowItemModel, FormTabPageModel, FormTabPanelModel, FormUserControlModel } from '@/model/form-detail';


/**
 * form部件基类
 *
 * @export
 * @class EditFormControlBase
 * @extends {IF_001EditFormBase}
 */
export class IF_001EditFormBase extends EditFormControlBase {

    /**
     * 获取部件类型
     *
     * @protected
     * @type {string}
     * @memberof IF_001EditFormBase
     */
    protected controlType: string = 'FORM';

    /**
     * 建构部件服务对象
     *
     * @type {IF_001Service}
     * @memberof IF_001EditFormBase
     */
    public service: IF_001Service = new IF_001Service({ $store: this.$store });

    /**
     * 实体服务对象
     *
     * @type {EAMSparePartsGroupService}
     * @memberof IF_001EditFormBase
     */
    public appEntityService: EAMSparePartsGroupService = new EAMSparePartsGroupService({ $store: this.$store });

    /**
     * 应用实体名称
     *
     * @protected
     * @type {string}
     * @memberof IF_001EditFormBase
     */
    protected appDeName: string = 'eamsparepartsgroup';

    /**
     * 应用实体中文名称
     *
     * @protected
     * @type {string}
     * @memberof IF_001EditFormBase
     */
    protected appDeLogicName: string = '备件包';
    /**
     * 界面UI服务对象
     *
     * @type {EAMSparePartsGroupUIService}
     * @memberof IF_001EditFormBase
     */  
    public appUIService:EAMSparePartsGroupUIService = new EAMSparePartsGroupUIService(this.$store);


    /**
     * 表单数据对象
     *
     * @type {*}
     * @memberof IF_001EditFormBase
     */
    public data: any = {
        srfupdatedate: null,
        srforikey: null,
        srfkey: null,
        srfmajortext: null,
        srftempmode: null,
        srfuf: null,
        srfdeid: null,
        srfsourcekey: null,
        sparepartsgrpnumber: null,
        eamsparepartsgroupname: null,
        eamsparepartsgroupid: null,
        eamsparepartsgroup:null,
    };

    /**
     * 属性值规则
     *
     * @type {*}
     * @memberof IF_001EditFormBase
     */
    public rules: any = {
    }

    /**
     * 属性值规则
     *
     * @type {*}
     * @memberof IF_001Base
     */
    public deRules:any = {
    };

    /**
     * 详情模型集合
     *
     * @type {*}
     * @memberof IF_001EditFormBase
     */
    public detailsModel: any = {
        group1: new FormGroupPanelModel({ caption: '备件包基本信息', detailType: 'GROUPPANEL', name: 'group1', visible: true, isShowCaption: true, form: this, showMoreMode: 0, uiActionGroup: { caption: '', langbase: 'entities.eamsparepartsgroup.if_001_form', extractMode: 'ITEM', details: [] } }),

        formpage1: new FormPageModel({ caption: '基本信息', detailType: 'FORMPAGE', name: 'formpage1', visible: true, isShowCaption: true, form: this, showMoreMode: 0 }),

        srfupdatedate: new FormItemModel({ caption: '更新时间', detailType: 'FORMITEM', name: 'srfupdatedate', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        srforikey: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srforikey', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        srfkey: new FormItemModel({ caption: '备件包标识', detailType: 'FORMITEM', name: 'srfkey', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        srfmajortext: new FormItemModel({ caption: '备件包名称', detailType: 'FORMITEM', name: 'srfmajortext', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        srftempmode: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srftempmode', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        srfuf: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srfuf', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        srfdeid: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srfdeid', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        srfsourcekey: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srfsourcekey', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        sparepartsgrpnumber: new FormItemModel({ caption: '备件包编号', detailType: 'FORMITEM', name: 'sparepartsgrpnumber', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        eamsparepartsgroupname: new FormItemModel({ caption: '备件包名称', detailType: 'FORMITEM', name: 'eamsparepartsgroupname', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        eamsparepartsgroupid: new FormItemModel({ caption: '备件包标识', detailType: 'FORMITEM', name: 'eamsparepartsgroupid', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

    };
}