import { Subject } from 'rxjs';
import { PickupViewBase } from '@/studio-core';
import EAMLocationStateService from '@/service/eamlocation-state/eamlocation-state-service';
import EAMLocationStateAuthService from '@/authservice/eamlocation-state/eamlocation-state-auth-service';
import PickupViewEngine from '@engine/view/pickup-view-engine';
import EAMLocationStateUIService from '@/uiservice/eamlocation-state/eamlocation-state-ui-service';

/**
 * 功能位置状态数据选择视图视图基类
 *
 * @export
 * @class EAMLocationStatePickupViewBase
 * @extends {PickupViewBase}
 */
export class EAMLocationStatePickupViewBase extends PickupViewBase {
    /**
     * 视图对应应用实体名称
     *
     * @protected
     * @type {string}
     * @memberof EAMLocationStatePickupViewBase
     */
    protected appDeName: string = 'eamlocationstate';

    /**
     * 应用实体主键
     *
     * @protected
     * @type {string}
     * @memberof EAMLocationStatePickupViewBase
     */
    protected appDeKey: string = 'eamlocationstateid';

    /**
     * 应用实体主信息
     *
     * @protected
     * @type {string}
     * @memberof EAMLocationStatePickupViewBase
     */
    protected appDeMajor: string = 'eamlocationstatename';

    /**
     * 实体服务对象
     *
     * @type {EAMLocationStateService}
     * @memberof EAMLocationStatePickupViewBase
     */
    protected appEntityService: EAMLocationStateService = new EAMLocationStateService;

    /**
     * 实体权限服务对象
     *
     * @type EAMLocationStateUIService
     * @memberof EAMLocationStatePickupViewBase
     */
    public appUIService: EAMLocationStateUIService = new EAMLocationStateUIService(this.$store);


    /**
     * 计数器服务对象集合
     *
     * @protected
     * @type {Array<*>}
     * @memberof EAMLocationStatePickupViewBase
     */    
    protected counterServiceArray: Array<any> = [];

    /**
     * 视图模型数据
     *
     * @protected
     * @type {*}
     * @memberof EAMLocationStatePickupViewBase
     */
    protected model: any = {
        srfCaption: 'entities.eamlocationstate.views.pickupview.caption',
        srfTitle: 'entities.eamlocationstate.views.pickupview.title',
        srfSubTitle: 'entities.eamlocationstate.views.pickupview.subtitle',
        dataInfo: ''
    }

    /**
     * 容器模型
     *
     * @protected
     * @type {*}
     * @memberof EAMLocationStatePickupViewBase
     */
    protected containerModel: any = {
        view_pickupviewpanel: { name: 'pickupviewpanel', type: 'PICKUPVIEWPANEL' },
        view_okbtn: { name: 'okbtn', type: 'button', text: '确定', disabled: true },
        view_cancelbtn: { name: 'cancelbtn', type: 'button', text: '取消', disabled: false },
        view_leftbtn: { name: 'leftbtn', type: 'button', text: '左移', disabled: true },
        view_rightbtn: { name: 'rightbtn', type: 'button', text: '右移', disabled: true },
        view_allleftbtn: { name: 'allleftbtn', type: 'button', text: '全部左移', disabled: true },
        view_allrightbtn: { name: 'allrightbtn', type: 'button', text: '全部右移', disabled: true },
    };


	/**
     * 视图唯一标识
     *
     * @protected
     * @type {string}
     * @memberof ViewBase
     */
	protected viewtag: string = 'a9f7eb2645c6505a232a0a13742c42a7';


    /**
     * 视图引擎
     *
     * @public
     * @type {Engine}
     * @memberof EAMLocationStatePickupViewBase
     */
    public engine: PickupViewEngine = new PickupViewEngine();

    /**
     * 引擎初始化
     *
     * @public
     * @memberof EAMLocationStatePickupViewBase
     */
    public engineInit(): void {
        this.engine.init({
            view: this,
            pickupviewpanel: this.$refs.pickupviewpanel,
            keyPSDEField: 'eamlocationstate',
            majorPSDEField: 'eamlocationstatename',
            isLoadDefault: true,
        });
    }

    /**
     * pickupviewpanel 部件 selectionchange 事件
     *
     * @param {*} [args={}]
     * @param {*} $event
     * @memberof EAMLocationStatePickupViewBase
     */
    public pickupviewpanel_selectionchange($event: any, $event2?: any): void {
        this.engine.onCtrlEvent('pickupviewpanel', 'selectionchange', $event);
    }

    /**
     * pickupviewpanel 部件 activated 事件
     *
     * @param {*} [args={}]
     * @param {*} $event
     * @memberof EAMLocationStatePickupViewBase
     */
    public pickupviewpanel_activated($event: any, $event2?: any): void {
        this.engine.onCtrlEvent('pickupviewpanel', 'activated', $event);
    }

    /**
     * pickupviewpanel 部件 load 事件
     *
     * @param {*} [args={}]
     * @param {*} $event
     * @memberof EAMLocationStatePickupViewBase
     */
    public pickupviewpanel_load($event: any, $event2?: any): void {
        this.engine.onCtrlEvent('pickupviewpanel', 'load', $event);
    }


}