import { Subject } from 'rxjs';
import { TabExpViewBase } from '@/studio-core';
import EAMLocationService from '@/service/eamlocation/eamlocation-service';
import EAMLocationAuthService from '@/authservice/eamlocation/eamlocation-auth-service';
import TabExpViewEngine from '@engine/view/tab-exp-view-engine';
import EAMLocationUIService from '@/uiservice/eamlocation/eamlocation-ui-service';

/**
 * 功能位置信息视图基类
 *
 * @export
 * @class EAMLocationInfoViewBase
 * @extends {TabExpViewBase}
 */
export class EAMLocationInfoViewBase extends TabExpViewBase {
    /**
     * 视图对应应用实体名称
     *
     * @protected
     * @type {string}
     * @memberof EAMLocationInfoViewBase
     */
    protected appDeName: string = 'eamlocation';

    /**
     * 应用实体主键
     *
     * @protected
     * @type {string}
     * @memberof EAMLocationInfoViewBase
     */
    protected appDeKey: string = 'eamlocationid';

    /**
     * 应用实体主信息
     *
     * @protected
     * @type {string}
     * @memberof EAMLocationInfoViewBase
     */
    protected appDeMajor: string = 'eamlocationname';

    /**
     * 实体服务对象
     *
     * @type {EAMLocationService}
     * @memberof EAMLocationInfoViewBase
     */
    protected appEntityService: EAMLocationService = new EAMLocationService;

    /**
     * 实体权限服务对象
     *
     * @type EAMLocationUIService
     * @memberof EAMLocationInfoViewBase
     */
    public appUIService: EAMLocationUIService = new EAMLocationUIService(this.$store);


    /**
     * 计数器服务对象集合
     *
     * @protected
     * @type {Array<*>}
     * @memberof EAMLocationInfoViewBase
     */    
    protected counterServiceArray: Array<any> = [];

    /**
     * 视图模型数据
     *
     * @protected
     * @type {*}
     * @memberof EAMLocationInfoViewBase
     */
    protected model: any = {
        srfCaption: 'entities.eamlocation.views.infoview.caption',
        srfTitle: 'entities.eamlocation.views.infoview.title',
        srfSubTitle: 'entities.eamlocation.views.infoview.subtitle',
        dataInfo: ''
    }

    /**
     * 容器模型
     *
     * @protected
     * @type {*}
     * @memberof EAMLocationInfoViewBase
     */
    protected containerModel: any = {
        view_tabexppanel: { name: 'tabexppanel', type: 'TABEXPPANEL' },
    };


	/**
     * 视图唯一标识
     *
     * @protected
     * @type {string}
     * @memberof ViewBase
     */
	protected viewtag: string = 'd3466c5c60a573062d543896976bf68c';


    /**
     * 视图引擎
     *
     * @public
     * @type {Engine}
     * @memberof EAMLocationInfoViewBase
     */
    public engine: TabExpViewEngine = new TabExpViewEngine();

    /**
     * 引擎初始化
     *
     * @public
     * @memberof EAMLocationInfoViewBase
     */
    public engineInit(): void {
        this.engine.init({
            view: this,
            keyPSDEField: 'eamlocation',
            majorPSDEField: 'eamlocationname',
            isLoadDefault: true,
        });
    }


}