import { Subject } from 'rxjs';
import { TreeExpViewBase } from '@/studio-core';
import EAMLocationService from '@/service/eamlocation/eamlocation-service';
import EAMLocationAuthService from '@/authservice/eamlocation/eamlocation-auth-service';
import TreeExpViewEngine from '@engine/view/tree-exp-view-engine';
import EAMLocationUIService from '@/uiservice/eamlocation/eamlocation-ui-service';

/**
 * 功能位置信息视图基类
 *
 * @export
 * @class EAMLocationTreeExpViewBase
 * @extends {TreeExpViewBase}
 */
export class EAMLocationTreeExpViewBase extends TreeExpViewBase {
    /**
     * 视图对应应用实体名称
     *
     * @protected
     * @type {string}
     * @memberof EAMLocationTreeExpViewBase
     */
    protected appDeName: string = 'eamlocation';

    /**
     * 应用实体主键
     *
     * @protected
     * @type {string}
     * @memberof EAMLocationTreeExpViewBase
     */
    protected appDeKey: string = 'eamlocationid';

    /**
     * 应用实体主信息
     *
     * @protected
     * @type {string}
     * @memberof EAMLocationTreeExpViewBase
     */
    protected appDeMajor: string = 'eamlocationname';

    /**
     * 实体服务对象
     *
     * @type {EAMLocationService}
     * @memberof EAMLocationTreeExpViewBase
     */
    protected appEntityService: EAMLocationService = new EAMLocationService;

    /**
     * 实体权限服务对象
     *
     * @type EAMLocationUIService
     * @memberof EAMLocationTreeExpViewBase
     */
    public appUIService: EAMLocationUIService = new EAMLocationUIService(this.$store);


    /**
     * 计数器服务对象集合
     *
     * @protected
     * @type {Array<*>}
     * @memberof EAMLocationTreeExpViewBase
     */    
    protected counterServiceArray: Array<any> = [];

    /**
     * 视图模型数据
     *
     * @protected
     * @type {*}
     * @memberof EAMLocationTreeExpViewBase
     */
    protected model: any = {
        srfCaption: 'entities.eamlocation.views.treeexpview.caption',
        srfTitle: 'entities.eamlocation.views.treeexpview.title',
        srfSubTitle: 'entities.eamlocation.views.treeexpview.subtitle',
        dataInfo: ''
    }

    /**
     * 容器模型
     *
     * @protected
     * @type {*}
     * @memberof EAMLocationTreeExpViewBase
     */
    protected containerModel: any = {
        view_treeexpbar: { name: 'treeexpbar', type: 'TREEEXPBAR' },
    };


	/**
     * 视图唯一标识
     *
     * @protected
     * @type {string}
     * @memberof ViewBase
     */
	protected viewtag: string = '135343573fd869053d84ecc2f48ffd49';


    /**
     * 视图引擎
     *
     * @public
     * @type {Engine}
     * @memberof EAMLocationTreeExpViewBase
     */
    public engine: TreeExpViewEngine = new TreeExpViewEngine();

    /**
     * 引擎初始化
     *
     * @public
     * @memberof EAMLocationTreeExpViewBase
     */
    public engineInit(): void {
        this.engine.init({
            view: this,
            treeexpbar: this.$refs.treeexpbar,
            keyPSDEField: 'eamlocation',
            majorPSDEField: 'eamlocationname',
            isLoadDefault: true,
        });
    }

    /**
     * treeexpbar 部件 selectionchange 事件
     *
     * @param {*} [args={}]
     * @param {*} $event
     * @memberof EAMLocationTreeExpViewBase
     */
    public treeexpbar_selectionchange($event: any, $event2?: any): void {
        this.engine.onCtrlEvent('treeexpbar', 'selectionchange', $event);
    }

    /**
     * treeexpbar 部件 activated 事件
     *
     * @param {*} [args={}]
     * @param {*} $event
     * @memberof EAMLocationTreeExpViewBase
     */
    public treeexpbar_activated($event: any, $event2?: any): void {
        this.engine.onCtrlEvent('treeexpbar', 'activated', $event);
    }

    /**
     * treeexpbar 部件 load 事件
     *
     * @param {*} [args={}]
     * @param {*} $event
     * @memberof EAMLocationTreeExpViewBase
     */
    public treeexpbar_load($event: any, $event2?: any): void {
        this.engine.onCtrlEvent('treeexpbar', 'load', $event);
    }

    /**
     * 打开新建数据视图
     *
     * @param {any[]} args
     * @param {*} [params]
     * @param {*} [fullargs]
     * @param {*} [$event]
     * @param {*} [xData]
     * @memberof EAMLocationTreeExpView
     */
    public newdata(args: any[],fullargs?:any[], params?: any, $event?: any, xData?: any) {
        let localContext:any = null;
        let localViewParam:any =null;
    this.$Notice.warning({ title: '错误', desc: '未指定关系视图' });
    }


    /**
     * 打开编辑数据视图
     *
     * @param {any[]} args
     * @param {*} [params]
     * @param {*} [fullargs]
     * @param {*} [$event]
     * @param {*} [xData]
     * @memberof EAMLocationTreeExpView
     */
    public opendata(args: any[],fullargs?:any[],params?: any, $event?: any, xData?: any) {
    this.$Notice.warning({ title: '错误', desc: '未指定关系视图' });
    }



    /**
     * 视图唯一标识
     *
     * @type {string}
     * @memberof EAMLocationTreeExpView
     */
    public viewUID: string = 'location-eamlocation-tree-exp-view';


}