/**
 * Main 部件模型
 *
 * @export
 * @class MainModel
 */
export default class MainModel {

	/**
	 * 是否是实体数据导出
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public isDEExport: boolean = false;

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public getDataItems(): any[] {
    if(this.isDEExport){
		  return [
      ]
    }else{
		  return [
        {
          name: 'productid',
          prop: 'productid',
          dataType: 'PICKUP',
        },
        {
          name: 'productnumber',
          prop: 'productnumber',
          dataType: 'PICKUPDATA',
        },
        {
          name: 'eamsparepartsgroupname',
          prop: 'eamsparepartsgroupname',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'srfmajortext',
          prop: 'eamsparepartsproname',
          dataType: 'TEXT',
        },
        {
          name: 'eamsparepartsgroupid',
          prop: 'eamsparepartsgroupid',
          dataType: 'PICKUP',
        },
        {
          name: 'srfdataaccaction',
          prop: 'eamsparepartsproid',
          dataType: 'GUID',
        },
        {
          name: 'srfkey',
          prop: 'eamsparepartsproid',
          dataType: 'GUID',
          isEditable:true
        },
        {
          name: 'productname',
          prop: 'productname',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'eamsparepartspro',
          prop: 'eamsparepartsproid',
        },

        {
          name:'size',
          prop:'size'
        },
        {
          name:'query',
          prop:'query'
        },
        {
          name:'filter',
          prop:'filter'
        },
        {
          name:'page',
          prop:'page'
        },
        {
          name:'sort',
          prop:'sort'
        },
        {
          name:'srfparentdata',
          prop:'srfparentdata'
        },
        // 前端新增修改标识，新增为"0",修改为"1"或未设值
        {
          name: 'srffrontuf',
          prop: 'srffrontuf',
          dataType: 'TEXT',
        },
      ]
    }
  }

}