/**
 * Main 部件模型
 *
 * @export
 * @class MainModel
 */
export default class MainModel {

	/**
	 * 是否是实体数据导出
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public isDEExport: boolean = false;

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public getDataItems(): any[] {
    if(this.isDEExport){
		  return [
      ]
    }else{
		  return [
        {
          name: 'endtime',
          prop: 'endtime',
          dataType: 'DATETIME',
        },
        {
          name: 'begintime',
          prop: 'begintime',
          dataType: 'DATETIME',
        },
        {
          name: 'eamservicelevelid',
          prop: 'eamservicelevelid',
          dataType: 'PICKUP',
        },
        {
          name: 'srfmajortext',
          prop: 'eamapplyname',
          dataType: 'TEXT',
        },
        {
          name: 'srfkey',
          prop: 'eamapplyid',
          dataType: 'GUID',
          isEditable:true
        },
        {
          name: 'srfdataaccaction',
          prop: 'eamapplyid',
          dataType: 'GUID',
        },
        {
          name: 'eamapplytypeid',
          prop: 'eamapplytypeid',
          dataType: 'PICKUP',
        },
        {
          name: 'eamlocationname',
          prop: 'eamlocationname',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'eamlocationid',
          prop: 'eamlocationid',
          dataType: 'PICKUP',
        },
        {
          name: 'eamapplyname',
          prop: 'eamapplyname',
          dataType: 'TEXT',
        },
        {
          name: 'eamapplytypename',
          prop: 'eamapplytypename',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'applynumber',
          prop: 'applynumber',
          dataType: 'TEXT',
        },
        {
          name: 'assetid',
          prop: 'assetid',
          dataType: 'PICKUP',
        },
        {
          name: 'assetname',
          prop: 'assetname',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'eamapply',
          prop: 'eamapplyid',
        },

        {
          name:'size',
          prop:'size'
        },
        {
          name:'query',
          prop:'query'
        },
        {
          name:'filter',
          prop:'filter'
        },
        {
          name:'page',
          prop:'page'
        },
        {
          name:'sort',
          prop:'sort'
        },
        {
          name:'srfparentdata',
          prop:'srfparentdata'
        },
        // 前端新增修改标识，新增为"0",修改为"1"或未设值
        {
          name: 'srffrontuf',
          prop: 'srffrontuf',
          dataType: 'TEXT',
        },
      ]
    }
  }

}