import { Prop, Provide, Emit, Model } from 'vue-property-decorator';
import { Subject, Subscription } from 'rxjs';
import { Watch, GridControlBase } from '@/studio-core';
import EAMApplyService from '@/service/eamapply/eamapply-service';
import MainService from './main-grid-service';
import EAMApplyUIService from '@/uiservice/eamapply/eamapply-ui-service';
import { FormItemModel } from '@/model/form-detail';


/**
 * grid部件基类
 *
 * @export
 * @class GridControlBase
 * @extends {MainGridBase}
 */
export class MainGridBase extends GridControlBase {

    /**
     * 获取部件类型
     *
     * @protected
     * @type {string}
     * @memberof MainGridBase
     */
    protected controlType: string = 'GRID';

    /**
     * 建构部件服务对象
     *
     * @type {MainService}
     * @memberof MainGridBase
     */
    public service: MainService = new MainService({ $store: this.$store });

    /**
     * 实体服务对象
     *
     * @type {EAMApplyService}
     * @memberof MainGridBase
     */
    public appEntityService: EAMApplyService = new EAMApplyService({ $store: this.$store });

    /**
     * 应用实体名称
     *
     * @protected
     * @type {string}
     * @memberof MainGridBase
     */
    protected appDeName: string = 'eamapply';

    /**
     * 应用实体中文名称
     *
     * @protected
     * @type {string}
     * @memberof MainGridBase
     */
    protected appDeLogicName: string = '维护申请';

    /**
     * 界面UI服务对象
     *
     * @type {EAMApplyUIService}
     * @memberof MainBase
     */  
    public appUIService:EAMApplyUIService = new EAMApplyUIService(this.$store);

    /**
     * 界面行为模型
     *
     * @type {*}
     * @memberof MainBase
     */  
    public ActionModel: any = {
    };

    /**
     * 本地缓存标识
     *
     * @protected
     * @type {string}
     * @memberof MainBase
     */
    protected localStorageTag: string = 'eamapply_main_grid';

    /**
     * 所有列成员
     *
     * @type {any[]}
     * @memberof MainGridBase
     */
    public allColumns: any[] = [
        {
            name: 'applynumber',
            label: '维护申请编号',
            langtag: 'entities.eamapply.main_grid.columns.applynumber',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'eamapplyname',
            label: '维护申请名称',
            langtag: 'entities.eamapply.main_grid.columns.eamapplyname',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'eamapplytypename',
            label: '维护申请类型',
            langtag: 'entities.eamapply.main_grid.columns.eamapplytypename',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'assetname',
            label: '资产',
            langtag: 'entities.eamapply.main_grid.columns.assetname',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'eamlocationname',
            label: '功能位置',
            langtag: 'entities.eamapply.main_grid.columns.eamlocationname',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'begintime',
            label: '希望开始时间',
            langtag: 'entities.eamapply.main_grid.columns.begintime',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
        {
            name: 'endtime',
            label: '希望结束时间',
            langtag: 'entities.eamapply.main_grid.columns.endtime',
            show: true,
            util: 'PX',
            isEnableRowEdit: false,
        },
    ]

    /**
     * 获取表格行模型
     *
     * @type {*}
     * @memberof MainGridBase
     */
    public getGridRowModel(){
        return {
          srfkey: new FormItemModel(),
        }
    }

    /**
     * 属性值规则
     *
     * @type {*}
     * @memberof MainGridBase
     */
    public rules: any = {
        srfkey: [
            { required: false, validator: (rule:any, value:any, callback:any) => { return (rule.required && (value === null || value === undefined || value === "")) ? false : true;}, message: '维护申请标识 值不能为空', trigger: 'change' },
            { required: false, validator: (rule:any, value:any, callback:any) => { return (rule.required && (value === null || value === undefined || value === "")) ? false : true;}, message: '维护申请标识 值不能为空', trigger: 'blur' },
        ],
    }

    /**
     * 获取对应列class
     *
     * @type {*}
     * @memberof MainBase
     */
    public hasRowEdit: any = {
        'applynumber':false,
        'eamapplyname':false,
        'eamapplytypename':false,
        'assetname':false,
        'eamlocationname':false,
        'begintime':false,
        'endtime':false,
    };

    /**
     * 获取对应列class
     *
     * @param {*} $args row 行数据，column 列数据，rowIndex 行索引，列索引
     * @returns {void}
     * @memberof MainBase
     */
    public getCellClassName(args: {row: any, column: any, rowIndex: number, columnIndex: number}): any {
        return ( this.hasRowEdit[args.column.property] && this.actualIsOpenEdit ) ? "edit-cell" : "info-cell";
    }


    /**
     * 导出数据格式化
     *
     * @param {*} filterVal
     * @param {*} jsonData
     * @param {any[]} [codelistColumns=[]]
     * @returns {Promise<any>}
     * @memberof MainGridBase
     */
    public async formatExcelData(filterVal: any, jsonData: any, codelistColumns?: any[]): Promise<any> {
        return super.formatExcelData(filterVal, jsonData, [
        ]);
    }

}