import { Prop, Provide, Emit, Model } from 'vue-property-decorator';
import { Subject, Subscription } from 'rxjs';
import { Watch, EditFormControlBase } from '@/studio-core';
import EAMApplyService from '@/service/eamapply/eamapply-service';
import EF_001Service from './ef-001-form-service';
import EAMApplyUIService from '@/uiservice/eamapply/eamapply-ui-service';
import { FormButtonModel, FormPageModel, FormItemModel, FormDRUIPartModel, FormPartModel, FormGroupPanelModel, FormIFrameModel, FormRowItemModel, FormTabPageModel, FormTabPanelModel, FormUserControlModel } from '@/model/form-detail';


/**
 * form部件基类
 *
 * @export
 * @class EditFormControlBase
 * @extends {EF_001EditFormBase}
 */
export class EF_001EditFormBase extends EditFormControlBase {

    /**
     * 获取部件类型
     *
     * @protected
     * @type {string}
     * @memberof EF_001EditFormBase
     */
    protected controlType: string = 'FORM';

    /**
     * 建构部件服务对象
     *
     * @type {EF_001Service}
     * @memberof EF_001EditFormBase
     */
    public service: EF_001Service = new EF_001Service({ $store: this.$store });

    /**
     * 实体服务对象
     *
     * @type {EAMApplyService}
     * @memberof EF_001EditFormBase
     */
    public appEntityService: EAMApplyService = new EAMApplyService({ $store: this.$store });

    /**
     * 应用实体名称
     *
     * @protected
     * @type {string}
     * @memberof EF_001EditFormBase
     */
    protected appDeName: string = 'eamapply';

    /**
     * 应用实体中文名称
     *
     * @protected
     * @type {string}
     * @memberof EF_001EditFormBase
     */
    protected appDeLogicName: string = '维护申请';
    /**
     * 界面UI服务对象
     *
     * @type {EAMApplyUIService}
     * @memberof EF_001EditFormBase
     */  
    public appUIService:EAMApplyUIService = new EAMApplyUIService(this.$store);


    /**
     * 表单数据对象
     *
     * @type {*}
     * @memberof EF_001EditFormBase
     */
    public data: any = {
        srfupdatedate: null,
        srforikey: null,
        srfkey: null,
        srfmajortext: null,
        srftempmode: null,
        srfuf: null,
        srfdeid: null,
        srfsourcekey: null,
        applynumber: null,
        eamapplyname: null,
        eamapplytypename: null,
        assetname: null,
        eamlocationname: null,
        eamlocationid: null,
        eamapplyid: null,
        assetid: null,
        eamapplytypeid: null,
        eamapply:null,
    };

    /**
     * 属性值规则
     *
     * @type {*}
     * @memberof EF_001EditFormBase
     */
    public rules: any = {
        applynumber: [
            { required: true, type: 'string', message: '维护申请编号 值不能为空', trigger: 'change' },
            { required: true, type: 'string', message: '维护申请编号 值不能为空', trigger: 'blur' },
        ],
        eamapplyname: [
            { required: true, type: 'string', message: '维护申请名称 值不能为空', trigger: 'change' },
            { required: true, type: 'string', message: '维护申请名称 值不能为空', trigger: 'blur' },
        ],
        eamapplytypename: [
            { required: true, type: 'string', message: '维护申请类型 值不能为空', trigger: 'change' },
            { required: true, type: 'string', message: '维护申请类型 值不能为空', trigger: 'blur' },
        ],
        assetname: [
            { required: true, type: 'string', message: '资产 值不能为空', trigger: 'change' },
            { required: true, type: 'string', message: '资产 值不能为空', trigger: 'blur' },
        ],
        eamlocationname: [
            { required: true, type: 'string', message: '功能位置 值不能为空', trigger: 'change' },
            { required: true, type: 'string', message: '功能位置 值不能为空', trigger: 'blur' },
        ],
    }

    /**
     * 属性值规则
     *
     * @type {*}
     * @memberof EF_001Base
     */
    public deRules:any = {
    };

    /**
     * 详情模型集合
     *
     * @type {*}
     * @memberof EF_001EditFormBase
     */
    public detailsModel: any = {
        group1: new FormGroupPanelModel({ caption: '维护申请基本信息', detailType: 'GROUPPANEL', name: 'group1', visible: true, isShowCaption: false, form: this, showMoreMode: 0, uiActionGroup: { caption: '', langbase: 'entities.eamapply.ef_001_form', extractMode: 'ITEM', details: [] } }),

        formpage1: new FormPageModel({ caption: '基本信息', detailType: 'FORMPAGE', name: 'formpage1', visible: true, isShowCaption: true, form: this, showMoreMode: 0 }),

        srfupdatedate: new FormItemModel({ caption: '更新时间', detailType: 'FORMITEM', name: 'srfupdatedate', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        srforikey: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srforikey', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        srfkey: new FormItemModel({ caption: '维护申请标识', detailType: 'FORMITEM', name: 'srfkey', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        srfmajortext: new FormItemModel({ caption: '维护申请名称', detailType: 'FORMITEM', name: 'srfmajortext', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        srftempmode: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srftempmode', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        srfuf: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srfuf', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        srfdeid: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srfdeid', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        srfsourcekey: new FormItemModel({ caption: '', detailType: 'FORMITEM', name: 'srfsourcekey', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        applynumber: new FormItemModel({ caption: '维护申请编号', detailType: 'FORMITEM', name: 'applynumber', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        eamapplyname: new FormItemModel({ caption: '维护申请名称', detailType: 'FORMITEM', name: 'eamapplyname', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        eamapplytypename: new FormItemModel({ caption: '维护申请类型', detailType: 'FORMITEM', name: 'eamapplytypename', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        assetname: new FormItemModel({ caption: '资产', detailType: 'FORMITEM', name: 'assetname', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        eamlocationname: new FormItemModel({ caption: '功能位置', detailType: 'FORMITEM', name: 'eamlocationname', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        eamlocationid: new FormItemModel({ caption: '功能位置标识', detailType: 'FORMITEM', name: 'eamlocationid', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        eamapplyid: new FormItemModel({ caption: '维护申请标识', detailType: 'FORMITEM', name: 'eamapplyid', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        assetid: new FormItemModel({ caption: '资产标识', detailType: 'FORMITEM', name: 'assetid', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

        eamapplytypeid: new FormItemModel({ caption: '维护申请类型标识', detailType: 'FORMITEM', name: 'eamapplytypeid', visible: true, isShowCaption: true, form: this, showMoreMode: 0, disabled: false, enableCond: 3 }),

    };
}