import { Subject } from 'rxjs';
import { PickupViewBase } from '@/studio-core';
import EAMLocationService from '@/service/eamlocation/eamlocation-service';
import EAMLocationAuthService from '@/authservice/eamlocation/eamlocation-auth-service';
import PickupViewEngine from '@engine/view/pickup-view-engine';
import EAMLocationUIService from '@/uiservice/eamlocation/eamlocation-ui-service';

/**
 * 功能位置数据选择视图视图基类
 *
 * @export
 * @class EAMLocationPickupViewBase
 * @extends {PickupViewBase}
 */
export class EAMLocationPickupViewBase extends PickupViewBase {
    /**
     * 视图对应应用实体名称
     *
     * @protected
     * @type {string}
     * @memberof EAMLocationPickupViewBase
     */
    protected appDeName: string = 'eamlocation';

    /**
     * 应用实体主键
     *
     * @protected
     * @type {string}
     * @memberof EAMLocationPickupViewBase
     */
    protected appDeKey: string = 'eamlocationid';

    /**
     * 应用实体主信息
     *
     * @protected
     * @type {string}
     * @memberof EAMLocationPickupViewBase
     */
    protected appDeMajor: string = 'eamlocationname';

    /**
     * 实体服务对象
     *
     * @type {EAMLocationService}
     * @memberof EAMLocationPickupViewBase
     */
    protected appEntityService: EAMLocationService = new EAMLocationService;

    /**
     * 实体权限服务对象
     *
     * @type EAMLocationUIService
     * @memberof EAMLocationPickupViewBase
     */
    public appUIService: EAMLocationUIService = new EAMLocationUIService(this.$store);


    /**
     * 计数器服务对象集合
     *
     * @protected
     * @type {Array<*>}
     * @memberof EAMLocationPickupViewBase
     */    
    protected counterServiceArray: Array<any> = [];

    /**
     * 视图模型数据
     *
     * @protected
     * @type {*}
     * @memberof EAMLocationPickupViewBase
     */
    protected model: any = {
        srfCaption: 'entities.eamlocation.views.pickupview.caption',
        srfTitle: 'entities.eamlocation.views.pickupview.title',
        srfSubTitle: 'entities.eamlocation.views.pickupview.subtitle',
        dataInfo: ''
    }

    /**
     * 容器模型
     *
     * @protected
     * @type {*}
     * @memberof EAMLocationPickupViewBase
     */
    protected containerModel: any = {
        view_pickupviewpanel: { name: 'pickupviewpanel', type: 'PICKUPVIEWPANEL' },
        view_okbtn: { name: 'okbtn', type: 'button', text: '确定', disabled: true },
        view_cancelbtn: { name: 'cancelbtn', type: 'button', text: '取消', disabled: false },
        view_leftbtn: { name: 'leftbtn', type: 'button', text: '左移', disabled: true },
        view_rightbtn: { name: 'rightbtn', type: 'button', text: '右移', disabled: true },
        view_allleftbtn: { name: 'allleftbtn', type: 'button', text: '全部左移', disabled: true },
        view_allrightbtn: { name: 'allrightbtn', type: 'button', text: '全部右移', disabled: true },
    };


	/**
     * 视图唯一标识
     *
     * @protected
     * @type {string}
     * @memberof ViewBase
     */
	protected viewtag: string = '2b28313d0f3925fa44b8683eb5ea54d6';


    /**
     * 视图引擎
     *
     * @public
     * @type {Engine}
     * @memberof EAMLocationPickupViewBase
     */
    public engine: PickupViewEngine = new PickupViewEngine();

    /**
     * 引擎初始化
     *
     * @public
     * @memberof EAMLocationPickupViewBase
     */
    public engineInit(): void {
        this.engine.init({
            view: this,
            pickupviewpanel: this.$refs.pickupviewpanel,
            keyPSDEField: 'eamlocation',
            majorPSDEField: 'eamlocationname',
            isLoadDefault: true,
        });
    }

    /**
     * pickupviewpanel 部件 selectionchange 事件
     *
     * @param {*} [args={}]
     * @param {*} $event
     * @memberof EAMLocationPickupViewBase
     */
    public pickupviewpanel_selectionchange($event: any, $event2?: any): void {
        this.engine.onCtrlEvent('pickupviewpanel', 'selectionchange', $event);
    }

    /**
     * pickupviewpanel 部件 activated 事件
     *
     * @param {*} [args={}]
     * @param {*} $event
     * @memberof EAMLocationPickupViewBase
     */
    public pickupviewpanel_activated($event: any, $event2?: any): void {
        this.engine.onCtrlEvent('pickupviewpanel', 'activated', $event);
    }

    /**
     * pickupviewpanel 部件 load 事件
     *
     * @param {*} [args={}]
     * @param {*} $event
     * @memberof EAMLocationPickupViewBase
     */
    public pickupviewpanel_load($event: any, $event2?: any): void {
        this.engine.onCtrlEvent('pickupviewpanel', 'load', $event);
    }


}