import { Subject } from 'rxjs';
import { EditViewBase } from '@/studio-core';
import EAMLocationService from '@/service/eamlocation/eamlocation-service';
import EAMLocationAuthService from '@/authservice/eamlocation/eamlocation-auth-service';
import EditViewEngine from '@engine/view/edit-view-engine';
import EAMLocationUIService from '@/uiservice/eamlocation/eamlocation-ui-service';

/**
 * 功能位置编辑视图视图基类
 *
 * @export
 * @class EAMLocationInfo_MainViewBase
 * @extends {EditViewBase}
 */
export class EAMLocationInfo_MainViewBase extends EditViewBase {
    /**
     * 视图对应应用实体名称
     *
     * @protected
     * @type {string}
     * @memberof EAMLocationInfo_MainViewBase
     */
    protected appDeName: string = 'eamlocation';

    /**
     * 应用实体主键
     *
     * @protected
     * @type {string}
     * @memberof EAMLocationInfo_MainViewBase
     */
    protected appDeKey: string = 'eamlocationid';

    /**
     * 应用实体主信息
     *
     * @protected
     * @type {string}
     * @memberof EAMLocationInfo_MainViewBase
     */
    protected appDeMajor: string = 'eamlocationname';

    /**
     * 实体服务对象
     *
     * @type {EAMLocationService}
     * @memberof EAMLocationInfo_MainViewBase
     */
    protected appEntityService: EAMLocationService = new EAMLocationService;

    /**
     * 实体权限服务对象
     *
     * @type EAMLocationUIService
     * @memberof EAMLocationInfo_MainViewBase
     */
    public appUIService: EAMLocationUIService = new EAMLocationUIService(this.$store);


    /**
     * 计数器服务对象集合
     *
     * @protected
     * @type {Array<*>}
     * @memberof EAMLocationInfo_MainViewBase
     */    
    protected counterServiceArray: Array<any> = [];

    /**
     * 视图模型数据
     *
     * @protected
     * @type {*}
     * @memberof EAMLocationInfo_MainViewBase
     */
    protected model: any = {
        srfCaption: 'entities.eamlocation.views.info_mainview.caption',
        srfTitle: 'entities.eamlocation.views.info_mainview.title',
        srfSubTitle: 'entities.eamlocation.views.info_mainview.subtitle',
        dataInfo: ''
    }

    /**
     * 容器模型
     *
     * @protected
     * @type {*}
     * @memberof EAMLocationInfo_MainViewBase
     */
    protected containerModel: any = {
        view_form: { name: 'form', type: 'FORM' },
    };


	/**
     * 视图唯一标识
     *
     * @protected
     * @type {string}
     * @memberof ViewBase
     */
	protected viewtag: string = 'a82c591e524f7289432a30a5ccfa8908';


    /**
     * 视图引擎
     *
     * @public
     * @type {Engine}
     * @memberof EAMLocationInfo_MainViewBase
     */
    public engine: EditViewEngine = new EditViewEngine();

    /**
     * 引擎初始化
     *
     * @public
     * @memberof EAMLocationInfo_MainViewBase
     */
    public engineInit(): void {
        this.engine.init({
            view: this,
            form: this.$refs.form,
            p2k: '0',
            keyPSDEField: 'eamlocation',
            majorPSDEField: 'eamlocationname',
            isLoadDefault: true,
        });
    }

    /**
     * form 部件 save 事件
     *
     * @param {*} [args={}]
     * @param {*} $event
     * @memberof EAMLocationInfo_MainViewBase
     */
    public form_save($event: any, $event2?: any): void {
        this.engine.onCtrlEvent('form', 'save', $event);
    }

    /**
     * form 部件 remove 事件
     *
     * @param {*} [args={}]
     * @param {*} $event
     * @memberof EAMLocationInfo_MainViewBase
     */
    public form_remove($event: any, $event2?: any): void {
        this.engine.onCtrlEvent('form', 'remove', $event);
    }

    /**
     * form 部件 load 事件
     *
     * @param {*} [args={}]
     * @param {*} $event
     * @memberof EAMLocationInfo_MainViewBase
     */
    public form_load($event: any, $event2?: any): void {
        this.engine.onCtrlEvent('form', 'load', $event);
    }


}