import Vue from 'vue';
import Router from 'vue-router';
import { AuthGuard } from '@/utils';
import qs from 'qs';
import { globalRoutes, indexRoutes} from '@/router'
import { AppService } from '@/studio-core/service/app-service/AppService';

Vue.use(Router);

const appService = new AppService();

const router = new Router({
    routes: [
        {
            path: '/appindexview/:appindexview?',
            beforeEnter: async (to: any, from: any, next: any) => {
                const routerParamsName = 'appindexview';
                const params: any = {};
                if (to.params && to.params[routerParamsName]) {
                    params[routerParamsName] = to.params[routerParamsName];
                }
                const url: string = '/appdata';
                await AuthGuard.getInstance().authGuard(url, params, router);
                appService.navHistory.indexMeta = {
                    caption: 'app.views.appindexview.title',
                    info:'',
                    viewType: 'APPINDEX',
                    parameters: [
                        { pathName: 'appindexview', parameterName: 'appindexview' },
                    ],
                    requireAuth: true,
                };
                next();
            },
            meta: {  
                caption: 'app.views.appindexview.title',
                info:'',
                viewType: 'APPINDEX',
                parameters: [
                    { pathName: 'appindexview', parameterName: 'appindexview' },
                ],
                requireAuth: true,
            },
            component: () => import('@pages/base/app-index-view/app-index-view.vue'),
            children: [
                {
                    path: 'eamlocationstatemodels/:eamlocationstatemodel?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.eamlocationstatemodel.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamlocationstatemodels', parameterName: 'eamlocationstatemodel' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/location/eamlocation-state-model-pickup-grid-view/eamlocation-state-model-pickup-grid-view.vue'),
                },
                {
                    path: 'eamlocationstatemodellines/:eamlocationstatemodelline?/editview/:editview?',
                    meta: {
                        caption: 'entities.eamlocationstatemodelline.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamlocationstatemodellines', parameterName: 'eamlocationstatemodelline' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/location/eamlocation-state-model-line-edit-view/eamlocation-state-model-line-edit-view.vue'),
                },
                {
                    path: 'eamlocations/:eamlocation?/childgridview/:childgridview?',
                    meta: {
                        caption: 'entities.eamlocation.views.childgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamlocations', parameterName: 'eamlocation' },
                            { pathName: 'childgridview', parameterName: 'childgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/location/eamlocation-child-grid-view/eamlocation-child-grid-view.vue'),
                },
                {
                    path: 'eamlocations/:eamlocation?/infoview/:infoview?',
                    meta: {
                        caption: 'entities.eamlocation.views.infoview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamlocations', parameterName: 'eamlocation' },
                            { pathName: 'infoview', parameterName: 'infoview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/location/eamlocation-info-view/eamlocation-info-view.vue'),
                },
                {
                    path: 'eamlocationtypes/:eamlocationtype?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.eamlocationtype.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamlocationtypes', parameterName: 'eamlocationtype' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/location/eamlocation-type-pickup-grid-view/eamlocation-type-pickup-grid-view.vue'),
                },
                {
                    path: 'eamlocationstates/:eamlocationstate?/listexpview/:listexpview?',
                    meta: {
                        caption: 'entities.eamlocationstate.views.listexpview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamlocationstates', parameterName: 'eamlocationstate' },
                            { pathName: 'listexpview', parameterName: 'listexpview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/location/eamlocation-state-list-exp-view/eamlocation-state-list-exp-view.vue'),
                },
                {
                    path: 'eamlocations/:eamlocation?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.eamlocation.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamlocations', parameterName: 'eamlocation' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/location/eamlocation-pickup-view/eamlocation-pickup-view.vue'),
                },
                {
                    path: 'eamlocationstatemodellines/:eamlocationstatemodelline?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.eamlocationstatemodelline.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamlocationstatemodellines', parameterName: 'eamlocationstatemodelline' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/location/eamlocation-state-model-line-grid-view/eamlocation-state-model-line-grid-view.vue'),
                },
                {
                    path: 'eamlocationtypes/:eamlocationtype?/editview/:editview?',
                    meta: {
                        caption: 'entities.eamlocationtype.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamlocationtypes', parameterName: 'eamlocationtype' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/location/eamlocation-type-edit-view/eamlocation-type-edit-view.vue'),
                },
                {
                    path: 'eamlocationstates/:eamlocationstate?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.eamlocationstate.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamlocationstates', parameterName: 'eamlocationstate' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/location/eamlocation-state-pickup-view/eamlocation-state-pickup-view.vue'),
                },
                {
                    path: 'eamlocationstatemodels/:eamlocationstatemodel?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.eamlocationstatemodel.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamlocationstatemodels', parameterName: 'eamlocationstatemodel' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/location/eamlocation-state-model-pickup-view/eamlocation-state-model-pickup-view.vue'),
                },
                {
                    path: 'eamlocations/:eamlocation?/info_mainview/:info_mainview?',
                    meta: {
                        caption: 'entities.eamlocation.views.info_mainview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamlocations', parameterName: 'eamlocation' },
                            { pathName: 'info_mainview', parameterName: 'info_mainview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/location/eamlocation-info-main-view/eamlocation-info-main-view.vue'),
                },
                {
                    path: 'eamlocations/:eamlocation?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.eamlocation.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamlocations', parameterName: 'eamlocation' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/location/eamlocation-pickup-grid-view/eamlocation-pickup-grid-view.vue'),
                },
                {
                    path: 'eamlocations/:eamlocation?/summaryview/:summaryview?',
                    meta: {
                        caption: 'entities.eamlocation.views.summaryview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamlocations', parameterName: 'eamlocation' },
                            { pathName: 'summaryview', parameterName: 'summaryview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/location/eamlocation-summary-view/eamlocation-summary-view.vue'),
                },
                {
                    path: 'eamlocationtypes/:eamlocationtype?/pickupview/:pickupview?',
                    meta: {
                        caption: 'entities.eamlocationtype.views.pickupview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamlocationtypes', parameterName: 'eamlocationtype' },
                            { pathName: 'pickupview', parameterName: 'pickupview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/location/eamlocation-type-pickup-view/eamlocation-type-pickup-view.vue'),
                },
                {
                    path: 'eamassetstates/:eamassetstate?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.eamassetstate.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamassetstates', parameterName: 'eamassetstate' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/asset/eamasset-state-grid-view/eamasset-state-grid-view.vue'),
                },
                {
                    path: 'eamlocations/:eamlocation?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.eamlocation.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamlocations', parameterName: 'eamlocation' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/location/eamlocation-grid-view/eamlocation-grid-view.vue'),
                },
                {
                    path: 'eamlocations/:eamlocation?/editview/:editview?',
                    meta: {
                        caption: 'entities.eamlocation.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamlocations', parameterName: 'eamlocation' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/location/eamlocation-edit-view/eamlocation-edit-view.vue'),
                },
                {
                    path: 'eamlocationtypes/:eamlocationtype?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.eamlocationtype.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamlocationtypes', parameterName: 'eamlocationtype' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/location/eamlocation-type-grid-view/eamlocation-type-grid-view.vue'),
                },
                {
                    path: 'eamlocationstates/:eamlocationstate?/editview/:editview?',
                    meta: {
                        caption: 'entities.eamlocationstate.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamlocationstates', parameterName: 'eamlocationstate' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/location/eamlocation-state-edit-view/eamlocation-state-edit-view.vue'),
                },
                {
                    path: 'eamlocationstatemodels/:eamlocationstatemodel?/gridview/:gridview?',
                    meta: {
                        caption: 'entities.eamlocationstatemodel.views.gridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamlocationstatemodels', parameterName: 'eamlocationstatemodel' },
                            { pathName: 'gridview', parameterName: 'gridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/location/eamlocation-state-model-grid-view/eamlocation-state-model-grid-view.vue'),
                },
                {
                    path: 'eamassetstates/:eamassetstate?/editview/:editview?',
                    meta: {
                        caption: 'entities.eamassetstate.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamassetstates', parameterName: 'eamassetstate' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/asset/eamasset-state-edit-view/eamasset-state-edit-view.vue'),
                },
                {
                    path: 'eamlocationstates/:eamlocationstate?/pickupgridview/:pickupgridview?',
                    meta: {
                        caption: 'entities.eamlocationstate.views.pickupgridview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamlocationstates', parameterName: 'eamlocationstate' },
                            { pathName: 'pickupgridview', parameterName: 'pickupgridview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/location/eamlocation-state-pickup-grid-view/eamlocation-state-pickup-grid-view.vue'),
                },
                {
                    path: 'eamlocationstatemodels/:eamlocationstatemodel?/editview/:editview?',
                    meta: {
                        caption: 'entities.eamlocationstatemodel.views.editview.title',
                        info:'',
                        parameters: [
                            { pathName: 'appindexview', parameterName: 'appindexview' },
                            { pathName: 'eamlocationstatemodels', parameterName: 'eamlocationstatemodel' },
                            { pathName: 'editview', parameterName: 'editview' },
                        ],
                        requireAuth: true,
                    },
                    component: () => import('@pages/location/eamlocation-state-model-edit-view/eamlocation-state-model-edit-view.vue'),
                },
            ...indexRoutes,
            ],
        },
        ...globalRoutes,
        {
            path: '/login/:login?',
            name: 'login',
            meta: {  
                caption: '登录',
                viewType: 'login',
                requireAuth: false,
                ignoreAddPage: true,
            },
            beforeEnter: (to: any, from: any, next: any) => {
                appService.navHistory.reset();
                next();
            },
            component: () => import('@components/login/login'),
        },
        {
            path: '/404',
            component: () => import('@components/404/404.vue')
        },
        {
            path: '/500',
            component: () => import('@components/500/500.vue')
        },
        {
            path: '*',
            redirect: 'appindexview'
        }
    ]
});

router.beforeEach((to: any, from: any, next: any) => {
    if (to.meta && !to.meta.ignoreAddPage) {
        appService.navHistory.add(to);
    }
    next();
});

export default router;