/**
 * Main 部件模型
 *
 * @export
 * @class MainModel
 */
export default class MainModel {

	/**
	 * 是否是实体数据导出
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public isDEExport: boolean = false;

	/**
	 * 获取数据项集合
	 *
	 * @returns {any[]}
	 * @memberof MainGridMode
	 */
	public getDataItems(): any[] {
    if(this.isDEExport){
		  return [
      ]
    }else{
		  return [
        {
          name: 'eamlocationid',
          prop: 'eamlocationid',
          dataType: 'PICKUP',
        },
        {
          name: 'eamlocationname',
          prop: 'eamlocationname',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'mdate',
          prop: 'mdate',
          dataType: 'DATETIME',
        },
        {
          name: 'eammonitorpointid',
          prop: 'eammonitorpointid',
          dataType: 'PICKUP',
        },
        {
          name: 'plannumber',
          prop: 'plannumber',
          dataType: 'TEXT',
        },
        {
          name: 'srfmajortext',
          prop: 'eamplanname',
          dataType: 'TEXT',
        },
        {
          name: 'assetid',
          prop: 'assetid',
          dataType: 'PICKUP',
        },
        {
          name: 'srfdataaccaction',
          prop: 'eamplanid',
          dataType: 'GUID',
        },
        {
          name: 'srfkey',
          prop: 'eamplanid',
          dataType: 'GUID',
          isEditable:true
        },
        {
          name: 'eamplanname',
          prop: 'eamplanname',
          dataType: 'TEXT',
        },
        {
          name: 'assetname',
          prop: 'assetname',
          dataType: 'PICKUPTEXT',
        },
        {
          name: 'eamplan',
          prop: 'eamplanid',
        },

        {
          name:'size',
          prop:'size'
        },
        {
          name:'query',
          prop:'query'
        },
        {
          name:'filter',
          prop:'filter'
        },
        {
          name:'page',
          prop:'page'
        },
        {
          name:'sort',
          prop:'sort'
        },
        {
          name:'srfparentdata',
          prop:'srfparentdata'
        },
        // 前端新增修改标识，新增为"0",修改为"1"或未设值
        {
          name: 'srffrontuf',
          prop: 'srffrontuf',
          dataType: 'TEXT',
        },
      ]
    }
  }

}