/**
 * UI服务注册中心
 *
 * @export
 * @class UIServiceRegister
 */
export class UIServiceRegister {

    /**
     * 所有UI实体服务Map
     *
     * @protected
     * @type {*}
     * @memberof UIServiceRegister
     */
    protected allUIService: Map<string, () => Promise<any>> = new Map();

    /**
     * 已加载UI实体服务Map缓存
     *
     * @protected
     * @type {Map<string, any>}
     * @memberof UIServiceRegister
     */
    protected serviceCache: Map<string, any> = new Map();

    /**
     * Creates an instance of UIServiceRegister.
     * @memberof UIServiceRegister
     */
    constructor() {
        this.init();
    }

    /**
     * 初始化
     *
     * @protected
     * @memberof UIServiceRegister
     */
    protected init(): void {
                this.allUIService.set('eamlocationstatemodel', () => import('@/uiservice/eamlocation-state-model/eamlocation-state-model-ui-service'));
        this.allUIService.set('eamlocationtype', () => import('@/uiservice/eamlocation-type/eamlocation-type-ui-service'));
        this.allUIService.set('eamlocation', () => import('@/uiservice/eamlocation/eamlocation-ui-service'));
        this.allUIService.set('eamassetstate', () => import('@/uiservice/eamasset-state/eamasset-state-ui-service'));
        this.allUIService.set('eamlocationstate', () => import('@/uiservice/eamlocation-state/eamlocation-state-ui-service'));
        this.allUIService.set('eamassettype', () => import('@/uiservice/eamasset-type/eamasset-type-ui-service'));
        this.allUIService.set('eamassetstatemodelline', () => import('@/uiservice/eamasset-state-model-line/eamasset-state-model-line-ui-service'));
        this.allUIService.set('eamapplytype', () => import('@/uiservice/eamapply-type/eamapply-type-ui-service'));
        this.allUIService.set('eamproduct', () => import('@/uiservice/eamproduct/eamproduct-ui-service'));
        this.allUIService.set('eamservicelevel', () => import('@/uiservice/eamservice-level/eamservice-level-ui-service'));
        this.allUIService.set('eamsparepartspro', () => import('@/uiservice/eamspare-parts-pro/eamspare-parts-pro-ui-service'));
        this.allUIService.set('eamapplystatemodelline', () => import('@/uiservice/eamapply-state-model-line/eamapply-state-model-line-ui-service'));
        this.allUIService.set('eamsparepartsgroup', () => import('@/uiservice/eamspare-parts-group/eamspare-parts-group-ui-service'));
        this.allUIService.set('eamlocationstatemodelline', () => import('@/uiservice/eamlocation-state-model-line/eamlocation-state-model-line-ui-service'));
        this.allUIService.set('eamassetpartsgroup', () => import('@/uiservice/eamasset-parts-group/eamasset-parts-group-ui-service'));
        this.allUIService.set('eamasset', () => import('@/uiservice/eamasset/eamasset-ui-service'));
        this.allUIService.set('eamapplystate', () => import('@/uiservice/eamapply-state/eamapply-state-ui-service'));
        this.allUIService.set('eamapply', () => import('@/uiservice/eamapply/eamapply-ui-service'));
        this.allUIService.set('eamassetstatemodel', () => import('@/uiservice/eamasset-state-model/eamasset-state-model-ui-service'));
    }

    /**
     * 加载服务实体
     *
     * @protected
     * @param {string} serviceName
     * @returns {Promise<any>}
     * @memberof UIServiceRegister
     */
    protected async loadService(serviceName: string): Promise<any> {
        const service = this.allUIService.get(serviceName);
        if (service) {
            return service();
        }
    }

    /**
     * 获取应用实体服务
     *
     * @param {string} name
     * @returns {Promise<any>}
     * @memberof UIServiceRegister
     */
    public async getService(name: string): Promise<any> {
        if (this.serviceCache.has(name)) {
            return this.serviceCache.get(name);
        }
        const entityService: any = await this.loadService(name);
        if (entityService && entityService.default) {
            const instance: any = new entityService.default();
            this.serviceCache.set(name, instance);
            return instance;
        }
    }

}
export const uiServiceRegister: UIServiceRegister = new UIServiceRegister();