import AuthService from '../auth-service';

/**
 * 资产状态模型明细权限服务对象基类
 *
 * @export
 * @class EAMAssetStateModelLineAuthServiceBase
 * @extends {AuthService}
 */
export default class EAMAssetStateModelLineAuthServiceBase extends AuthService {

    /**
     * Creates an instance of  EAMAssetStateModelLineAuthServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  EAMAssetStateModelLineAuthServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
    }

    /**
     * 根据当前数据获取实体操作标识
     *
     * @param {*} mainSateOPPrivs 传入数据操作标识
     * @returns {any}
     * @memberof EAMAssetStateModelLineAuthServiceBase
     */
    public getOPPrivs(mainSateOPPrivs:any):any{
        let curDefaultOPPrivs:any = JSON.parse(JSON.stringify(this.defaultOPPrivs));
        if(mainSateOPPrivs){
            Object.assign(curDefaultOPPrivs,mainSateOPPrivs);
        }
        return curDefaultOPPrivs;
    }

}