import { UIActionContext } from "@/logic/ui-logic";
import { LogicReturnType } from "@/logic/const/logic-return-type";
import { UILogicParamType } from "@/logic/const/ui-logic-param-type";
import { Util, Verify } from "@/utils";
import { AppMessageBox } from "@/utils/app-message-box/app-message-box";
import { Subject } from "rxjs";
import { Environment } from "@/environments/environment";
/**
 * 编辑
 *
 * @export
 * @class CustomEditUILogicBase
 */
export default class CustomEditUILogicBase {

    /**
     * Creates an instance of  CustomEditBase.
     * 
     * @param {*} [opts={}]
     * @memberof CustomEditUILogicBase
     */
    constructor(opts: any = {}) { }

    /**
     * 逻辑参数
     *
     * @protected
     * @type {any[]}
     * @memberof CustomEditUILogicBase
     */
    protected logicParams: any[] = [
        {
            name: '传入变量',
            codeName: 'Default',
            default: true,
            entityParam: true,
        },
        {
            name: '当前表格部件',
            codeName: 'grid',
            ctrlParam: true,
        },
        {
            name: '当前视图',
            codeName: 'view',
            activeViewParam: true,
        },
        {
            name: '表格数据',
            codeName: 'gridData',
            entityListParam: true,
        },
        {
            name: '当前容器',
            codeName: 'currentContainer',
            activeContainerParam: true,
        },
    ];

    /**
     * 执行前
     *
     * @param {*} args
     * @param {*} [context={}]
     * @param {*} [params={}]
     * @param {*} [$event]
     * @param {*} [xData]
     * @param {*} [actioncontext]
     * @param {string} [srfParentDeName]
     * @return {*} 
     * @memberof CustomEditUILogicBase
     */
    public beforeExecute(args: any, context: any = {}, params: any = {},
        $event?: any, xData?: any, actioncontext?: any, srfParentDeName?: string) {
        return new UIActionContext(this.logicParams, args, context, params, $event, xData, actioncontext, srfParentDeName)
    }

    /**
     * 执行
     *
     * @param {any[]} args
     * @param {*} [context={}]
     * @param {*} [params={}]
     * @param {*} [$event]
     * @param {*} [xData]
     * @param {*} [actionContext]
     * @param {string} [srfParentDeName]
     * @memberof CustomEditUILogicBase
     */
    async execute(args: any[], context:any = {} ,params: any = {}, $event?: any, xData?: any, actioncontext?: any, srfParentDeName?: string) {
        try {
            const actionContext = this.beforeExecute(args, context, params, $event, xData, actioncontext, srfParentDeName);
            await this.execute_begin_node(actionContext);
            return actionContext.getResult();
        } catch (error: any) {
            throw new Error(`${error && error.message ? error.message : '发生未知错误！'}`);
        }
    }

    /**
     * 获取条件参数
     *
     * @param {UIActionContext} actionContext 界面逻辑上下文
     * @param {string} param 节点参数
     * @param {string} property 参数属性
     * @return {*} 
     * @memberof CustomEditUILogicBase
     */
    public getCondParam(actionContext: UIActionContext, param: string, property: string) {
        const resultParam = actionContext.getParam(param).getReal();
        //  当不存在参数属性时，返回直接值
        if (property === '') {
            return resultParam;
        }
        if (resultParam && resultParam.hasOwnProperty(property)) {
            return resultParam[property];
        }
        return null;
    }

    /**
     * 开始
     *
     * @param {UIActionContext} actionContext 界面逻辑上下文
     * @memberof CustomEditUILogicBase
     */
    protected async execute_begin_node(actionContext: UIActionContext) {
        actionContext.setResult(actionContext.defaultParam.getReal());
        console.log('已完成执行 开始 节点');
        await this.execute_bindparam2_node(actionContext);
    }
    
    /**
     * 绑定表格选中数据
     *
     * @param {UIActionContext} actionContext 界面逻辑上下文
     * @memberof CustomEditUILogicBase
     */
    protected async execute_bindparam1_node(actionContext: UIActionContext) {
        try {
            //  源数据
            const srcParam = actionContext.getParam('grid');
            //  目标数据
            const dstParam = actionContext.getParam('gridData');
            //  源属性
            const srcFieldName: string = 'selections';
            if (srcFieldName) {
                dstParam.bind(srcParam.get(srcFieldName));
            } else {
                dstParam.bind(srcParam.getReal());
            }
            actionContext.bindLastReturnParam(null);
        } catch (error: any) {
            throw new Error(`逻辑参数表格数据 ${error && error.message ? error.message : '发生未知错误!'}`);
        }
        console.log('已完成执行 绑定表格选中数据 节点');
        await this.execute_deuiaction1_node(actionContext);
    }
    
    /**
     * 绑定表格
     *
     * @param {UIActionContext} actionContext 界面逻辑上下文
     * @memberof CustomEditUILogicBase
     */
    protected async execute_bindparam2_node(actionContext: UIActionContext) {
        try {
            //  源数据
            const srcParam = actionContext.getParam('view');
            //  目标数据
            const dstParam = actionContext.getParam('grid');
            //  源属性
            const srcFieldName: string = 'grid';
            if (srcFieldName) {
                dstParam.bind(srcParam.get(srcFieldName));
            } else {
                dstParam.bind(srcParam.getReal());
            }
            actionContext.bindLastReturnParam(null);
        } catch (error: any) {
            throw new Error(`逻辑参数当前表格部件 ${error && error.message ? error.message : '发生未知错误!'}`);
        }
        console.log('已完成执行 绑定表格 节点');
        await this.execute_bindparam1_node(actionContext);
    }
    
    /**
     * 界面行为
     *
     * @param {UIActionContext} actionContext 界面逻辑上下文
     * @memberof CustomEditUILogicBase
     */
    protected async execute_deuiaction1_node(actionContext: UIActionContext) {
        const data = actionContext.getParam('gridData').getReal();
        const { context, viewparams } = actionContext;
        const additionalParam = actionContext.additionalParam;
        const uiService = await window.uiServiceRegister.getService('ibizbook');
        if (uiService && uiService['IBIZBOOK_openCustomEditView'] && uiService['IBIZBOOK_openCustomEditView'] instanceof Function) {
            const xData = actionContext.activeCtrlParamName ? actionContext.getParam(actionContext.activeCtrlParamName).getReal() : additionalParam && additionalParam.xData ? additionalParam.xData : {};
            const container = actionContext.activeContainerParamName ? actionContext.getParam(actionContext.activeContainerParamName).getReal() : additionalParam && additionalParam.actioncontext ? additionalParam.actioncontext : {};
            const result = await uiService['IBIZBOOK_openCustomEditView'](
                Object.prototype.toString.call(data) === '[object Array]' ? data : [data],
                context,
                viewparams,
                additionalParam && additionalParam.$event ? additionalParam.$event : {},
                xData,
                container,
                additionalParam && additionalParam.parentDeName ? additionalParam.parentDeName : ''
            );
            if (result && result.ok && result.result) {
                actionContext.bindLastReturnParam(Array.isArray(result.result) ? result.result[0] : result.result);
            }
        }
        console.log('已完成执行 界面行为 节点');
        await this.execute_end1_node(actionContext);
    }
    
    /**
     * 结束
     *
     * @param {UIActionContext} actionContext 界面逻辑上下文
     * @memberof CustomEditUILogicBase
     */
    protected async execute_end1_node(actionContext: UIActionContext) {
        const strReturnType: string = 'NULLVALUE';
        if (Object.is(strReturnType, LogicReturnType.NONEVALUE) || Object.is(strReturnType, LogicReturnType.NULLVALUE)) {
            actionContext.setResult(null);
        } else if (Object.is(strReturnType, LogicReturnType.SRCVALUE)) {
            actionContext.setResult('');
        } else if (Object.is(strReturnType, LogicReturnType.BREAK)) {
            actionContext.setResult(LogicReturnType.BREAK);
        } else if (Object.is(strReturnType, LogicReturnType.LOGICPARAM) || Object.is(strReturnType, LogicReturnType.LOGICPARAMFIELD)) {
            const returnParam = actionContext.getParam('');
            if (Object.is(strReturnType, LogicReturnType.LOGICPARAM)) {
                actionContext.setResult(returnParam.getReal());
            } else {
                actionContext.setResult(returnParam.get(''));
            }
        } else {
            throw new Error(`无法识别的返回值类型${strReturnType}`);
        }
        console.log('已完成执行 结束 节点');
    }
    

}