package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.IBIZAPPVIEW;
import cn.ibizlab.core.sample.service.IIBIZAPPVIEWService;
import cn.ibizlab.core.sample.filter.IBIZAPPVIEWSearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"应用视图" })
@RestController("DemoAPI-ibizappview")
@RequestMapping("")
public class IBIZAPPVIEWResource {

    @Autowired
    public IIBIZAPPVIEWService ibizappviewService;

    @Autowired
    @Lazy
    public IBIZAPPVIEWMapping ibizappviewMapping;

    @PreAuthorize("hasPermission(this.ibizappviewMapping.toDomain(#ibizappviewdto),'DemoSys-IBIZAPPVIEW-Create')")
    @ApiOperation(value = "新建应用视图", tags = {"应用视图" },  notes = "新建应用视图")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizappviews")
    public ResponseEntity<IBIZAPPVIEWDTO> create(@Validated @RequestBody IBIZAPPVIEWDTO ibizappviewdto) {
        IBIZAPPVIEW domain = ibizappviewMapping.toDomain(ibizappviewdto);
		ibizappviewService.create(domain);
        IBIZAPPVIEWDTO dto = ibizappviewMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizappviewMapping.toDomain(#ibizappviewdtos),'DemoSys-IBIZAPPVIEW-Create')")
    @ApiOperation(value = "批量新建应用视图", tags = {"应用视图" },  notes = "批量新建应用视图")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizappviews/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBIZAPPVIEWDTO> ibizappviewdtos) {
        ibizappviewService.createBatch(ibizappviewMapping.toDomain(ibizappviewdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @VersionCheck(entity = "ibizappview" , versionfield = "updatedate")
    @PreAuthorize("hasPermission(this.ibizappviewService.get(#ibizappview_id),'DemoSys-IBIZAPPVIEW-Update')")
    @ApiOperation(value = "更新应用视图", tags = {"应用视图" },  notes = "更新应用视图")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizappviews/{ibizappview_id}")
    public ResponseEntity<IBIZAPPVIEWDTO> update(@PathVariable("ibizappview_id") String ibizappview_id, @RequestBody IBIZAPPVIEWDTO ibizappviewdto) {
		IBIZAPPVIEW domain  = ibizappviewMapping.toDomain(ibizappviewdto);
        domain .setIbizappviewid(ibizappview_id);
		ibizappviewService.update(domain );
		IBIZAPPVIEWDTO dto = ibizappviewMapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizappviewService.getIbizappviewByEntities(this.ibizappviewMapping.toDomain(#ibizappviewdtos)),'DemoSys-IBIZAPPVIEW-Update')")
    @ApiOperation(value = "批量更新应用视图", tags = {"应用视图" },  notes = "批量更新应用视图")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizappviews/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBIZAPPVIEWDTO> ibizappviewdtos) {
        ibizappviewService.updateBatch(ibizappviewMapping.toDomain(ibizappviewdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.ibizappviewService.get(#ibizappview_id),'DemoSys-IBIZAPPVIEW-Remove')")
    @ApiOperation(value = "删除应用视图", tags = {"应用视图" },  notes = "删除应用视图")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizappviews/{ibizappview_id}")
    public ResponseEntity<Boolean> remove(@PathVariable("ibizappview_id") String ibizappview_id) {
         return ResponseEntity.status(HttpStatus.OK).body(ibizappviewService.remove(ibizappview_id));
    }

    @PreAuthorize("hasPermission(this.ibizappviewService.getIbizappviewByIds(#ids),'DemoSys-IBIZAPPVIEW-Remove')")
    @ApiOperation(value = "批量删除应用视图", tags = {"应用视图" },  notes = "批量删除应用视图")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizappviews/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibizappviewService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PostAuthorize("hasPermission(this.ibizappviewMapping.toDomain(returnObject.body),'DemoSys-IBIZAPPVIEW-Get')")
    @ApiOperation(value = "获取应用视图", tags = {"应用视图" },  notes = "获取应用视图")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizappviews/{ibizappview_id}")
    public ResponseEntity<IBIZAPPVIEWDTO> get(@PathVariable("ibizappview_id") String ibizappview_id) {
        IBIZAPPVIEW domain = ibizappviewService.get(ibizappview_id);
        IBIZAPPVIEWDTO dto = ibizappviewMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "获取应用视图草稿", tags = {"应用视图" },  notes = "获取应用视图草稿")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizappviews/getdraft")
    public ResponseEntity<IBIZAPPVIEWDTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(ibizappviewMapping.toDto(ibizappviewService.getDraft(new IBIZAPPVIEW())));
    }

    @ApiOperation(value = "检查应用视图", tags = {"应用视图" },  notes = "检查应用视图")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizappviews/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody IBIZAPPVIEWDTO ibizappviewdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(ibizappviewService.checkKey(ibizappviewMapping.toDomain(ibizappviewdto)));
    }

    @PreAuthorize("hasPermission(this.ibizappviewMapping.toDomain(#ibizappviewdto),'DemoSys-IBIZAPPVIEW-Save')")
    @ApiOperation(value = "保存应用视图", tags = {"应用视图" },  notes = "保存应用视图")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizappviews/save")
    public ResponseEntity<Boolean> save(@RequestBody IBIZAPPVIEWDTO ibizappviewdto) {
        return ResponseEntity.status(HttpStatus.OK).body(ibizappviewService.save(ibizappviewMapping.toDomain(ibizappviewdto)));
    }

    @PreAuthorize("hasPermission(this.ibizappviewMapping.toDomain(#ibizappviewdtos),'DemoSys-IBIZAPPVIEW-Save')")
    @ApiOperation(value = "批量保存应用视图", tags = {"应用视图" },  notes = "批量保存应用视图")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizappviews/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBIZAPPVIEWDTO> ibizappviewdtos) {
        ibizappviewService.saveBatch(ibizappviewMapping.toDomain(ibizappviewdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZAPPVIEW-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZAPPVIEW-Get')")
	@ApiOperation(value = "获取数据集", tags = {"应用视图" } ,notes = "获取数据集")
    @RequestMapping(method= RequestMethod.GET , value="/ibizappviews/fetchdefault")
	public ResponseEntity<List<IBIZAPPVIEWDTO>> fetchDefault(IBIZAPPVIEWSearchContext context) {
        Page<IBIZAPPVIEW> domains = ibizappviewService.searchDefault(context) ;
        List<IBIZAPPVIEWDTO> list = ibizappviewMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZAPPVIEW-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZAPPVIEW-Get')")
	@ApiOperation(value = "查询数据集", tags = {"应用视图" } ,notes = "查询数据集")
    @RequestMapping(method= RequestMethod.POST , value="/ibizappviews/searchdefault")
	public ResponseEntity<Page<IBIZAPPVIEWDTO>> searchDefault(@RequestBody IBIZAPPVIEWSearchContext context) {
        Page<IBIZAPPVIEW> domains = ibizappviewService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(ibizappviewMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


}

