package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.IBIZSample0006;
import cn.ibizlab.core.sample.service.IIBIZSample0006Service;
import cn.ibizlab.core.sample.filter.IBIZSample0006SearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"嵌套流程（主）" })
@RestController("DemoAPI-ibizsample0006")
@RequestMapping("")
public class IBIZSample0006Resource {

    @Autowired
    public IIBIZSample0006Service ibizsample0006Service;

    @Autowired
    @Lazy
    public IBIZSample0006Mapping ibizsample0006Mapping;

    @PreAuthorize("hasPermission(this.ibizsample0006Mapping.toDomain(#ibizsample0006dto),'DemoSys-IBIZSample0006-Create')")
    @ApiOperation(value = "新建嵌套流程（主）", tags = {"嵌套流程（主）" },  notes = "新建嵌套流程（主）")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0006s")
    public ResponseEntity<IBIZSample0006DTO> create(@Validated @RequestBody IBIZSample0006DTO ibizsample0006dto) {
        IBIZSample0006 domain = ibizsample0006Mapping.toDomain(ibizsample0006dto);
		ibizsample0006Service.create(domain);
        IBIZSample0006DTO dto = ibizsample0006Mapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizsample0006Mapping.toDomain(#ibizsample0006dtos),'DemoSys-IBIZSample0006-Create')")
    @ApiOperation(value = "批量新建嵌套流程（主）", tags = {"嵌套流程（主）" },  notes = "批量新建嵌套流程（主）")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0006s/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBIZSample0006DTO> ibizsample0006dtos) {
        ibizsample0006Service.createBatch(ibizsample0006Mapping.toDomain(ibizsample0006dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @VersionCheck(entity = "ibizsample0006" , versionfield = "updatedate")
    @PreAuthorize("hasPermission(this.ibizsample0006Service.get(#ibizsample0006_id),'DemoSys-IBIZSample0006-Update')")
    @ApiOperation(value = "更新嵌套流程（主）", tags = {"嵌套流程（主）" },  notes = "更新嵌套流程（主）")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizsample0006s/{ibizsample0006_id}")
    public ResponseEntity<IBIZSample0006DTO> update(@PathVariable("ibizsample0006_id") String ibizsample0006_id, @RequestBody IBIZSample0006DTO ibizsample0006dto) {
		IBIZSample0006 domain  = ibizsample0006Mapping.toDomain(ibizsample0006dto);
        domain .setIbizsample0006id(ibizsample0006_id);
		ibizsample0006Service.update(domain );
		IBIZSample0006DTO dto = ibizsample0006Mapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizsample0006Service.getIbizsample0006ByEntities(this.ibizsample0006Mapping.toDomain(#ibizsample0006dtos)),'DemoSys-IBIZSample0006-Update')")
    @ApiOperation(value = "批量更新嵌套流程（主）", tags = {"嵌套流程（主）" },  notes = "批量更新嵌套流程（主）")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizsample0006s/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBIZSample0006DTO> ibizsample0006dtos) {
        ibizsample0006Service.updateBatch(ibizsample0006Mapping.toDomain(ibizsample0006dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.ibizsample0006Service.get(#ibizsample0006_id),'DemoSys-IBIZSample0006-Remove')")
    @ApiOperation(value = "删除嵌套流程（主）", tags = {"嵌套流程（主）" },  notes = "删除嵌套流程（主）")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizsample0006s/{ibizsample0006_id}")
    public ResponseEntity<Boolean> remove(@PathVariable("ibizsample0006_id") String ibizsample0006_id) {
         return ResponseEntity.status(HttpStatus.OK).body(ibizsample0006Service.remove(ibizsample0006_id));
    }

    @PreAuthorize("hasPermission(this.ibizsample0006Service.getIbizsample0006ByIds(#ids),'DemoSys-IBIZSample0006-Remove')")
    @ApiOperation(value = "批量删除嵌套流程（主）", tags = {"嵌套流程（主）" },  notes = "批量删除嵌套流程（主）")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizsample0006s/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibizsample0006Service.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PostAuthorize("hasPermission(this.ibizsample0006Mapping.toDomain(returnObject.body),'DemoSys-IBIZSample0006-Get')")
    @ApiOperation(value = "获取嵌套流程（主）", tags = {"嵌套流程（主）" },  notes = "获取嵌套流程（主）")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizsample0006s/{ibizsample0006_id}")
    public ResponseEntity<IBIZSample0006DTO> get(@PathVariable("ibizsample0006_id") String ibizsample0006_id) {
        IBIZSample0006 domain = ibizsample0006Service.get(ibizsample0006_id);
        IBIZSample0006DTO dto = ibizsample0006Mapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "获取嵌套流程（主）草稿", tags = {"嵌套流程（主）" },  notes = "获取嵌套流程（主）草稿")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizsample0006s/getdraft")
    public ResponseEntity<IBIZSample0006DTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(ibizsample0006Mapping.toDto(ibizsample0006Service.getDraft(new IBIZSample0006())));
    }

    @ApiOperation(value = "检查嵌套流程（主）", tags = {"嵌套流程（主）" },  notes = "检查嵌套流程（主）")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0006s/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody IBIZSample0006DTO ibizsample0006dto) {
        return  ResponseEntity.status(HttpStatus.OK).body(ibizsample0006Service.checkKey(ibizsample0006Mapping.toDomain(ibizsample0006dto)));
    }

    @PreAuthorize("hasPermission(this.ibizsample0006Mapping.toDomain(#ibizsample0006dto),'DemoSys-IBIZSample0006-Save')")
    @ApiOperation(value = "保存嵌套流程（主）", tags = {"嵌套流程（主）" },  notes = "保存嵌套流程（主）")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0006s/save")
    public ResponseEntity<Boolean> save(@RequestBody IBIZSample0006DTO ibizsample0006dto) {
        return ResponseEntity.status(HttpStatus.OK).body(ibizsample0006Service.save(ibizsample0006Mapping.toDomain(ibizsample0006dto)));
    }

    @PreAuthorize("hasPermission(this.ibizsample0006Mapping.toDomain(#ibizsample0006dtos),'DemoSys-IBIZSample0006-Save')")
    @ApiOperation(value = "批量保存嵌套流程（主）", tags = {"嵌套流程（主）" },  notes = "批量保存嵌套流程（主）")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0006s/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBIZSample0006DTO> ibizsample0006dtos) {
        ibizsample0006Service.saveBatch(ibizsample0006Mapping.toDomain(ibizsample0006dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0006-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZSample0006-Get')")
	@ApiOperation(value = "获取DEFAULT", tags = {"嵌套流程（主）" } ,notes = "获取DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/ibizsample0006s/fetchdefault")
	public ResponseEntity<List<IBIZSample0006DTO>> fetchDefault(IBIZSample0006SearchContext context) {
        Page<IBIZSample0006> domains = ibizsample0006Service.searchDefault(context) ;
        List<IBIZSample0006DTO> list = ibizsample0006Mapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.CREATED)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0006-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZSample0006-Get')")
	@ApiOperation(value = "查询DEFAULT", tags = {"嵌套流程（主）" } ,notes = "查询DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/ibizsample0006s/searchdefault")
	public ResponseEntity<Page<IBIZSample0006DTO>> searchDefault(@RequestBody IBIZSample0006SearchContext context) {
        Page<IBIZSample0006> domains = ibizsample0006Service.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.CREATED)
                .body(new PageImpl(ibizsample0006Mapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


}

