package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.IBIZSample0002;
import cn.ibizlab.core.sample.service.IIBIZSample0002Service;
import cn.ibizlab.core.sample.filter.IBIZSample0002SearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"示例实体02" })
@RestController("DemoAPI-ibizsample0002")
@RequestMapping("")
public class IBIZSample0002Resource {

    @Autowired
    public IIBIZSample0002Service ibizsample0002Service;

    @Autowired
    @Lazy
    public IBIZSample0002Mapping ibizsample0002Mapping;

    @PreAuthorize("hasPermission(this.ibizsample0002Mapping.toDomain(#ibizsample0002dto),'DemoSys-IBIZSample0002-Create')")
    @ApiOperation(value = "新建示例实体02", tags = {"示例实体02" },  notes = "新建示例实体02")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0002s")
    public ResponseEntity<IBIZSample0002DTO> create(@Validated @RequestBody IBIZSample0002DTO ibizsample0002dto) {
        IBIZSample0002 domain = ibizsample0002Mapping.toDomain(ibizsample0002dto);
		ibizsample0002Service.create(domain);
        IBIZSample0002DTO dto = ibizsample0002Mapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizsample0002Mapping.toDomain(#ibizsample0002dtos),'DemoSys-IBIZSample0002-Create')")
    @ApiOperation(value = "批量新建示例实体02", tags = {"示例实体02" },  notes = "批量新建示例实体02")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0002s/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBIZSample0002DTO> ibizsample0002dtos) {
        ibizsample0002Service.createBatch(ibizsample0002Mapping.toDomain(ibizsample0002dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @VersionCheck(entity = "ibizsample0002" , versionfield = "updatedate")
    @PreAuthorize("hasPermission(this.ibizsample0002Service.get(#ibizsample0002_id),'DemoSys-IBIZSample0002-Update')")
    @ApiOperation(value = "更新示例实体02", tags = {"示例实体02" },  notes = "更新示例实体02")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizsample0002s/{ibizsample0002_id}")
    public ResponseEntity<IBIZSample0002DTO> update(@PathVariable("ibizsample0002_id") String ibizsample0002_id, @RequestBody IBIZSample0002DTO ibizsample0002dto) {
		IBIZSample0002 domain  = ibizsample0002Mapping.toDomain(ibizsample0002dto);
        domain .setIbizsample0002id(ibizsample0002_id);
		ibizsample0002Service.update(domain );
		IBIZSample0002DTO dto = ibizsample0002Mapping.toDto(domain );
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizsample0002Service.getIbizsample0002ByEntities(this.ibizsample0002Mapping.toDomain(#ibizsample0002dtos)),'DemoSys-IBIZSample0002-Update')")
    @ApiOperation(value = "批量更新示例实体02", tags = {"示例实体02" },  notes = "批量更新示例实体02")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizsample0002s/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBIZSample0002DTO> ibizsample0002dtos) {
        ibizsample0002Service.updateBatch(ibizsample0002Mapping.toDomain(ibizsample0002dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasPermission(this.ibizsample0002Service.get(#ibizsample0002_id),'DemoSys-IBIZSample0002-Remove')")
    @ApiOperation(value = "删除示例实体02", tags = {"示例实体02" },  notes = "删除示例实体02")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizsample0002s/{ibizsample0002_id}")
    public ResponseEntity<Boolean> remove(@PathVariable("ibizsample0002_id") String ibizsample0002_id) {
         return ResponseEntity.status(HttpStatus.OK).body(ibizsample0002Service.remove(ibizsample0002_id));
    }

    @PreAuthorize("hasPermission(this.ibizsample0002Service.getIbizsample0002ByIds(#ids),'DemoSys-IBIZSample0002-Remove')")
    @ApiOperation(value = "批量删除示例实体02", tags = {"示例实体02" },  notes = "批量删除示例实体02")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizsample0002s/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibizsample0002Service.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PostAuthorize("hasPermission(this.ibizsample0002Mapping.toDomain(returnObject.body),'DemoSys-IBIZSample0002-Get')")
    @ApiOperation(value = "获取示例实体02", tags = {"示例实体02" },  notes = "获取示例实体02")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizsample0002s/{ibizsample0002_id}")
    public ResponseEntity<IBIZSample0002DTO> get(@PathVariable("ibizsample0002_id") String ibizsample0002_id) {
        IBIZSample0002 domain = ibizsample0002Service.get(ibizsample0002_id);
        IBIZSample0002DTO dto = ibizsample0002Mapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @ApiOperation(value = "获取示例实体02草稿", tags = {"示例实体02" },  notes = "获取示例实体02草稿")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizsample0002s/getdraft")
    public ResponseEntity<IBIZSample0002DTO> getDraft() {
        return ResponseEntity.status(HttpStatus.OK).body(ibizsample0002Mapping.toDto(ibizsample0002Service.getDraft(new IBIZSample0002())));
    }

    @ApiOperation(value = "检查示例实体02", tags = {"示例实体02" },  notes = "检查示例实体02")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0002s/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody IBIZSample0002DTO ibizsample0002dto) {
        return  ResponseEntity.status(HttpStatus.OK).body(ibizsample0002Service.checkKey(ibizsample0002Mapping.toDomain(ibizsample0002dto)));
    }

    @PreAuthorize("hasPermission(this.ibizsample0002Mapping.toDomain(#ibizsample0002dto),'DemoSys-IBIZSample0002-Save')")
    @ApiOperation(value = "保存示例实体02", tags = {"示例实体02" },  notes = "保存示例实体02")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0002s/save")
    public ResponseEntity<Boolean> save(@RequestBody IBIZSample0002DTO ibizsample0002dto) {
        return ResponseEntity.status(HttpStatus.OK).body(ibizsample0002Service.save(ibizsample0002Mapping.toDomain(ibizsample0002dto)));
    }

    @PreAuthorize("hasPermission(this.ibizsample0002Mapping.toDomain(#ibizsample0002dtos),'DemoSys-IBIZSample0002-Save')")
    @ApiOperation(value = "批量保存示例实体02", tags = {"示例实体02" },  notes = "批量保存示例实体02")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0002s/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBIZSample0002DTO> ibizsample0002dtos) {
        ibizsample0002Service.saveBatch(ibizsample0002Mapping.toDomain(ibizsample0002dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0002-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZSample0002-Get')")
	@ApiOperation(value = "获取DEFAULT", tags = {"示例实体02" } ,notes = "获取DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/ibizsample0002s/fetchdefault")
	public ResponseEntity<List<IBIZSample0002DTO>> fetchDefault(IBIZSample0002SearchContext context) {
        Page<IBIZSample0002> domains = ibizsample0002Service.searchDefault(context) ;
        List<IBIZSample0002DTO> list = ibizsample0002Mapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.CREATED)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0002-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZSample0002-Get')")
	@ApiOperation(value = "查询DEFAULT", tags = {"示例实体02" } ,notes = "查询DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/ibizsample0002s/searchdefault")
	public ResponseEntity<Page<IBIZSample0002DTO>> searchDefault(@RequestBody IBIZSample0002SearchContext context) {
        Page<IBIZSample0002> domains = ibizsample0002Service.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.CREATED)
                .body(new PageImpl(ibizsample0002Mapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}


}

