package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.IBIZSoftwareSuit;
import cn.ibizlab.core.sample.service.IIBIZSoftwareSuitService;
import cn.ibizlab.core.sample.filter.IBIZSoftwareSuitSearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"软件" })
@RestController("DemoAPI-ibizsoftwaresuit")
@RequestMapping("")
public class IBIZSoftwareSuitResource {

    @Autowired
    public IIBIZSoftwareSuitService ibizsoftwaresuitService;

    @Autowired
    @Lazy
    public IBIZSoftwareSuitMapping ibizsoftwaresuitMapping;

    @PreAuthorize("hasPermission(this.ibizsoftwaresuitMapping.toDomain(#ibizsoftwaresuitdto),'DemoSys-IBIZSoftwareSuit-Create')")
    @ApiOperation(value = "新建软件", tags = {"软件" },  notes = "新建软件")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsoftwaresuits")
    public ResponseEntity<IBIZSoftwareSuitDTO> create(@Validated @RequestBody IBIZSoftwareSuitDTO ibizsoftwaresuitdto) {
        IBIZSoftwareSuit domain = ibizsoftwaresuitMapping.toDomain(ibizsoftwaresuitdto);
		ibizsoftwaresuitService.create(domain);
        IBIZSoftwareSuitDTO dto = ibizsoftwaresuitMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizsoftwaresuitMapping.toDomain(#ibizsoftwaresuitdtos),'DemoSys-IBIZSoftwareSuit-Create')")
    @ApiOperation(value = "批量新建软件", tags = {"软件" },  notes = "批量新建软件")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsoftwaresuits/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBIZSoftwareSuitDTO> ibizsoftwaresuitdtos) {
        ibizsoftwaresuitService.createBatch(ibizsoftwaresuitMapping.toDomain(ibizsoftwaresuitdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PostAuthorize("hasPermission(this.ibizsoftwaresuitMapping.toDomain(returnObject.body),'DemoSys-IBIZSoftwareSuit-Get')")
    @ApiOperation(value = "获取软件", tags = {"软件" },  notes = "获取软件")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizsoftwaresuits/{ibizsoftwaresuit_id}")
    public ResponseEntity<IBIZSoftwareSuitDTO> get(@PathVariable("ibizsoftwaresuit_id") String ibizsoftwaresuit_id) {
        IBIZSoftwareSuit domain = ibizsoftwaresuitService.get(ibizsoftwaresuit_id);
        IBIZSoftwareSuitDTO dto = ibizsoftwaresuitMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizsoftwaresuitService.get(#ibizsoftwaresuit_id),'DemoSys-IBIZSoftwareSuit-Remove')")
    @ApiOperation(value = "删除软件", tags = {"软件" },  notes = "删除软件")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizsoftwaresuits/{ibizsoftwaresuit_id}")
    public ResponseEntity<Boolean> remove(@PathVariable("ibizsoftwaresuit_id") String ibizsoftwaresuit_id) {
         return ResponseEntity.status(HttpStatus.OK).body(ibizsoftwaresuitService.remove(ibizsoftwaresuit_id));
    }

    @PreAuthorize("hasPermission(this.ibizsoftwaresuitService.getIbizsoftwaresuitByIds(#ids),'DemoSys-IBIZSoftwareSuit-Remove')")
    @ApiOperation(value = "批量删除软件", tags = {"软件" },  notes = "批量删除软件")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizsoftwaresuits/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibizsoftwaresuitService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @VersionCheck(entity = "ibizsoftwaresuit" , versionfield = "updatedate")
    @PreAuthorize("hasPermission(this.ibizsoftwaresuitService.get(#ibizsoftwaresuit_id),'DemoSys-IBIZSoftwareSuit-Update')")
    @ApiOperation(value = "更新软件", tags = {"软件" },  notes = "更新软件")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizsoftwaresuits/{ibizsoftwaresuit_id}")
    public ResponseEntity<IBIZSoftwareSuitDTO> update(@PathVariable("ibizsoftwaresuit_id") String ibizsoftwaresuit_id, @RequestBody IBIZSoftwareSuitDTO ibizsoftwaresuitdto) {
		IBIZSoftwareSuit domain  = ibizsoftwaresuitMapping.toDomain(ibizsoftwaresuitdto);
        domain .setIbizsoftwaresuitid(ibizsoftwaresuit_id);
		ibizsoftwaresuitService.update(domain );
		IBIZSoftwareSuitDTO dto = ibizsoftwaresuitMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizsoftwaresuitService.getIbizsoftwaresuitByEntities(this.ibizsoftwaresuitMapping.toDomain(#ibizsoftwaresuitdtos)),'DemoSys-IBIZSoftwareSuit-Update')")
    @ApiOperation(value = "批量更新软件", tags = {"软件" },  notes = "批量更新软件")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizsoftwaresuits/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBIZSoftwareSuitDTO> ibizsoftwaresuitdtos) {
        ibizsoftwaresuitService.updateBatch(ibizsoftwaresuitMapping.toDomain(ibizsoftwaresuitdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "检查软件", tags = {"软件" },  notes = "检查软件")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsoftwaresuits/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody IBIZSoftwareSuitDTO ibizsoftwaresuitdto) {
        return  ResponseEntity.status(HttpStatus.OK).body(ibizsoftwaresuitService.checkKey(ibizsoftwaresuitMapping.toDomain(ibizsoftwaresuitdto)));
    }

    @ApiOperation(value = "获取软件草稿", tags = {"软件" },  notes = "获取软件草稿")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizsoftwaresuits/getdraft")
    public ResponseEntity<IBIZSoftwareSuitDTO> getDraft(IBIZSoftwareSuitDTO dto) {
        IBIZSoftwareSuit domain = ibizsoftwaresuitMapping.toDomain(dto);
        return ResponseEntity.status(HttpStatus.OK).body(ibizsoftwaresuitMapping.toDto(ibizsoftwaresuitService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(this.ibizsoftwaresuitMapping.toDomain(#ibizsoftwaresuitdto),'DemoSys-IBIZSoftwareSuit-Save')")
    @ApiOperation(value = "保存软件", tags = {"软件" },  notes = "保存软件")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsoftwaresuits/save")
    public ResponseEntity<IBIZSoftwareSuitDTO> save(@RequestBody IBIZSoftwareSuitDTO ibizsoftwaresuitdto) {
        IBIZSoftwareSuit domain = ibizsoftwaresuitMapping.toDomain(ibizsoftwaresuitdto);
        ibizsoftwaresuitService.save(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizsoftwaresuitMapping.toDto(domain));
    }

    @PreAuthorize("hasPermission(this.ibizsoftwaresuitMapping.toDomain(#ibizsoftwaresuitdtos),'DemoSys-IBIZSoftwareSuit-Save')")
    @ApiOperation(value = "批量保存软件", tags = {"软件" },  notes = "批量保存软件")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsoftwaresuits/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBIZSoftwareSuitDTO> ibizsoftwaresuitdtos) {
        ibizsoftwaresuitService.saveBatch(ibizsoftwaresuitMapping.toDomain(ibizsoftwaresuitdtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSoftwareSuit-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZSoftwareSuit-Get')")
	@ApiOperation(value = "获取DEFAULT", tags = {"软件" } ,notes = "获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/ibizsoftwaresuits/fetchdefault")
	public ResponseEntity<List<IBIZSoftwareSuitDTO>> fetchDefault(IBIZSoftwareSuitSearchContext context) {
        Page<IBIZSoftwareSuit> domains = ibizsoftwaresuitService.searchDefault(context) ;
        List<IBIZSoftwareSuitDTO> list = ibizsoftwaresuitMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSoftwareSuit-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZSoftwareSuit-Get')")
	@ApiOperation(value = "查询DEFAULT", tags = {"软件" } ,notes = "查询DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/ibizsoftwaresuits/searchdefault")
	public ResponseEntity<Page<IBIZSoftwareSuitDTO>> searchDefault(@RequestBody IBIZSoftwareSuitSearchContext context) {
        Page<IBIZSoftwareSuit> domains = ibizsoftwaresuitService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(ibizsoftwaresuitMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}



}

