package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.IBIZSample0018;
import cn.ibizlab.core.sample.service.IIBIZSample0018Service;
import cn.ibizlab.core.sample.filter.IBIZSample0018SearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"示例实体18" })
@RestController("DemoAPI-ibizsample0018")
@RequestMapping("")
public class IBIZSample0018Resource {

    @Autowired
    public IIBIZSample0018Service ibizsample0018Service;

    @Autowired
    @Lazy
    public IBIZSample0018Mapping ibizsample0018Mapping;

    @PreAuthorize("hasPermission(this.ibizsample0018Mapping.toDomain(#ibizsample0018dto),'DemoSys-IBIZSample0018-Create')")
    @ApiOperation(value = "新建示例实体18", tags = {"示例实体18" },  notes = "新建示例实体18")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0018s")
    public ResponseEntity<IBIZSample0018DTO> create(@Validated @RequestBody IBIZSample0018DTO ibizsample0018dto) {
        IBIZSample0018 domain = ibizsample0018Mapping.toDomain(ibizsample0018dto);
		ibizsample0018Service.create(domain);
        IBIZSample0018DTO dto = ibizsample0018Mapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizsample0018Mapping.toDomain(#ibizsample0018dtos),'DemoSys-IBIZSample0018-Create')")
    @ApiOperation(value = "批量新建示例实体18", tags = {"示例实体18" },  notes = "批量新建示例实体18")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0018s/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBIZSample0018DTO> ibizsample0018dtos) {
        ibizsample0018Service.createBatch(ibizsample0018Mapping.toDomain(ibizsample0018dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PostAuthorize("hasPermission(this.ibizsample0018Mapping.toDomain(returnObject.body),'DemoSys-IBIZSample0018-Get')")
    @ApiOperation(value = "获取示例实体18", tags = {"示例实体18" },  notes = "获取示例实体18")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizsample0018s/{ibizsample0018_id}")
    public ResponseEntity<IBIZSample0018DTO> get(@PathVariable("ibizsample0018_id") String ibizsample0018_id) {
        IBIZSample0018 domain = ibizsample0018Service.get(ibizsample0018_id);
        IBIZSample0018DTO dto = ibizsample0018Mapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizsample0018Service.get(#ibizsample0018_id),'DemoSys-IBIZSample0018-Remove')")
    @ApiOperation(value = "删除示例实体18", tags = {"示例实体18" },  notes = "删除示例实体18")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizsample0018s/{ibizsample0018_id}")
    public ResponseEntity<Boolean> remove(@PathVariable("ibizsample0018_id") String ibizsample0018_id) {
         return ResponseEntity.status(HttpStatus.OK).body(ibizsample0018Service.remove(ibizsample0018_id));
    }

    @PreAuthorize("hasPermission(this.ibizsample0018Service.getIbizsample0018ByIds(#ids),'DemoSys-IBIZSample0018-Remove')")
    @ApiOperation(value = "批量删除示例实体18", tags = {"示例实体18" },  notes = "批量删除示例实体18")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizsample0018s/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibizsample0018Service.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @VersionCheck(entity = "ibizsample0018" , versionfield = "updatedate")
    @PreAuthorize("hasPermission(this.ibizsample0018Service.get(#ibizsample0018_id),'DemoSys-IBIZSample0018-Update')")
    @ApiOperation(value = "更新示例实体18", tags = {"示例实体18" },  notes = "更新示例实体18")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizsample0018s/{ibizsample0018_id}")
    public ResponseEntity<IBIZSample0018DTO> update(@PathVariable("ibizsample0018_id") String ibizsample0018_id, @RequestBody IBIZSample0018DTO ibizsample0018dto) {
		IBIZSample0018 domain  = ibizsample0018Mapping.toDomain(ibizsample0018dto);
        domain .setIbizsample0018id(ibizsample0018_id);
		ibizsample0018Service.update(domain );
		IBIZSample0018DTO dto = ibizsample0018Mapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizsample0018Service.getIbizsample0018ByEntities(this.ibizsample0018Mapping.toDomain(#ibizsample0018dtos)),'DemoSys-IBIZSample0018-Update')")
    @ApiOperation(value = "批量更新示例实体18", tags = {"示例实体18" },  notes = "批量更新示例实体18")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizsample0018s/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBIZSample0018DTO> ibizsample0018dtos) {
        ibizsample0018Service.updateBatch(ibizsample0018Mapping.toDomain(ibizsample0018dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "检查示例实体18", tags = {"示例实体18" },  notes = "检查示例实体18")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0018s/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody IBIZSample0018DTO ibizsample0018dto) {
        return  ResponseEntity.status(HttpStatus.OK).body(ibizsample0018Service.checkKey(ibizsample0018Mapping.toDomain(ibizsample0018dto)));
    }

    @ApiOperation(value = "获取示例实体18草稿", tags = {"示例实体18" },  notes = "获取示例实体18草稿")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizsample0018s/getdraft")
    public ResponseEntity<IBIZSample0018DTO> getDraft(IBIZSample0018DTO dto) {
        IBIZSample0018 domain = ibizsample0018Mapping.toDomain(dto);
        return ResponseEntity.status(HttpStatus.OK).body(ibizsample0018Mapping.toDto(ibizsample0018Service.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(this.ibizsample0018Mapping.toDomain(#ibizsample0018dto),'DemoSys-IBIZSample0018-Save')")
    @ApiOperation(value = "保存示例实体18", tags = {"示例实体18" },  notes = "保存示例实体18")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0018s/save")
    public ResponseEntity<IBIZSample0018DTO> save(@RequestBody IBIZSample0018DTO ibizsample0018dto) {
        IBIZSample0018 domain = ibizsample0018Mapping.toDomain(ibizsample0018dto);
        ibizsample0018Service.save(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizsample0018Mapping.toDto(domain));
    }

    @PreAuthorize("hasPermission(this.ibizsample0018Mapping.toDomain(#ibizsample0018dtos),'DemoSys-IBIZSample0018-Save')")
    @ApiOperation(value = "批量保存示例实体18", tags = {"示例实体18" },  notes = "批量保存示例实体18")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizsample0018s/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBIZSample0018DTO> ibizsample0018dtos) {
        ibizsample0018Service.saveBatch(ibizsample0018Mapping.toDomain(ibizsample0018dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0018-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZSample0018-Get')")
	@ApiOperation(value = "获取DEFAULT", tags = {"示例实体18" } ,notes = "获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/ibizsample0018s/fetchdefault")
	public ResponseEntity<List<IBIZSample0018DTO>> fetchDefault(IBIZSample0018SearchContext context) {
        Page<IBIZSample0018> domains = ibizsample0018Service.searchDefault(context) ;
        List<IBIZSample0018DTO> list = ibizsample0018Mapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0018-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZSample0018-Get')")
	@ApiOperation(value = "查询DEFAULT", tags = {"示例实体18" } ,notes = "查询DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/ibizsample0018s/searchdefault")
	public ResponseEntity<Page<IBIZSample0018DTO>> searchDefault(@RequestBody IBIZSample0018SearchContext context) {
        Page<IBIZSample0018> domains = ibizsample0018Service.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(ibizsample0018Mapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}



}

