package cn.ibizlab.demoapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.Data;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 服务DTO对象[IBIZStorageDTO]
 */
@Data
@ApiModel("存储")
public class IBIZStorageDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [IBIZSTORAGEID]
     *
     */
    @JSONField(name = "ibizstorageid")
    @JsonProperty("ibizstorageid")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("存储标识")
    private String ibizstorageid;

    /**
     * 属性 [PRODUCER]
     *
     */
    @JSONField(name = "producer")
    @JsonProperty("producer")
    @Size(min = 0, max = 2000, message = "内容长度必须小于等于[2000]")
    @ApiModelProperty("生产厂商")
    private String producer;

    /**
     * 属性 [UPDATEMAN]
     *
     */
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    @ApiModelProperty("更新人")
    private String updateman;

    /**
     * 属性 [UNIT]
     *
     */
    @JSONField(name = "unit")
    @JsonProperty("unit")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("单位")
    private String unit;

    /**
     * 属性 [IBIZHARDWARETYPE]
     *
     */
    @JSONField(name = "ibizhardwaretype")
    @JsonProperty("ibizhardwaretype")
    @NotBlank(message = "[分组类型]不允许为空!")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("分组类型")
    private String ibizhardwaretype;

    /**
     * 属性 [CREATEMAN]
     *
     */
    @JSONField(name = "createman")
    @JsonProperty("createman")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    @ApiModelProperty("建立人")
    private String createman;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    @ApiModelProperty("更新时间")
    private Timestamp updatedate;

    /**
     * 属性 [PRODUCTUID]
     *
     */
    @JSONField(name = "productuid")
    @JsonProperty("productuid")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("产品编号")
    private String productuid;

    /**
     * 属性 [UNITPRICE]
     *
     */
    @JSONField(name = "unitprice")
    @JsonProperty("unitprice")
    @ApiModelProperty("单价")
    private Double unitprice;

    /**
     * 属性 [IBIZSTORAGENAME]
     *
     */
    @JSONField(name = "ibizstoragename")
    @JsonProperty("ibizstoragename")
    @Size(min = 0, max = 200, message = "内容长度必须小于等于[200]")
    @ApiModelProperty("存储名称")
    private String ibizstoragename;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "createdate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    @ApiModelProperty("建立时间")
    private Timestamp createdate;


    /**
     * 设置 [IBIZSTORAGENAME]
     */
    public void setIbizstoragename(String  ibizstoragename){
        this.ibizstoragename = ibizstoragename ;
        this.modify("ibizstoragename",ibizstoragename);
    }


}


