package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.IBIZHardware;
import cn.ibizlab.core.sample.service.IIBIZHardwareService;
import cn.ibizlab.core.sample.filter.IBIZHardwareSearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"硬件" })
@RestController("DemoAPI-ibizhardware")
@RequestMapping("")
public class IBIZHardwareResource {

    @Autowired
    public IIBIZHardwareService ibizhardwareService;

    @Autowired
    @Lazy
    public IBIZHardwareMapping ibizhardwareMapping;

    @PreAuthorize("hasPermission(this.ibizhardwareMapping.toDomain(#ibizhardwaredto),'DemoSys-IBIZHardware-Create')")
    @ApiOperation(value = "新建硬件", tags = {"硬件" },  notes = "新建硬件")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizhardwares")
    public ResponseEntity<IBIZHardwareDTO> create(@Validated @RequestBody IBIZHardwareDTO ibizhardwaredto) {
        IBIZHardware domain = ibizhardwareMapping.toDomain(ibizhardwaredto);
		ibizhardwareService.create(domain);
        IBIZHardwareDTO dto = ibizhardwareMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizhardwareMapping.toDomain(#ibizhardwaredtos),'DemoSys-IBIZHardware-Create')")
    @ApiOperation(value = "批量新建硬件", tags = {"硬件" },  notes = "批量新建硬件")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizhardwares/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBIZHardwareDTO> ibizhardwaredtos) {
        ibizhardwareService.createBatch(ibizhardwareMapping.toDomain(ibizhardwaredtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PostAuthorize("hasPermission(this.ibizhardwareMapping.toDomain(returnObject.body),'DemoSys-IBIZHardware-Get')")
    @ApiOperation(value = "获取硬件", tags = {"硬件" },  notes = "获取硬件")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizhardwares/{ibizhardware_id}")
    public ResponseEntity<IBIZHardwareDTO> get(@PathVariable("ibizhardware_id") String ibizhardware_id) {
        IBIZHardware domain = ibizhardwareService.get(ibizhardware_id);
        IBIZHardwareDTO dto = ibizhardwareMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizhardwareService.get(#ibizhardware_id),'DemoSys-IBIZHardware-Remove')")
    @ApiOperation(value = "删除硬件", tags = {"硬件" },  notes = "删除硬件")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizhardwares/{ibizhardware_id}")
    public ResponseEntity<Boolean> remove(@PathVariable("ibizhardware_id") String ibizhardware_id) {
         return ResponseEntity.status(HttpStatus.OK).body(ibizhardwareService.remove(ibizhardware_id));
    }

    @PreAuthorize("hasPermission(this.ibizhardwareService.getIbizhardwareByIds(#ids),'DemoSys-IBIZHardware-Remove')")
    @ApiOperation(value = "批量删除硬件", tags = {"硬件" },  notes = "批量删除硬件")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizhardwares/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibizhardwareService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @VersionCheck(entity = "ibizhardware" , versionfield = "updatedate")
    @PreAuthorize("hasPermission(this.ibizhardwareService.get(#ibizhardware_id),'DemoSys-IBIZHardware-Update')")
    @ApiOperation(value = "更新硬件", tags = {"硬件" },  notes = "更新硬件")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizhardwares/{ibizhardware_id}")
    public ResponseEntity<IBIZHardwareDTO> update(@PathVariable("ibizhardware_id") String ibizhardware_id, @RequestBody IBIZHardwareDTO ibizhardwaredto) {
		IBIZHardware domain  = ibizhardwareMapping.toDomain(ibizhardwaredto);
        domain .setIbizhardwareid(ibizhardware_id);
		ibizhardwareService.update(domain );
		IBIZHardwareDTO dto = ibizhardwareMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizhardwareService.getIbizhardwareByEntities(this.ibizhardwareMapping.toDomain(#ibizhardwaredtos)),'DemoSys-IBIZHardware-Update')")
    @ApiOperation(value = "批量更新硬件", tags = {"硬件" },  notes = "批量更新硬件")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizhardwares/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBIZHardwareDTO> ibizhardwaredtos) {
        ibizhardwareService.updateBatch(ibizhardwareMapping.toDomain(ibizhardwaredtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "检查硬件", tags = {"硬件" },  notes = "检查硬件")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizhardwares/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody IBIZHardwareDTO ibizhardwaredto) {
        return  ResponseEntity.status(HttpStatus.OK).body(ibizhardwareService.checkKey(ibizhardwareMapping.toDomain(ibizhardwaredto)));
    }

    @ApiOperation(value = "获取硬件草稿", tags = {"硬件" },  notes = "获取硬件草稿")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizhardwares/getdraft")
    public ResponseEntity<IBIZHardwareDTO> getDraft(IBIZHardwareDTO dto) {
        IBIZHardware domain = ibizhardwareMapping.toDomain(dto);
        return ResponseEntity.status(HttpStatus.OK).body(ibizhardwareMapping.toDto(ibizhardwareService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(this.ibizhardwareMapping.toDomain(#ibizhardwaredto),'DemoSys-IBIZHardware-Save')")
    @ApiOperation(value = "保存硬件", tags = {"硬件" },  notes = "保存硬件")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizhardwares/save")
    public ResponseEntity<IBIZHardwareDTO> save(@RequestBody IBIZHardwareDTO ibizhardwaredto) {
        IBIZHardware domain = ibizhardwareMapping.toDomain(ibizhardwaredto);
        ibizhardwareService.save(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizhardwareMapping.toDto(domain));
    }

    @PreAuthorize("hasPermission(this.ibizhardwareMapping.toDomain(#ibizhardwaredtos),'DemoSys-IBIZHardware-Save')")
    @ApiOperation(value = "批量保存硬件", tags = {"硬件" },  notes = "批量保存硬件")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizhardwares/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBIZHardwareDTO> ibizhardwaredtos) {
        ibizhardwareService.saveBatch(ibizhardwareMapping.toDomain(ibizhardwaredtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZHardware-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZHardware-Get')")
	@ApiOperation(value = "获取DEFAULT", tags = {"硬件" } ,notes = "获取DEFAULT")
    @RequestMapping(method= RequestMethod.GET , value="/ibizhardwares/fetchdefault")
	public ResponseEntity<List<IBIZHardwareDTO>> fetchDefault(IBIZHardwareSearchContext context) {
        Page<IBIZHardware> domains = ibizhardwareService.searchDefault(context) ;
        List<IBIZHardwareDTO> list = ibizhardwareMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZHardware-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZHardware-Get')")
	@ApiOperation(value = "查询DEFAULT", tags = {"硬件" } ,notes = "查询DEFAULT")
    @RequestMapping(method= RequestMethod.POST , value="/ibizhardwares/searchdefault")
	public ResponseEntity<Page<IBIZHardwareDTO>> searchDefault(@RequestBody IBIZHardwareSearchContext context) {
        Page<IBIZHardware> domains = ibizhardwareService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(ibizhardwareMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}



}

