package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import javax.servlet.ServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.IBIZAPPEXTENDEDITOR;
import cn.ibizlab.core.sample.service.IIBIZAPPEXTENDEDITORService;
import cn.ibizlab.core.sample.filter.IBIZAPPEXTENDEDITORSearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"扩展编辑器" })
@RestController("DemoAPI-ibizappextendeditor")
@RequestMapping("")
public class IBIZAPPEXTENDEDITORResource {

    @Autowired
    public IIBIZAPPEXTENDEDITORService ibizappextendeditorService;

    @Autowired
    @Lazy
    public IBIZAPPEXTENDEDITORMapping ibizappextendeditorMapping;

    @PreAuthorize("hasPermission(this.ibizappextendeditorMapping.toDomain(#ibizappextendeditordto),'DemoSys-IBIZAPPEXTENDEDITOR-Create')")
    @ApiOperation(value = "新建扩展编辑器", tags = {"扩展编辑器" },  notes = "新建扩展编辑器")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizappextendeditors")
    public ResponseEntity<IBIZAPPEXTENDEDITORDTO> create(@Validated @RequestBody IBIZAPPEXTENDEDITORDTO ibizappextendeditordto) {
        IBIZAPPEXTENDEDITOR domain = ibizappextendeditorMapping.toDomain(ibizappextendeditordto);
		ibizappextendeditorService.create(domain);
        IBIZAPPEXTENDEDITORDTO dto = ibizappextendeditorMapping.toDto(domain);
		return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizappextendeditorMapping.toDomain(#ibizappextendeditordtos),'DemoSys-IBIZAPPEXTENDEDITOR-Create')")
    @ApiOperation(value = "批量新建扩展编辑器", tags = {"扩展编辑器" },  notes = "批量新建扩展编辑器")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizappextendeditors/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBIZAPPEXTENDEDITORDTO> ibizappextendeditordtos) {
        ibizappextendeditorService.createBatch(ibizappextendeditorMapping.toDomain(ibizappextendeditordtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PostAuthorize("hasPermission(this.ibizappextendeditorMapping.toDomain(returnObject.body),'DemoSys-IBIZAPPEXTENDEDITOR-Get')")
    @ApiOperation(value = "获取扩展编辑器", tags = {"扩展编辑器" },  notes = "获取扩展编辑器")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizappextendeditors/{ibizappextendeditor_id}")
    public ResponseEntity<IBIZAPPEXTENDEDITORDTO> get(@PathVariable("ibizappextendeditor_id") String ibizappextendeditor_id) {
        IBIZAPPEXTENDEDITOR domain = ibizappextendeditorService.get(ibizappextendeditor_id);
        IBIZAPPEXTENDEDITORDTO dto = ibizappextendeditorMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizappextendeditorService.get(#ibizappextendeditor_id),'DemoSys-IBIZAPPEXTENDEDITOR-Remove')")
    @ApiOperation(value = "删除扩展编辑器", tags = {"扩展编辑器" },  notes = "删除扩展编辑器")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizappextendeditors/{ibizappextendeditor_id}")
    public ResponseEntity<Boolean> remove(@PathVariable("ibizappextendeditor_id") String ibizappextendeditor_id) {
         return ResponseEntity.status(HttpStatus.OK).body(ibizappextendeditorService.remove(ibizappextendeditor_id));
    }

    @PreAuthorize("hasPermission(this.ibizappextendeditorService.getIbizappextendeditorByIds(#ids),'DemoSys-IBIZAPPEXTENDEDITOR-Remove')")
    @ApiOperation(value = "批量删除扩展编辑器", tags = {"扩展编辑器" },  notes = "批量删除扩展编辑器")
	@RequestMapping(method = RequestMethod.DELETE, value = "/ibizappextendeditors/batch")
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibizappextendeditorService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @VersionCheck(entity = "ibizappextendeditor" , versionfield = "updatedate")
    @PreAuthorize("hasPermission(this.ibizappextendeditorService.get(#ibizappextendeditor_id),'DemoSys-IBIZAPPEXTENDEDITOR-Update')")
    @ApiOperation(value = "更新扩展编辑器", tags = {"扩展编辑器" },  notes = "更新扩展编辑器")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizappextendeditors/{ibizappextendeditor_id}")
    public ResponseEntity<IBIZAPPEXTENDEDITORDTO> update(@PathVariable("ibizappextendeditor_id") String ibizappextendeditor_id, @RequestBody IBIZAPPEXTENDEDITORDTO ibizappextendeditordto) {
		IBIZAPPEXTENDEDITOR domain  = ibizappextendeditorMapping.toDomain(ibizappextendeditordto);
        domain .setIbizappextendeditorid(ibizappextendeditor_id);
		ibizappextendeditorService.update(domain );
		IBIZAPPEXTENDEDITORDTO dto = ibizappextendeditorMapping.toDto(domain);
        return ResponseEntity.status(HttpStatus.OK).body(dto);
    }

    @PreAuthorize("hasPermission(this.ibizappextendeditorService.getIbizappextendeditorByEntities(this.ibizappextendeditorMapping.toDomain(#ibizappextendeditordtos)),'DemoSys-IBIZAPPEXTENDEDITOR-Update')")
    @ApiOperation(value = "批量更新扩展编辑器", tags = {"扩展编辑器" },  notes = "批量更新扩展编辑器")
	@RequestMapping(method = RequestMethod.PUT, value = "/ibizappextendeditors/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBIZAPPEXTENDEDITORDTO> ibizappextendeditordtos) {
        ibizappextendeditorService.updateBatch(ibizappextendeditorMapping.toDomain(ibizappextendeditordtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @ApiOperation(value = "检查扩展编辑器", tags = {"扩展编辑器" },  notes = "检查扩展编辑器")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizappextendeditors/checkkey")
    public ResponseEntity<Boolean> checkKey(@RequestBody IBIZAPPEXTENDEDITORDTO ibizappextendeditordto) {
        return  ResponseEntity.status(HttpStatus.OK).body(ibizappextendeditorService.checkKey(ibizappextendeditorMapping.toDomain(ibizappextendeditordto)));
    }

    @ApiOperation(value = "获取扩展编辑器草稿", tags = {"扩展编辑器" },  notes = "获取扩展编辑器草稿")
	@RequestMapping(method = RequestMethod.GET, value = "/ibizappextendeditors/getdraft")
    public ResponseEntity<IBIZAPPEXTENDEDITORDTO> getDraft(IBIZAPPEXTENDEDITORDTO dto) {
        IBIZAPPEXTENDEDITOR domain = ibizappextendeditorMapping.toDomain(dto);
        return ResponseEntity.status(HttpStatus.OK).body(ibizappextendeditorMapping.toDto(ibizappextendeditorService.getDraft(domain)));
    }

    @PreAuthorize("hasPermission(this.ibizappextendeditorMapping.toDomain(#ibizappextendeditordto),'DemoSys-IBIZAPPEXTENDEDITOR-Save')")
    @ApiOperation(value = "保存扩展编辑器", tags = {"扩展编辑器" },  notes = "保存扩展编辑器")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizappextendeditors/save")
    public ResponseEntity<IBIZAPPEXTENDEDITORDTO> save(@RequestBody IBIZAPPEXTENDEDITORDTO ibizappextendeditordto) {
        IBIZAPPEXTENDEDITOR domain = ibizappextendeditorMapping.toDomain(ibizappextendeditordto);
        ibizappextendeditorService.save(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizappextendeditorMapping.toDto(domain));
    }

    @PreAuthorize("hasPermission(this.ibizappextendeditorMapping.toDomain(#ibizappextendeditordtos),'DemoSys-IBIZAPPEXTENDEDITOR-Save')")
    @ApiOperation(value = "批量保存扩展编辑器", tags = {"扩展编辑器" },  notes = "批量保存扩展编辑器")
	@RequestMapping(method = RequestMethod.POST, value = "/ibizappextendeditors/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBIZAPPEXTENDEDITORDTO> ibizappextendeditordtos) {
        ibizappextendeditorService.saveBatch(ibizappextendeditorMapping.toDomain(ibizappextendeditordtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZAPPEXTENDEDITOR-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZAPPEXTENDEDITOR-Get')")
	@ApiOperation(value = "获取数据集", tags = {"扩展编辑器" } ,notes = "获取数据集")
    @RequestMapping(method= RequestMethod.GET , value="/ibizappextendeditors/fetchdefault")
	public ResponseEntity<List<IBIZAPPEXTENDEDITORDTO>> fetchDefault(IBIZAPPEXTENDEDITORSearchContext context) {
        Page<IBIZAPPEXTENDEDITOR> domains = ibizappextendeditorService.searchDefault(context) ;
        List<IBIZAPPEXTENDEDITORDTO> list = ibizappextendeditorMapping.toDto(domains.getContent());
        return ResponseEntity.status(HttpStatus.OK)
                .header("x-page", String.valueOf(context.getPageable().getPageNumber()))
                .header("x-per-page", String.valueOf(context.getPageable().getPageSize()))
                .header("x-total", String.valueOf(domains.getTotalElements()))
                .body(list);
	}

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZAPPEXTENDEDITOR-searchDefault-all') and hasPermission(#context,'DemoSys-IBIZAPPEXTENDEDITOR-Get')")
	@ApiOperation(value = "查询数据集", tags = {"扩展编辑器" } ,notes = "查询数据集")
    @RequestMapping(method= RequestMethod.POST , value="/ibizappextendeditors/searchdefault")
	public ResponseEntity<Page<IBIZAPPEXTENDEDITORDTO>> searchDefault(@RequestBody IBIZAPPEXTENDEDITORSearchContext context) {
        Page<IBIZAPPEXTENDEDITOR> domains = ibizappextendeditorService.searchDefault(context) ;
	    return ResponseEntity.status(HttpStatus.OK)
                .body(new PageImpl(ibizappextendeditorMapping.toDto(domains.getContent()), context.getPageable(), domains.getTotalElements()));
	}



}

