package cn.ibizlab.demoapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.Data;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 服务DTO对象[IBIZSample0014DTO]
 */
@Data
@ApiModel("员工")
public class IBIZSample0014DTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 属性 [IBIZSAMPLE0014NAME]
     *
     */
    @JSONField(name = "ibizsample0014name")
    @JsonProperty("ibizsample0014name")
    @Size(min = 0, max = 200, message = "内容长度必须小于等于[200]")
    @ApiModelProperty("员工名称")
    private String ibizsample0014name;

    /**
     * 属性 [IBIZSAMPLE0014ID]
     *
     */
    @JSONField(name = "ibizsample0014id")
    @JsonProperty("ibizsample0014id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("员工标识")
    private String ibizsample0014id;

    /**
     * 属性 [SN]
     *
     */
    @JSONField(name = "sn")
    @JsonProperty("sn")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("员工编号")
    private String sn;

    /**
     * 属性 [UPDATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "updatedate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("updatedate")
    @ApiModelProperty("更新时间")
    private Timestamp updatedate;

    /**
     * 属性 [CREATEDATE]
     *
     */
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", locale = "zh" , timezone="GMT+8")
    @JSONField(name = "createdate" , format="yyyy-MM-dd HH:mm:ss")
    @JsonProperty("createdate")
    @ApiModelProperty("建立时间")
    private Timestamp createdate;

    /**
     * 属性 [UPDATEMAN]
     *
     */
    @JSONField(name = "updateman")
    @JsonProperty("updateman")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    @ApiModelProperty("更新人")
    private String updateman;

    /**
     * 属性 [CREATEMAN]
     *
     */
    @JSONField(name = "createman")
    @JsonProperty("createman")
    @Size(min = 0, max = 60, message = "内容长度必须小于等于[60]")
    @ApiModelProperty("建立人")
    private String createman;

    /**
     * 属性 [IBIZSAMPLE0003NAME]
     *
     */
    @JSONField(name = "ibizsample0003name")
    @JsonProperty("ibizsample0003name")
    @Size(min = 0, max = 200, message = "内容长度必须小于等于[200]")
    @ApiModelProperty("名称")
    private String ibizsample0003name;

    /**
     * 属性 [IBIZSAMPLE0003ID]
     *
     */
    @JSONField(name = "ibizsample0003id")
    @JsonProperty("ibizsample0003id")
    @Size(min = 0, max = 100, message = "内容长度必须小于等于[100]")
    @ApiModelProperty("IBIZSAMPLE0003标识")
    private String ibizsample0003id;


    /**
     * 设置 [IBIZSAMPLE0014NAME]
     */
    public void setIbizsample0014name(String  ibizsample0014name){
        this.ibizsample0014name = ibizsample0014name ;
        this.modify("ibizsample0014name",ibizsample0014name);
    }

    /**
     * 设置 [SN]
     */
    public void setSn(String  sn){
        this.sn = sn ;
        this.modify("sn",sn);
    }

    /**
     * 设置 [IBIZSAMPLE0003ID]
     */
    public void setIbizsample0003id(String  ibizsample0003id){
        this.ibizsample0003id = ibizsample0003id ;
        this.modify("ibizsample0003id",ibizsample0003id);
    }


}


