import { Environment } from '@/environments/environment';
import { UIActionTool,Util } from '@/utils';
import UIService from '../ui-service';
import { Subject } from 'rxjs';
import IBIZOrderService from '@/service/ibizorder/ibizorder-service';
import IBIZOrderAuthService from '@/authservice/ibizorder/ibizorder-auth-service';

/**
 * 订单UI服务对象基类
 *
 * @export
 * @class IBIZOrderUIServiceBase
 */
export default class IBIZOrderUIServiceBase extends UIService {

    /**
     * 是否支持工作流
     * 
     * @memberof  IBIZOrderUIServiceBase
     */
    public isEnableWorkflow:boolean = false;

    /**
     * 是否支持实体主状态
     * 
     * @memberof  IBIZOrderUIServiceBase
     */
    public isEnableDEMainState:boolean = true;

    /**
     * 当前UI服务对应的数据服务对象
     * 
     * @memberof  IBIZOrderUIServiceBase
     */
    public dataService:IBIZOrderService = new IBIZOrderService();

    /**
     * 所有关联视图
     * 
     * @memberof  IBIZOrderUIServiceBase
     */ 
    public allViewMap: Map<string, Object> = new Map();

    /**
     * 状态值
     * 
     * @memberof  IBIZOrderUIServiceBase
     */ 
    public stateValue: number = 0;

    /**
     * 状态属性
     * 
     * @memberof  IBIZOrderUIServiceBase
     */ 
    public stateField: string = "";

    /**
     * 主状态属性集合
     * 
     * @memberof  IBIZOrderUIServiceBase
     */  
    public mainStateFields:Array<any> = ['orderstate'];

    /**
     * 主状态集合Map
     * 
     * @memberof  IBIZOrderUIServiceBase
     */  
    public allDeMainStateMap:Map<string,string> = new Map();

    /**
     * 主状态操作标识Map
     * 
     * @memberof  IBIZOrderUIServiceBase
     */ 
    public allDeMainStateOPPrivsMap:Map<string,any> = new Map();

    /**
     * Creates an instance of  IBIZOrderUIServiceBase.
     * 
     * @param {*} [opts={}]
     * @memberof  IBIZOrderUIServiceBase
     */
    constructor(opts: any = {}) {
        super(opts);
        this.authService = new IBIZOrderAuthService(opts);
        this.initViewMap();
        this.initDeMainStateMap();
        this.initDeMainStateOPPrivsMap();
    }

    /**
     * 初始化视图Map
     * 
     * @memberof  IBIZOrderUIServiceBase
     */  
    public initViewMap(){
        this.allViewMap.set(':',{viewname:'wfactionview',srfappde:'ibizorders',component:'ibizorder-wfaction-view'});
        this.allViewMap.set('WFMDATAVIEW:ODSP:D',{viewname:'odsp_d_wfgridview',srfappde:'ibizorders',component:'ibizorder-odsp-d-wfgrid-view'});
        this.allViewMap.set('MDATAVIEW:',{viewname:'gridview',srfappde:'ibizorders',component:'ibizorder-grid-view'});
        this.allViewMap.set(':',{viewname:'tabexpview',srfappde:'ibizorders',component:'ibizorder-tab-exp-view'});
        this.allViewMap.set(':',{viewname:'sf6gridview',srfappde:'ibizorders',component:'ibizorder-sf6-grid-view'});
        this.allViewMap.set(':',{viewname:'f9editview',srfappde:'ibizorders',component:'ibizorder-f9-edit-view'});
        this.allViewMap.set('PICKUPVIEW:',{viewname:'pickupview',srfappde:'ibizorders',component:'ibizorder-pickup-view'});
        this.allViewMap.set(':',{viewname:'dataviewexpview',srfappde:'ibizorders',component:'ibizorder-data-view-exp-view'});
        this.allViewMap.set(':',{viewname:'wfstartview',srfappde:'ibizorders',component:'ibizorder-wfstart-view'});
        this.allViewMap.set(':',{viewname:'f19editview',srfappde:'ibizorders',component:'ibizorder-f19-edit-view'});
        this.allViewMap.set(':',{viewname:'f13editview',srfappde:'ibizorders',component:'ibizorder-f13-edit-view'});
        this.allViewMap.set('WFMDATAVIEW:ODSP:D:20',{viewname:'odsp_d20_wfgridview',srfappde:'ibizorders',component:'ibizorder-odsp-d20-wfgrid-view'});
        this.allViewMap.set(':',{viewname:'seditview3',srfappde:'ibizorders',component:'ibizorder-sedit-view3'});
        this.allViewMap.set(':',{viewname:'sf1gridview',srfappde:'ibizorders',component:'ibizorder-sf1-grid-view'});
        this.allViewMap.set(':',{viewname:'linechartview',srfappde:'ibizorders',component:'ibizorder-line-chart-view'});
        this.allViewMap.set(':',{viewname:'radarchartview',srfappde:'ibizorders',component:'ibizorder-radar-chart-view'});
        this.allViewMap.set(':',{viewname:'selecteditview',srfappde:'ibizorders',component:'ibizorder-select-edit-view'});
        this.allViewMap.set(':',{viewname:'usr2chartview',srfappde:'ibizorders',component:'ibizorder-usr2-chart-view'});
        this.allViewMap.set(':',{viewname:'seditview',srfappde:'ibizorders',component:'ibizorder-sedit-view'});
        this.allViewMap.set(':',{viewname:'gridexpview',srfappde:'ibizorders',component:'ibizorder-grid-exp-view'});
        this.allViewMap.set(':',{viewname:'treeexpview',srfappde:'ibizorders',component:'ibizorder-tree-exp-view'});
        this.allViewMap.set('WFMDATAVIEW:ODSP:D:10',{viewname:'odsp_d10_wfgridview',srfappde:'ibizorders',component:'ibizorder-odsp-d10-wfgrid-view'});
        this.allViewMap.set(':',{viewname:'sf7editview',srfappde:'ibizorders',component:'ibizorder-sf7-edit-view'});
        this.allViewMap.set(':',{viewname:'seditview4',srfappde:'ibizorders',component:'ibizorder-sedit-view4'});
        this.allViewMap.set(':',{viewname:'sgridview',srfappde:'ibizorders',component:'ibizorder-sgrid-view'});
        this.allViewMap.set(':',{viewname:'barchartview',srfappde:'ibizorders',component:'ibizorder-bar-chart-view'});
        this.allViewMap.set(':',{viewname:'dashboardview',srfappde:'ibizorders',component:'ibizorder-dashboard-view'});
        this.allViewMap.set(':',{viewname:'sf1editview',srfappde:'ibizorders',component:'ibizorder-sf1-edit-view'});
        this.allViewMap.set(':',{viewname:'listexpview',srfappde:'ibizorders',component:'ibizorder-list-exp-view'});
        this.allViewMap.set(':',{viewname:'usr2calendarexpview',srfappde:'ibizorders',component:'ibizorder-usr2-calendar-exp-view'});
        this.allViewMap.set(':',{viewname:'piechartview',srfappde:'ibizorders',component:'ibizorder-pie-chart-view'});
        this.allViewMap.set('WFMDATAVIEW:ODSP:W:10',{viewname:'odsp_w10_wfgridview',srfappde:'ibizorders',component:'ibizorder-odsp-w10-wfgrid-view'});
        this.allViewMap.set(':',{viewname:'sf3editview',srfappde:'ibizorders',component:'ibizorder-sf3-edit-view'});
        this.allViewMap.set(':',{viewname:'calendarexpview',srfappde:'ibizorders',component:'ibizorder-calendar-exp-view'});
        this.allViewMap.set(':',{viewname:'f8editview',srfappde:'ibizorders',component:'ibizorder-f8-edit-view'});
        this.allViewMap.set(':',{viewname:'odsp_wfexpview',srfappde:'ibizorders',component:'ibizorder-odsp-wfexp-view'});
        this.allViewMap.set('WFMDATAVIEW:ODSP:D:30',{viewname:'odsp_d30_wfgridview',srfappde:'ibizorders',component:'ibizorder-odsp-d30-wfgrid-view'});
        this.allViewMap.set(':',{viewname:'pickupgridview',srfappde:'ibizorders',component:'ibizorder-pickup-grid-view'});
        this.allViewMap.set(':',{viewname:'gridview9',srfappde:'ibizorders',component:'ibizorder-grid-view9'});
        this.allViewMap.set(':',{viewname:'f10editview',srfappde:'ibizorders',component:'ibizorder-f10-edit-view'});
        this.allViewMap.set(':',{viewname:'s2editview',srfappde:'ibizorders',component:'ibizorder-s2-edit-view'});
        this.allViewMap.set(':',{viewname:'sf5gridview',srfappde:'ibizorders',component:'ibizorder-sf5-grid-view'});
        this.allViewMap.set(':',{viewname:'sf2editview',srfappde:'ibizorders',component:'ibizorder-sf2-edit-view'});
        this.allViewMap.set(':',{viewname:'usr3editview',srfappde:'ibizorders',component:'ibizorder-usr3-edit-view'});
        this.allViewMap.set('WFMDATAVIEW:ODSP:W',{viewname:'odsp_w_wfgridview',srfappde:'ibizorders',component:'ibizorder-odsp-w-wfgrid-view'});
        this.allViewMap.set(':',{viewname:'pickuptreeview',srfappde:'ibizorders',component:'ibizorder-pickup-tree-view'});
        this.allViewMap.set(':',{viewname:'listview',srfappde:'ibizorders',component:'ibizorder-list-view'});
        this.allViewMap.set(':',{viewname:'areachartview',srfappde:'ibizorders',component:'ibizorder-area-chart-view'});
        this.allViewMap.set(':',{viewname:'seditview2',srfappde:'ibizorders',component:'ibizorder-sedit-view2'});
        this.allViewMap.set(':',{viewname:'usr2editview',srfappde:'ibizorders',component:'ibizorder-usr2-edit-view'});
        this.allViewMap.set(':',{viewname:'sf4gridview',srfappde:'ibizorders',component:'ibizorder-sf4-grid-view'});
        this.allViewMap.set('WFMDATAVIEW:ODSP:D:40',{viewname:'odsp_d40_wfgridview',srfappde:'ibizorders',component:'ibizorder-odsp-d40-wfgrid-view'});
        this.allViewMap.set(':',{viewname:'sf3gridview',srfappde:'ibizorders',component:'ibizorder-sf3-grid-view'});
        this.allViewMap.set(':',{viewname:'zdytpgridview',srfappde:'ibizorders',component:'ibizorder-zdytpgrid-view'});
        this.allViewMap.set(':',{viewname:'sf4editview',srfappde:'ibizorders',component:'ibizorder-sf4-edit-view'});
        this.allViewMap.set(':',{viewname:'sgridview2',srfappde:'ibizorders',component:'ibizorder-sgrid-view2'});
        this.allViewMap.set(':',{viewname:'editview',srfappde:'ibizorders',component:'ibizorder-edit-view'});
        this.allViewMap.set(':',{viewname:'sf20gridview',srfappde:'ibizorders',component:'ibizorder-sf20-grid-view'});
        this.allViewMap.set(':',{viewname:'sf15gridview',srfappde:'ibizorders',component:'ibizorder-sf15-grid-view'});
    }

    /**
     * 初始化主状态集合
     * 
     * @memberof  IBIZOrderUIServiceBase
     */  
    public initDeMainStateMap(){
        this.allDeMainStateMap.set('10','10');
        this.allDeMainStateMap.set('30','30');
        this.allDeMainStateMap.set('40','40');
    }

    /**
     * 初始化主状态操作标识
     * 
     * @memberof  IBIZOrderUIServiceBase
     */  
    public initDeMainStateOPPrivsMap(){
        this.allDeMainStateOPPrivsMap.set('10',Object.assign({'CREATE':1,'DELETE':1,'READ':1,'UPDATE':1},{}));
        this.allDeMainStateOPPrivsMap.set('30',Object.assign({'CREATE':1,'DELETE':1,'READ':1,'UPDATE':1},{}));
        this.allDeMainStateOPPrivsMap.set('40',Object.assign({'CREATE':1,'DELETE':1,'READ':1,'UPDATE':1},{}));
    }

    /**
     * 后台界面行为1
     *
     * @param {any[]} args 当前数据
     * @param {any} context 行为附加上下文
     * @param {*} [params] 附加参数
     * @param {*} [$event] 事件源
     * @param {*} [xData]  执行行为所需当前部件
     * @param {*} [actionContext]  执行行为上下文
     * @param {*} [srfParentDeName] 父实体名称
     * @returns {Promise<any>}
     */
    public async IBIZOrder_BUIAction1(args: any[],context:any = {}, params:any = {}, $event?: any, xData?: any,actionContext?: any,srfParentDeName?:string){
        let data: any = {};
        let parentContext:any = {};
        let parentViewParam:any = {};
        const _this: any = actionContext;
        const _args: any[] = Util.deepCopy(args);
        const actionTarget: string | null = 'SINGLEKEY';
        Object.assign(context, { ibizorder: '%ibizorder%' });
        Object.assign(params, { ibizorderid: '%ibizorder%' });
        Object.assign(params, { ibizordername: '%ibizordername%' });
        if(_this.context){
            parentContext = _this.context;
        }
        if(_this.viewparams){
            parentViewParam = _this.viewparams;
        }
        context = UIActionTool.handleContextParam(actionTarget,_args,parentContext,parentViewParam,context);
        data = UIActionTool.handleActionParam(actionTarget,_args,parentContext,parentViewParam,params);
        context = Object.assign({},actionContext.context,context);
        let parentObj:any = {srfparentdename:srfParentDeName?srfParentDeName:null,srfparentkey:srfParentDeName?context[srfParentDeName.toLowerCase()]:null};
        Object.assign(data,parentObj);
        Object.assign(context,parentObj);
        // 直接调实体服务需要转换的数据
        if(context && context.srfsessionid){
          context.srfsessionkey = context.srfsessionid;
            delete context.srfsessionid;
        }
        const backend = () => {
            const curService:IBIZOrderService =  new IBIZOrderService();
            curService.Remove(context,data, true).then((response: any) => {
                if (!response || response.status !== 200) {
                    actionContext.$Notice.error({ title: '错误', desc: response.message });
                    return;
                }
                actionContext.$Notice.success({ title: '成功', desc: '后台界面行为1成功！' });
                const _this: any = actionContext;
                return response;
            }).catch((response: any) => {
                if (response && response.status && response.data) {
                    actionContext.$Notice.error({ title: (actionContext.$t('app.commonWords.wrong') as string), desc: response.data.message });
                    return;
                }
                if (!response || !response.status || !response.data) {
                    actionContext.$Notice.error({ title: (actionContext.$t('app.commonWords.wrong') as string), desc: (actionContext.$t('app.commonWords.sysException') as string) });
                    return;
                }
                return response;
            });
        };
        backend();
    }

    /**
     * 删除
     *
     * @param {any[]} args 当前数据
     * @param {any} context 行为附加上下文
     * @param {*} [params] 附加参数
     * @param {*} [$event] 事件源
     * @param {*} [xData]  执行行为所需当前部件
     * @param {*} [actionContext]  执行行为上下文
     * @param {*} [srfParentDeName] 父实体名称
     * @returns {Promise<any>}
     */
    public async IBIZOrder_Delete(args: any[],context:any = {}, params:any = {}, $event?: any, xData?: any,actionContext?: any,srfParentDeName?:string){
        let confirmResult:boolean = await new Promise((resolve: any, reject: any) => {
          actionContext.$Modal.confirm({
              title: '警告',
              content: '是否确认需要删除当前数据？',
              onOk: () => {resolve(true);},
              onCancel: () => {resolve(false);}
          });
        });
        if(!confirmResult){
            return;
        }
        let data: any = {};
        let parentContext:any = {};
        let parentViewParam:any = {};
        const _this: any = actionContext;
        const _args: any[] = Util.deepCopy(args);
        const actionTarget: string | null = 'SINGLEKEY';
        Object.assign(context, { ibizorder: '%ibizorder%' });
        Object.assign(params, { ibizorderid: '%ibizorder%' });
        Object.assign(params, { ibizordername: '%ibizordername%' });
        if(_this.context){
            parentContext = _this.context;
        }
        if(_this.viewparams){
            parentViewParam = _this.viewparams;
        }
        context = UIActionTool.handleContextParam(actionTarget,_args,parentContext,parentViewParam,context);
        data = UIActionTool.handleActionParam(actionTarget,_args,parentContext,parentViewParam,params);
        context = Object.assign({},actionContext.context,context);
        let parentObj:any = {srfparentdename:srfParentDeName?srfParentDeName:null,srfparentkey:srfParentDeName?context[srfParentDeName.toLowerCase()]:null};
        Object.assign(data,parentObj);
        Object.assign(context,parentObj);
        // 直接调实体服务需要转换的数据
        if(context && context.srfsessionid){
          context.srfsessionkey = context.srfsessionid;
            delete context.srfsessionid;
        }
        const backend = () => {
            const curService:IBIZOrderService =  new IBIZOrderService();
            curService.Remove(context,data, true).then((response: any) => {
                if (!response || response.status !== 200) {
                    actionContext.$Notice.error({ title: '错误', desc: response.message });
                    return;
                }
                actionContext.$Notice.success({ title: '成功', desc: '成功删除数据！' });
                const _this: any = actionContext;
                if (xData && xData.refresh && xData.refresh instanceof Function) {
                    xData.refresh(args);
                }
                return response;
            }).catch((response: any) => {
                if (response && response.status && response.data) {
                    actionContext.$Notice.error({ title: (actionContext.$t('app.commonWords.wrong') as string), desc: response.data.message });
                    return;
                }
                if (!response || !response.status || !response.data) {
                    actionContext.$Notice.error({ title: (actionContext.$t('app.commonWords.wrong') as string), desc: (actionContext.$t('app.commonWords.sysException') as string) });
                    return;
                }
                return response;
            });
        };
        backend();
    }

    /**
     * 删除
     *
     * @param {any[]} args 当前数据
     * @param {any} context 行为附加上下文
     * @param {*} [params] 附加参数
     * @param {*} [$event] 事件源
     * @param {*} [xData]  执行行为所需当前部件
     * @param {*} [actionContext]  执行行为上下文
     * @param {*} [srfParentDeName] 父实体名称
     * @returns {Promise<any>}
     */
    public async IBIZOrder_ZDYUpdate(args: any[],context:any = {}, params:any = {}, $event?: any, xData?: any,actionContext?: any,srfParentDeName?:string){
        let data: any = {};
        let parentContext:any = {};
        let parentViewParam:any = {};
        const _this: any = actionContext;
        const _args: any[] = Util.deepCopy(args);
        const actionTarget: string | null = 'SINGLEKEY';
        Object.assign(context, { ibizorder: '%ibizorder%' });
        Object.assign(params, { ibizorderid: '%ibizorder%' });
        Object.assign(params, { ibizordername: '%ibizordername%' });
        if(_this.context){
            parentContext = _this.context;
        }
        if(_this.viewparams){
            parentViewParam = _this.viewparams;
        }
        context = UIActionTool.handleContextParam(actionTarget,_args,parentContext,parentViewParam,context);
        data = UIActionTool.handleActionParam(actionTarget,_args,parentContext,parentViewParam,params);
        context = Object.assign({},actionContext.context,context);
        let parentObj:any = {srfparentdename:srfParentDeName?srfParentDeName:null,srfparentkey:srfParentDeName?context[srfParentDeName.toLowerCase()]:null};
        Object.assign(data,parentObj);
        Object.assign(context,parentObj);
        // 直接调实体服务需要转换的数据
        if(context && context.srfsessionid){
          context.srfsessionkey = context.srfsessionid;
            delete context.srfsessionid;
        }
        const backend = () => {
            const curService:IBIZOrderService =  new IBIZOrderService();
            curService.Remove(context,data, true).then((response: any) => {
                if (!response || response.status !== 200) {
                    actionContext.$Notice.error({ title: '错误', desc: response.message });
                    return;
                }
                actionContext.$Notice.success({ title: '成功', desc: '删除成功！' });
                const _this: any = actionContext;
                return response;
            }).catch((response: any) => {
                if (response && response.status && response.data) {
                    actionContext.$Notice.error({ title: (actionContext.$t('app.commonWords.wrong') as string), desc: response.data.message });
                    return;
                }
                if (!response || !response.status || !response.data) {
                    actionContext.$Notice.error({ title: (actionContext.$t('app.commonWords.wrong') as string), desc: (actionContext.$t('app.commonWords.sysException') as string) });
                    return;
                }
                return response;
            });
        };
        backend();
    }

    /**
     * 前台界面行为3
     *
     * @param {any[]} args 当前数据
     * @param {any} context 行为附加上下文
     * @param {*} [params] 附加参数
     * @param {*} [$event] 事件源
     * @param {*} [xData]  执行行为所需当前部件
     * @param {*} [actionContext]  执行行为上下文
     * @param {*} [srfParentDeName] 父实体名称
     * @returns {Promise<any>}
     */
    public async IBIZOrder_FUIAction3(args: any[], context:any = {} ,params: any={}, $event?: any, xData?: any,actionContext?:any,srfParentDeName?:string) {
    
        let data: any = {};
        let parentContext:any = {};
        let parentViewParam:any = {};
        const _this: any = actionContext;
        const _args: any[] = Util.deepCopy(args);
        const actionTarget: string | null = 'MULTIKEY';
        Object.assign(context, { ibizorder: '%ibizorder%' });
        Object.assign(params, { ibizorderid: '%ibizorder%' });
        Object.assign(params, { ibizordername: '%ibizordername%' });
        if(_this.context){
            parentContext = _this.context;
        }
        if(_this.viewparams){
            parentViewParam = _this.viewparams;
        }
        context = UIActionTool.handleContextParam(actionTarget,_args,parentContext,parentViewParam,context);
        data = UIActionTool.handleActionParam(actionTarget,_args,parentContext,parentViewParam,params);
        context = Object.assign({},actionContext.context,context);
        let parentObj:any = {srfparentdename:srfParentDeName?srfParentDeName:null,srfparentkey:srfParentDeName?context[srfParentDeName.toLowerCase()]:null};
        Object.assign(data,parentObj);
        Object.assign(context,parentObj);
        let deResParameters: any[] = [];
        const parameters: any[] = [
            { pathName: 'ibizorders', parameterName: 'ibizorder' },
            { pathName: 'editview', parameterName: 'editview' },
        ];
        const openIndexViewTab = (data: any) => {
            const routePath = actionContext.$viewTool.buildUpRoutePath(actionContext.$route, context, deResParameters, parameters, _args, data);
            actionContext.$router.push(routePath);
            return null;
        }
        openIndexViewTab(data);
    }

    /**
     * 前台界面行为2
     *
     * @param {any[]} args 当前数据
     * @param {any} context 行为附加上下文
     * @param {*} [params] 附加参数
     * @param {*} [$event] 事件源
     * @param {*} [xData]  执行行为所需当前部件
     * @param {*} [actionContext]  执行行为上下文
     * @param {*} [srfParentDeName] 父实体名称
     * @returns {Promise<any>}
     */
    public async IBIZOrder_FUIAction2(args: any[], context:any = {} ,params: any={}, $event?: any, xData?: any,actionContext?:any,srfParentDeName?:string) {
    
        let data: any = {};
        let parentContext:any = {};
        let parentViewParam:any = {};
        const _this: any = actionContext;
        const _args: any[] = Util.deepCopy(args);
        const actionTarget: string | null = 'SINGLEKEY';
        Object.assign(context, { ibizorder: '%ibizorder%' });
        Object.assign(params, { ibizorderid: '%ibizorder%' });
        Object.assign(params, { ibizordername: '%ibizordername%' });
        if(_this.context){
            parentContext = _this.context;
        }
        if(_this.viewparams){
            parentViewParam = _this.viewparams;
        }
        context = UIActionTool.handleContextParam(actionTarget,_args,parentContext,parentViewParam,context);
        data = UIActionTool.handleActionParam(actionTarget,_args,parentContext,parentViewParam,params);
        context = Object.assign({},actionContext.context,context);
        let parentObj:any = {srfparentdename:srfParentDeName?srfParentDeName:null,srfparentkey:srfParentDeName?context[srfParentDeName.toLowerCase()]:null};
        Object.assign(data,parentObj);
        Object.assign(context,parentObj);
        let deResParameters: any[] = [];
        const parameters: any[] = [
            { pathName: 'ibizorders', parameterName: 'ibizorder' },
            { pathName: 'editview', parameterName: 'editview' },
        ];
        const openIndexViewTab = (data: any) => {
            const routePath = actionContext.$viewTool.buildUpRoutePath(actionContext.$route, context, deResParameters, parameters, _args, data);
            actionContext.$router.push(routePath);
            return null;
        }
        openIndexViewTab(data);
    }

    /**
     * 打开文档
     *
     * @param {any[]} args 当前数据
     * @param {any} context 行为附加上下文
     * @param {*} [params] 附加参数
     * @param {*} [$event] 事件源
     * @param {*} [xData]  执行行为所需当前部件
     * @param {*} [actionContext]  执行行为上下文
     * @param {*} [srfParentDeName] 父实体名称
     * @returns {Promise<any>}
     */
    public async IBIZOrder_open_document(args: any[], context:any = {} ,params: any={}, $event?: any, xData?: any,actionContext?:any,srfParentDeName?:string) {
    
        let data: any = {};
        let parentContext:any = {};
        let parentViewParam:any = {};
        const _this: any = actionContext;
        const _args: any[] = Util.deepCopy(args);
        const actionTarget: string | null = 'NONE';
        if(_this.context){
            parentContext = _this.context;
        }
        if(_this.viewparams){
            parentViewParam = _this.viewparams;
        }
        context = UIActionTool.handleContextParam(actionTarget,_args,parentContext,parentViewParam,context);
        data = UIActionTool.handleActionParam(actionTarget,_args,parentContext,parentViewParam,params);
        context = Object.assign({},actionContext.context,context);
        let parentObj:any = {srfparentdename:srfParentDeName?srfParentDeName:null,srfparentkey:srfParentDeName?context[srfParentDeName.toLowerCase()]:null};
        Object.assign(data,parentObj);
        Object.assign(context,parentObj);
        const openPopupApp = (url: string) => {
            window.open(url, '_blank');
            return null;
        }
        const url = `https://www.yuque.com/ibiz/wuf19n/cwqg10`;
        openPopupApp(url);
    }

    /**
     * 后台界面行为2
     *
     * @param {any[]} args 当前数据
     * @param {any} context 行为附加上下文
     * @param {*} [params] 附加参数
     * @param {*} [$event] 事件源
     * @param {*} [xData]  执行行为所需当前部件
     * @param {*} [actionContext]  执行行为上下文
     * @param {*} [srfParentDeName] 父实体名称
     * @returns {Promise<any>}
     */
    public async IBIZOrder_BUIAction2(args: any[],context:any = {}, params:any = {}, $event?: any, xData?: any,actionContext?: any,srfParentDeName?:string){
        let confirmResult:boolean = await new Promise((resolve: any, reject: any) => {
          actionContext.$Modal.confirm({
              title: '警告',
              content: '是否确认需要删除选取数据？',
              onOk: () => {resolve(true);},
              onCancel: () => {resolve(false);}
          });
        });
        if(!confirmResult){
            return;
        }
        let data: any = {};
        let parentContext:any = {};
        let parentViewParam:any = {};
        const _this: any = actionContext;
        const _args: any[] = Util.deepCopy(args);
        const actionTarget: string | null = 'MULTIKEY';
        Object.assign(context, { ibizorder: '%ibizorder%' });
        Object.assign(params, { ibizorderid: '%ibizorder%' });
        Object.assign(params, { ibizordername: '%ibizordername%' });
        if(_this.context){
            parentContext = _this.context;
        }
        if(_this.viewparams){
            parentViewParam = _this.viewparams;
        }
        context = UIActionTool.handleContextParam(actionTarget,_args,parentContext,parentViewParam,context);
        data = UIActionTool.handleActionParam(actionTarget,_args,parentContext,parentViewParam,params);
        context = Object.assign({},actionContext.context,context);
        let parentObj:any = {srfparentdename:srfParentDeName?srfParentDeName:null,srfparentkey:srfParentDeName?context[srfParentDeName.toLowerCase()]:null};
        Object.assign(data,parentObj);
        Object.assign(context,parentObj);
        // 直接调实体服务需要转换的数据
        if(context && context.srfsessionid){
          context.srfsessionkey = context.srfsessionid;
            delete context.srfsessionid;
        }
        const backend = () => {
            const curService:IBIZOrderService =  new IBIZOrderService();
            curService.Remove(context,data, true).then((response: any) => {
                if (!response || response.status !== 200) {
                    actionContext.$Notice.error({ title: '错误', desc: response.message });
                    return;
                }
                actionContext.$Notice.success({ title: '成功', desc: '成功删除选取数据！' });
                const _this: any = actionContext;
                if (xData && xData.refresh && xData.refresh instanceof Function) {
                    xData.refresh(args);
                }
                return response;
            }).catch((response: any) => {
                if (response && response.status && response.data) {
                    actionContext.$Notice.error({ title: (actionContext.$t('app.commonWords.wrong') as string), desc: response.data.message });
                    return;
                }
                if (!response || !response.status || !response.data) {
                    actionContext.$Notice.error({ title: (actionContext.$t('app.commonWords.wrong') as string), desc: (actionContext.$t('app.commonWords.sysException') as string) });
                    return;
                }
                return response;
            });
        };
        backend();
    }

    /**
     * 编辑
     *
     * @param {any[]} args 当前数据
     * @param {any} context 行为附加上下文
     * @param {*} [params] 附加参数
     * @param {*} [$event] 事件源
     * @param {*} [xData]  执行行为所需当前部件
     * @param {*} [actionContext]  执行行为上下文
     * @param {*} [srfParentDeName] 父实体名称
     * @returns {Promise<any>}
     */
    public async IBIZOrder_FUIAction1(args: any[], context:any = {} ,params: any={}, $event?: any, xData?: any,actionContext?:any,srfParentDeName?:string) {
    
        let data: any = {};
        let parentContext:any = {};
        let parentViewParam:any = {};
        const _this: any = actionContext;
        const _args: any[] = Util.deepCopy(args);
        const actionTarget: string | null = 'NONE';
        if(_this.context){
            parentContext = _this.context;
        }
        if(_this.viewparams){
            parentViewParam = _this.viewparams;
        }
        context = UIActionTool.handleContextParam(actionTarget,_args,parentContext,parentViewParam,context);
        data = UIActionTool.handleActionParam(actionTarget,_args,parentContext,parentViewParam,params);
        context = Object.assign({},actionContext.context,context);
        let parentObj:any = {srfparentdename:srfParentDeName?srfParentDeName:null,srfparentkey:srfParentDeName?context[srfParentDeName.toLowerCase()]:null};
        Object.assign(data,parentObj);
        Object.assign(context,parentObj);
        let deResParameters: any[] = [];
        const parameters: any[] = [
            { pathName: 'ibizorders', parameterName: 'ibizorder' },
            { pathName: 'editview', parameterName: 'editview' },
        ];
        const openIndexViewTab = (data: any) => {
            const routePath = actionContext.$viewTool.buildUpRoutePath(actionContext.$route, context, deResParameters, parameters, _args, data);
            actionContext.$router.push(routePath);
            return null;
        }
        openIndexViewTab(data);
    }


    /**
     * 获取指定数据的重定向页面
     * 
     * @param srfkey 数据主键
     * @param isEnableWorkflow  重定向视图是否需要处理流程中的数据
     * @memberof  IBIZOrderUIServiceBase
     */
    public async getRDAppView(srfkey:string,isEnableWorkflow:boolean){
        this.isEnableWorkflow = isEnableWorkflow;
        // 进行数据查询
        let result:any = await this.dataService.Get({ibizorder:srfkey});
        const curData:any = result.data;
        //判断当前数据模式,默认为true，todo
        const iRealDEModel:boolean = true;

        let bDataInWF:boolean = false;
		let bWFMode:any = false;
		// 计算数据模式
		if (this.isEnableWorkflow) {
			bDataInWF = await this.dataService.testDataInWF({stateValue:this.stateValue,stateField:this.stateField},curData);
			if (bDataInWF) {
				bDataInWF = true;
				bWFMode = await this.dataService.testUserExistWorklist(null,curData);
			}
        }
        let strPDTViewParam:string = await this.getDESDDEViewPDTParam(curData, bDataInWF, bWFMode);
        //若不是当前数据模式，处理strPDTViewParam，todo

        //查找视图

        //返回视图
        return this.allViewMap.get(strPDTViewParam);
    }

    /**
	 * 获取实际的数据类型
     * 
     * @memberof  IBIZOrderUIServiceBase
	 */
	public getRealDEType(entity:any){

    }

    /**
     * 获取实体单数据实体视图预定义参数
     * 
     * @param curData 当前数据
     * @param bDataInWF 是否有数据在工作流中
     * @param bWFMode   是否工作流模式
     * @memberof  IBIZOrderUIServiceBase
     */
    public async getDESDDEViewPDTParam(curData:any, bDataInWF:boolean, bWFMode:boolean){
        let strPDTParam:string = '';
		if (bDataInWF) {
			// 判断数据是否在流程中
        }
        //多表单，todo
        const multiFormDEField:string|null =null;

        if (multiFormDEField) {
			const objFormValue:string = curData[multiFormDEField];
			if(!Environment.isAppMode){
				return 'MOBEDITVIEW:'+objFormValue;
			}
			return 'EDITVIEW:'+objFormValue;
        }
		if(!Environment.isAppMode){
            if(this.getDEMainStateTag(curData)){
                return `MOBEDITVIEW:MSTAG:${ this.getDEMainStateTag(curData)}`;
            }
			return 'MOBEDITVIEW:';
        }
        if(this.getDEMainStateTag(curData)){
            return `EDITVIEW:MSTAG:${ this.getDEMainStateTag(curData)}`;
        }
		return 'EDITVIEW:';
    }

    /**
     * 获取数据对象的主状态标识
     * 
     * @param curData 当前数据
     * @memberof  IBIZOrderUIServiceBase
     */  
    public getDEMainStateTag(curData:any){
        if(this.mainStateFields.length === 0) return null;

        this.mainStateFields.forEach((singleMainField:any) =>{
            if(!(singleMainField in curData)){
                console.warn(`当前数据对象不包含属性「${singleMainField}」，根据「${singleMainField}」属性进行的主状态计算默认为空值`);
            }
        })
        for (let i = 0; i <= 1; i++) {
            let strTag:string = (curData[this.mainStateFields[0]] != null && curData[this.mainStateFields[0]] !== "")?(i == 0) ? `${curData[this.mainStateFields[0]]}` : "":"";
            if (this.mainStateFields.length >= 2) {
                for (let j = 0; j <= 1; j++) {
                    let strTag2:string = (curData[this.mainStateFields[1]] != null && curData[this.mainStateFields[1]] !== "")?`${strTag}__${(j == 0) ? `${curData[this.mainStateFields[1]]}` : ""}`:strTag;
                    if (this.mainStateFields.length >= 3) {
                        for (let k = 0; k <= 1; k++) {
                            let strTag3:string = (curData[this.mainStateFields[2]] != null && curData[this.mainStateFields[2]] !== "")?`${strTag2}__${(k == 0) ? `${curData[this.mainStateFields[2]]}` : ""}`:strTag2;
                            // 判断是否存在
                            return this.allDeMainStateMap.get(strTag3);
                        }
                    }else{
                        return this.allDeMainStateMap.get(strTag2);
                    }
                }
            }else{
                return this.allDeMainStateMap.get(strTag);
            }
        }
        return null;
    }

    /**
    * 获取数据对象当前操作标识
    * 
    * @param data 当前数据
    * @memberof  IBIZOrderUIServiceBase
    */  
   public getDEMainStateOPPrivs(data:any){
        if(this.getDEMainStateTag(data)){
            return this.allDeMainStateOPPrivsMap.get((this.getDEMainStateTag(data) as string));
        }else{
            return null;
        }
   }

    /**
    * 获取数据对象所有的操作标识
    * 
    * @param data 当前数据
    * @memberof  IBIZOrderUIServiceBase
    */ 
   public getAllOPPrivs(data:any){
       return this.authService.getOPPrivs(this.getDEMainStateOPPrivs(data));
   }

}