import { Http,Util,Errorlog } from '@/utils';
import ControlService from '@/widgets/control-service';
import IBIZOrderDetailService from '@/service/ibizorder-detail/ibizorder-detail-service';
import HistogramModel from './histogram-chart-model';


/**
 * Histogram 部件服务对象
 *
 * @export
 * @class HistogramService
 */
export default class HistogramService extends ControlService {

    /**
     * 订单明细服务对象
     *
     * @type {IBIZOrderDetailService}
     * @memberof HistogramService
     */
    public appEntityService: IBIZOrderDetailService = new IBIZOrderDetailService({ $store: this.getStore() });

    /**
     * 设置从数据模式
     *
     * @type {boolean}
     * @memberof HistogramService
     */
    public setTempMode(){
        this.isTempMode = false;
    }

    /**
     * Creates an instance of HistogramService.
     * 
     * @param {*} [opts={}]
     * @memberof HistogramService
     */
    constructor(opts: any = {}) {
        super(opts);
        this.model = new HistogramModel();
    }

    /**
     * 查询数据
     *
     * @param {string} action
     * @param {*} [context={}]
     * @param {*} [data={}]
     * @param {boolean} [isloading]
     * @returns {Promise<any>}
     * @memberof HistogramService
     */
    @Errorlog
    public search(action: string,context: any = {}, data: any = {}, isloading?: boolean): Promise<any> {
        const {data:Data,context:Context} = this.handleRequestData(action,context,data,true);
        return new Promise((resolve: any, reject: any) => {
            const _appEntityService: any = this.appEntityService;
            let result: Promise<any>;
            if (_appEntityService[action] && _appEntityService[action] instanceof Function) {
                result = _appEntityService[action](Context,Data, isloading);
            }else{
                result =_appEntityService.FetchDefault(Context,Data, isloading);
            }
            result.then((response) => {
                resolve(response);
            }).catch(response => {
                reject(response);
            });      
        });
    }
}