/**
 * 实体权限服务注册中心
 *
 * @export
 * @class AuthServiceRegister
 */
export class AuthServiceRegister {

    /**
     * 所有实体权限服务Map
     *
     * @protected
     * @type {*}
     * @memberof AuthServiceRegister
     */
    protected allAuthService: Map<string, () => Promise<any>> = new Map();

    /**
     * 已加载实体权限服务Map缓存
     *
     * @protected
     * @type {Map<string, any>}
     * @memberof AuthServiceRegister
     */
    protected serviceCache: Map<string, any> = new Map();

    /**
     * Creates an instance of AuthServiceRegister.
     * @memberof AuthServiceRegister
     */
    constructor() {
        this.init();
    }

    /**
     * 初始化
     *
     * @protected
     * @memberof AuthServiceRegister
     */
    protected init(): void {
                this.allAuthService.set('ibizsample0006', () => import('@/authservice/ibizsample0006/ibizsample0006-auth-service'));
        this.allAuthService.set('ibizsample0017', () => import('@/authservice/ibizsample0017/ibizsample0017-auth-service'));
        this.allAuthService.set('ibizsample0002', () => import('@/authservice/ibizsample0002/ibizsample0002-auth-service'));
        this.allAuthService.set('ibizsample0010', () => import('@/authservice/ibizsample0010/ibizsample0010-auth-service'));
        this.allAuthService.set('ibizappview', () => import('@/authservice/ibizappview/ibizappview-auth-service'));
        this.allAuthService.set('ibizcustomer_intf', () => import('@/authservice/ibizcustomer-intf/ibizcustomer-intf-auth-service'));
        this.allAuthService.set('ibizorderdetail', () => import('@/authservice/ibizorder-detail/ibizorder-detail-auth-service'));
        this.allAuthService.set('ibizsample0016', () => import('@/authservice/ibizsample0016/ibizsample0016-auth-service'));
        this.allAuthService.set('ibizorder', () => import('@/authservice/ibizorder/ibizorder-auth-service'));
        this.allAuthService.set('ibizaccount', () => import('@/authservice/ibizaccount/ibizaccount-auth-service'));
        this.allAuthService.set('ibizcustomermg', () => import('@/authservice/ibizcustomer-mg/ibizcustomer-mg-auth-service'));
        this.allAuthService.set('ibizordertype', () => import('@/authservice/ibizorder-type/ibizorder-type-auth-service'));
        this.allAuthService.set('ibizsample0014', () => import('@/authservice/ibizsample0014/ibizsample0014-auth-service'));
        this.allAuthService.set('ibizsample0001', () => import('@/authservice/ibizsample0001/ibizsample0001-auth-service'));
        this.allAuthService.set('ibizsample0008', () => import('@/authservice/ibizsample0008/ibizsample0008-auth-service'));
        this.allAuthService.set('ibizappeditor', () => import('@/authservice/ibizappeditor/ibizappeditor-auth-service'));
        this.allAuthService.set('ibizbook', () => import('@/authservice/ibizbook/ibizbook-auth-service'));
        this.allAuthService.set('ibizsample0015', () => import('@/authservice/ibizsample0015/ibizsample0015-auth-service'));
        this.allAuthService.set('ibizsample0020', () => import('@/authservice/ibizsample0020/ibizsample0020-auth-service'));
        this.allAuthService.set('ibizsample0021', () => import('@/authservice/ibizsample0021/ibizsample0021-auth-service'));
        this.allAuthService.set('ibizsample0011', () => import('@/authservice/ibizsample0011/ibizsample0011-auth-service'));
        this.allAuthService.set('ibizcpu', () => import('@/authservice/ibizcpu/ibizcpu-auth-service'));
        this.allAuthService.set('ibizsample0012', () => import('@/authservice/ibizsample0012/ibizsample0012-auth-service'));
        this.allAuthService.set('ibizsample', () => import('@/authservice/ibizsample/ibizsample-auth-service'));
        this.allAuthService.set('ibizsupplier', () => import('@/authservice/ibizsupplier/ibizsupplier-auth-service'));
        this.allAuthService.set('ibizsample0004', () => import('@/authservice/ibizsample0004/ibizsample0004-auth-service'));
        this.allAuthService.set('ibizsoftwaresuit', () => import('@/authservice/ibizsoftware-suit/ibizsoftware-suit-auth-service'));
        this.allAuthService.set('ibizhardware', () => import('@/authservice/ibizhardware/ibizhardware-auth-service'));
        this.allAuthService.set('ibizsample0007', () => import('@/authservice/ibizsample0007/ibizsample0007-auth-service'));
        this.allAuthService.set('ibizsample0018', () => import('@/authservice/ibizsample0018/ibizsample0018-auth-service'));
        this.allAuthService.set('ibizsample0019', () => import('@/authservice/ibizsample0019/ibizsample0019-auth-service'));
        this.allAuthService.set('microcomponent', () => import('@/authservice/micro-component/micro-component-auth-service'));
        this.allAuthService.set('ibizstorage', () => import('@/authservice/ibizstorage/ibizstorage-auth-service'));
        this.allAuthService.set('ibizsample0003', () => import('@/authservice/ibizsample0003/ibizsample0003-auth-service'));
        this.allAuthService.set('ibizsample0009', () => import('@/authservice/ibizsample0009/ibizsample0009-auth-service'));
        this.allAuthService.set('ibizsample0013', () => import('@/authservice/ibizsample0013/ibizsample0013-auth-service'));
        this.allAuthService.set('ibizappctrl', () => import('@/authservice/ibizappctrl/ibizappctrl-auth-service'));
        this.allAuthService.set('ibizcustomer', () => import('@/authservice/ibizcustomer/ibizcustomer-auth-service'));
        this.allAuthService.set('ibizcustom', () => import('@/authservice/ibizcustom/ibizcustom-auth-service'));
        this.allAuthService.set('ibizsample0005', () => import('@/authservice/ibizsample0005/ibizsample0005-auth-service'));
        this.allAuthService.set('ibizuniproduct', () => import('@/authservice/ibizuniproduct/ibizuniproduct-auth-service'));
        this.allAuthService.set('dynadashboard', () => import('@/authservice/dynadashboard/dynadashboard-auth-service'));
        this.allAuthService.set('ibizappextendeditor', () => import('@/authservice/ibizappextendeditor/ibizappextendeditor-auth-service'));
    }

    /**
     * 加载实体权限服务
     *
     * @protected
     * @param {string} serviceName
     * @returns {Promise<any>}
     * @memberof AuthServiceRegister
     */
    protected async loadService(serviceName: string): Promise<any> {
        const service = this.allAuthService.get(serviceName);
        if (service) {
            return service();
        }
    }

    /**
     * 获取应用实体权限服务
     *
     * @param {string} name
     * @returns {Promise<any>}
     * @memberof AuthServiceRegister
     */
    public async getService(name: string): Promise<any> {
        if (this.serviceCache.has(name)) {
            return this.serviceCache.get(name);
        }
        const authService: any = await this.loadService(name);
        if (authService && authService.default) {
            const instance: any = new authService.default();
            this.serviceCache.set(name, instance);
            return instance;
        }
    }

}
export const authServiceRegister: AuthServiceRegister = new AuthServiceRegister();