import { PanelDetailModel } from './panel-detail';

/**
 * 按钮模型
 *
 * @export
 * @class PanelButtonModel
 * @extends {PanelDetailModel}
 */
export class PanelButtonModel extends PanelDetailModel {

    constructor(opts: any = {}) {
        super(opts);
        this.uiAction = opts.uiAction;
        this.buttonStyle = opts.buttonStyle;
        this.renderMode = opts.renderMode;
        this.iconAlign = opts.iconAlign || 'LEFT';
        this.disabled = opts.disabled ? true : false;
    }

    /**
     * 按钮对应的界面行为
     *
     * @type {*}
     * @memberof PanelButtonModel
     */
    public uiAction:any;

    /**
     * 图标方向
     *
     * @type {('LEFT' | 'TOP' | 'RIGHT' | 'BOTTOM')}
     * @memberof PanelButtonModel
     */
    public iconAlign: 'LEFT' | 'TOP' | 'RIGHT' | 'BOTTOM';

    /**
     * 是否禁用
     *
     * @type {boolean}
     * @memberof PanelButtonModel
     */
    public disabled: boolean = false;

    /**
     * @description 按钮类型
     * @type {string}
     * @memberof PanelButtonModel
     */
    public buttonStyle: 'DEFAULT' | 'INVERSE' | 'PRIMARY' | 'INFO' | 'SUCCESS' | 'WARNING' | 'DANGER' | 'STYLE2' | 'STYLE3' | 'STYLE4';

    /**
     * @description 绘制模式
     * @type {string}
     * @memberof PanelButtonModel
     */
    public renderMode: 'BUTTON' | 'LINK';

}