package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.IBIZSample0016;
import cn.ibizlab.core.sample.service.IBIZSample0016Service;
import cn.ibizlab.core.sample.filter.IBIZSample0016SearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"项目成员" })
@RestController("demoapi-ibizsample0016")
@RequestMapping("${ibiz.rest.basePath.demoapi:/demoapi/}")
public class IBIZSample0016Resource {

    @Autowired
    public IBIZSample0016Service ibizSample0016Service;

    @Autowired
    @Lazy
    public IBIZSample0016DTOMapping ibizSample0016DtoMapping;


    @ApiOperation(value = "创建Create", tags = {"项目成员" },  notes = "IBIZSample0016-Create")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0016-Create-all') or hasPermission(this.ibizSample0016DtoMapping.toDomain(#dto),'DemoSys-IBIZSample0016-Create')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizsample0016s")
    public ResponseEntity<IBIZSample0016DTO> create
            (@Validated @RequestBody IBIZSample0016DTO dto) {
        IBIZSample0016 domain = ibizSample0016DtoMapping.toDomain(dto);
        ibizSample0016Service.create(domain);
        IBIZSample0016 rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0016DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "获取Get", tags = {"项目成员" },  notes = "IBIZSample0016-Get")
    @PostAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0016-Get-all') or hasPermission(this.ibizSample0016DtoMapping.toDomain(returnObject.body),'DemoSys-IBIZSample0016-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsample0016s/{ibizSample0016Id}")
    public ResponseEntity<IBIZSample0016DTO> getByIbizSample0016Id
            (@PathVariable("ibizSample0016Id") String ibizSample0016Id) {
        IBIZSample0016 rt = ibizSample0016Service.get(ibizSample0016Id);
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0016DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "删除Remove", tags = {"项目成员" },  notes = "IBIZSample0016-Remove")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0016-Remove-all') or hasPermission(this.ibizSample0016Service.get(#ibizSample0016Id),'DemoSys-IBIZSample0016-Remove')")
    @RequestMapping(method = RequestMethod.DELETE, value = "ibizsample0016s/{ibizSample0016Id}")
    public ResponseEntity<Boolean> removeByIbizSample0016Id
            (@PathVariable("ibizSample0016Id") String ibizSample0016Id) {
        Boolean rt = ibizSample0016Service.remove(ibizSample0016Id);
        return ResponseEntity.status(HttpStatus.OK).body(rt);
    }

    @ApiOperation(value = "更新Update", tags = {"项目成员" },  notes = "IBIZSample0016-Update")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0016-Update-all') or hasPermission(this.ibizSample0016Service.get(#ibizSample0016Id),'DemoSys-IBIZSample0016-Update')")
    @VersionCheck(entity = "ibizsample0016" , versionfield = "updateDate")
    @RequestMapping(method = RequestMethod.PUT, value = "ibizsample0016s/{ibizSample0016Id}")
    public ResponseEntity<IBIZSample0016DTO> updateByIbizSample0016Id
            (@PathVariable("ibizSample0016Id") String ibizSample0016Id, @Validated @RequestBody IBIZSample0016DTO dto) {
        IBIZSample0016 domain = ibizSample0016DtoMapping.toDomain(dto);
        domain.setIbizSample0016Id(ibizSample0016Id);
        ibizSample0016Service.update(domain);
        IBIZSample0016 rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0016DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "校验CheckKey", tags = {"项目成员" },  notes = "IBIZSample0016-CheckKey")
    @RequestMapping(method = RequestMethod.POST, value = "ibizsample0016s/checkkey")
    public ResponseEntity<Integer> checkKey
            (@Validated @RequestBody IBIZSample0016DTO dto) {
        IBIZSample0016 domain = ibizSample0016DtoMapping.toDomain(dto);
        Integer rt = ibizSample0016Service.checkKey(domain);
        return ResponseEntity.status(HttpStatus.OK).body(rt);
    }

    @ApiOperation(value = "草稿GetDraft", tags = {"项目成员" },  notes = "IBIZSample0016-GetDraft")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsample0016s/getdraft")
    public ResponseEntity<IBIZSample0016DTO> getDraft
            (IBIZSample0016DTO dto) {
        IBIZSample0016 domain = ibizSample0016DtoMapping.toDomain(dto);
        IBIZSample0016 rt = ibizSample0016Service.getDraft(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0016DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "保存Save", tags = {"项目成员" },  notes = "IBIZSample0016-Save")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0016-Save-all') or hasPermission(this.ibizSample0016DtoMapping.toDomain(#dto),'DemoSys-IBIZSample0016-Save')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizsample0016s/save")
    public ResponseEntity<IBIZSample0016DTO> save
            (@Validated @RequestBody IBIZSample0016DTO dto) {
        IBIZSample0016 domain = ibizSample0016DtoMapping.toDomain(dto);
        ibizSample0016Service.save(domain);
        IBIZSample0016 rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0016DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "查询FetchDefault", tags = {"项目成员" },  notes = "IBIZSample0016-FetchDefault")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0016-searchDefault-all','DemoSys-IBIZSample0016-Get-all') or hasPermission(#dto,'DemoSys-IBIZSample0016-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsample0016s/fetchdefault")
    public ResponseEntity<List<IBIZSample0016DTO>> fetchDefault
            (IBIZSample0016SearchContext dto) {
        Page<IBIZSample0016> domains = ibizSample0016Service.searchDefault(dto) ;
        List<IBIZSample0016DTO> list = ibizSample0016DtoMapping.toDto(domains.getContent());
            return ResponseEntity.status(HttpStatus.OK)
            .header("x-page", String.valueOf(dto.getPageable().getPageNumber()))
            .header("x-per-page", String.valueOf(dto.getPageable().getPageSize()))
            .header("x-total", String.valueOf(domains.getTotalElements()))
            .body(list);
    }


    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0016-Create-all')")
    @ApiOperation(value = "批量新建项目成员", tags = {"项目成员" },  notes = "批量新建项目成员")
	@RequestMapping(method = RequestMethod.POST, value = "ibizsample0016s/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBIZSample0016DTO> dtos) {
        ibizSample0016Service.createBatch(ibizSample0016DtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0016-Update-all')")
    @ApiOperation(value = "批量更新项目成员", tags = {"项目成员" },  notes = "批量更新项目成员")
	@RequestMapping(method = RequestMethod.PUT, value = "ibizsample0016s/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBIZSample0016DTO> dtos) {
        ibizSample0016Service.updateBatch(ibizSample0016DtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0016-Save-all')")
    @ApiOperation(value = "批量保存项目成员", tags = {"项目成员" },  notes = "批量保存项目成员")
	@RequestMapping(method = RequestMethod.POST, value = "ibizsample0016s/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBIZSample0016DTO> dtos) {
        ibizSample0016Service.saveBatch(ibizSample0016DtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0016-Save-all')")
    @ApiOperation(value = "批量导入项目成员", tags = {"项目成员" },  notes = "批量导入项目成员")
	@RequestMapping(method = RequestMethod.POST, value = "ibizsample0016s/import")
    public ResponseEntity<Map> importData(@RequestParam(value = "config") String config ,@RequestBody List<IBIZSample0016DTO> dtos) {
        Map rs=new HashMap();
        if(ObjectUtils.isEmpty(dtos)){
            rs.put("rst", 1);
            rs.put("msg", "未传入内容");
            return ResponseEntity.status(HttpStatus.NO_CONTENT).body(rs);
        }
        else{
            List<IBIZSample0016> list=ibizSample0016DtoMapping.toDomain(dtos);
            List<IBIZSample0016> rtList=new ArrayList();
            list.forEach(item->{
                if(ibizSample0016Service.save(item))
                    rtList.add(item);
            });
            rs.put("rst", 0);
            rs.put("data",rtList);
        }
        return  ResponseEntity.status(HttpStatus.OK).body(rs);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0016-Remove-all')")
    @ApiOperation(value = "批量删除项目成员", tags = {"项目成员" },  notes = "批量删除项目成员")
	@RequestMapping(method = RequestMethod.DELETE, value = {"ibizsample0016s","/ibizsample0016s/batch"})
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibizSample0016Service.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }
}
