package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.IBIZSample0007;
import cn.ibizlab.core.sample.service.IBIZSample0007Service;
import cn.ibizlab.core.sample.filter.IBIZSample0007SearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"嵌套流程（子）" })
@RestController("demoapi-ibizsample0007")
@RequestMapping("${ibiz.rest.basePath.demoapi:/demoapi/}")
public class IBIZSample0007Resource {

    @Autowired
    public IBIZSample0007Service ibizSample0007Service;

    @Autowired
    @Lazy
    public IBIZSample0007DTOMapping ibizSample0007DtoMapping;


    @ApiOperation(value = "创建Create", tags = {"嵌套流程（子）" },  notes = "IBIZSample0007-Create")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0007-Create-all') or hasPermission(this.ibizSample0007DtoMapping.toDomain(#dto),'DemoSys-IBIZSample0007-Create')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizsample0007s")
    public ResponseEntity<IBIZSample0007DTO> create
            (@Validated @RequestBody IBIZSample0007DTO dto) {
        IBIZSample0007 domain = ibizSample0007DtoMapping.toDomain(dto);
        ibizSample0007Service.create(domain);
        IBIZSample0007 rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0007DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "获取Get", tags = {"嵌套流程（子）" },  notes = "IBIZSample0007-Get")
    @PostAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0007-Get-all') or hasPermission(this.ibizSample0007DtoMapping.toDomain(returnObject.body),'DemoSys-IBIZSample0007-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsample0007s/{ibizSample0007Id}")
    public ResponseEntity<IBIZSample0007DTO> getByIbizSample0007Id
            (@PathVariable("ibizSample0007Id") String ibizSample0007Id) {
        IBIZSample0007 rt = ibizSample0007Service.get(ibizSample0007Id);
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0007DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "删除Remove", tags = {"嵌套流程（子）" },  notes = "IBIZSample0007-Remove")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0007-Remove-all') or hasPermission(this.ibizSample0007Service.get(#ibizSample0007Id),'DemoSys-IBIZSample0007-Remove')")
    @RequestMapping(method = RequestMethod.DELETE, value = "ibizsample0007s/{ibizSample0007Id}")
    public ResponseEntity<Boolean> removeByIbizSample0007Id
            (@PathVariable("ibizSample0007Id") String ibizSample0007Id) {
        Boolean rt = ibizSample0007Service.remove(ibizSample0007Id);
        return ResponseEntity.status(HttpStatus.OK).body(rt);
    }

    @ApiOperation(value = "更新Update", tags = {"嵌套流程（子）" },  notes = "IBIZSample0007-Update")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0007-Update-all') or hasPermission(this.ibizSample0007Service.get(#ibizSample0007Id),'DemoSys-IBIZSample0007-Update')")
    @VersionCheck(entity = "ibizsample0007" , versionfield = "updateDate")
    @RequestMapping(method = RequestMethod.PUT, value = "ibizsample0007s/{ibizSample0007Id}")
    public ResponseEntity<IBIZSample0007DTO> updateByIbizSample0007Id
            (@PathVariable("ibizSample0007Id") String ibizSample0007Id, @Validated @RequestBody IBIZSample0007DTO dto) {
        IBIZSample0007 domain = ibizSample0007DtoMapping.toDomain(dto);
        domain.setIbizSample0007Id(ibizSample0007Id);
        ibizSample0007Service.update(domain);
        IBIZSample0007 rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0007DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "校验CheckKey", tags = {"嵌套流程（子）" },  notes = "IBIZSample0007-CheckKey")
    @RequestMapping(method = RequestMethod.POST, value = "ibizsample0007s/checkkey")
    public ResponseEntity<Integer> checkKey
            (@Validated @RequestBody IBIZSample0007DTO dto) {
        IBIZSample0007 domain = ibizSample0007DtoMapping.toDomain(dto);
        Integer rt = ibizSample0007Service.checkKey(domain);
        return ResponseEntity.status(HttpStatus.OK).body(rt);
    }

    @ApiOperation(value = "草稿GetDraft", tags = {"嵌套流程（子）" },  notes = "IBIZSample0007-GetDraft")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsample0007s/getdraft")
    public ResponseEntity<IBIZSample0007DTO> getDraft
            (IBIZSample0007DTO dto) {
        IBIZSample0007 domain = ibizSample0007DtoMapping.toDomain(dto);
        IBIZSample0007 rt = ibizSample0007Service.getDraft(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0007DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "保存Save", tags = {"嵌套流程（子）" },  notes = "IBIZSample0007-Save")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0007-Save-all') or hasPermission(this.ibizSample0007DtoMapping.toDomain(#dto),'DemoSys-IBIZSample0007-Save')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizsample0007s/save")
    public ResponseEntity<IBIZSample0007DTO> save
            (@Validated @RequestBody IBIZSample0007DTO dto) {
        IBIZSample0007 domain = ibizSample0007DtoMapping.toDomain(dto);
        ibizSample0007Service.save(domain);
        IBIZSample0007 rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizSample0007DtoMapping.toDto(rt));
    }

    @ApiOperation(value = "查询FetchCurGW", tags = {"嵌套流程（子）" },  notes = "IBIZSample0007-FetchCurGW")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0007-searchCurGW-all','DemoSys-IBIZSample0007-Get-all') or hasPermission(#dto,'DemoSys-IBIZSample0007-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsample0007s/fetchcurgw")
    public ResponseEntity<List<IBIZSample0007DTO>> fetchCurGw
            (IBIZSample0007SearchContext dto) {
        Page<IBIZSample0007> domains = ibizSample0007Service.searchCurGw(dto) ;
        List<IBIZSample0007DTO> list = ibizSample0007DtoMapping.toDto(domains.getContent());
            return ResponseEntity.status(HttpStatus.OK)
            .header("x-page", String.valueOf(dto.getPageable().getPageNumber()))
            .header("x-per-page", String.valueOf(dto.getPageable().getPageSize()))
            .header("x-total", String.valueOf(domains.getTotalElements()))
            .body(list);
    }

    @ApiOperation(value = "查询FetchDefault", tags = {"嵌套流程（子）" },  notes = "IBIZSample0007-FetchDefault")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZSample0007-searchDefault-all','DemoSys-IBIZSample0007-Get-all') or hasPermission(#dto,'DemoSys-IBIZSample0007-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizsample0007s/fetchdefault")
    public ResponseEntity<List<IBIZSample0007DTO>> fetchDefault
            (IBIZSample0007SearchContext dto) {
        Page<IBIZSample0007> domains = ibizSample0007Service.searchDefault(dto) ;
        List<IBIZSample0007DTO> list = ibizSample0007DtoMapping.toDto(domains.getContent());
            return ResponseEntity.status(HttpStatus.OK)
            .header("x-page", String.valueOf(dto.getPageable().getPageNumber()))
            .header("x-per-page", String.valueOf(dto.getPageable().getPageSize()))
            .header("x-total", String.valueOf(domains.getTotalElements()))
            .body(list);
    }


    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0007-Create-all')")
    @ApiOperation(value = "批量新建嵌套流程（子）", tags = {"嵌套流程（子）" },  notes = "批量新建嵌套流程（子）")
	@RequestMapping(method = RequestMethod.POST, value = "ibizsample0007s/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBIZSample0007DTO> dtos) {
        ibizSample0007Service.createBatch(ibizSample0007DtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0007-Update-all')")
    @ApiOperation(value = "批量更新嵌套流程（子）", tags = {"嵌套流程（子）" },  notes = "批量更新嵌套流程（子）")
	@RequestMapping(method = RequestMethod.PUT, value = "ibizsample0007s/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBIZSample0007DTO> dtos) {
        ibizSample0007Service.updateBatch(ibizSample0007DtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0007-Save-all')")
    @ApiOperation(value = "批量保存嵌套流程（子）", tags = {"嵌套流程（子）" },  notes = "批量保存嵌套流程（子）")
	@RequestMapping(method = RequestMethod.POST, value = "ibizsample0007s/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBIZSample0007DTO> dtos) {
        ibizSample0007Service.saveBatch(ibizSample0007DtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0007-Save-all')")
    @ApiOperation(value = "批量导入嵌套流程（子）", tags = {"嵌套流程（子）" },  notes = "批量导入嵌套流程（子）")
	@RequestMapping(method = RequestMethod.POST, value = "ibizsample0007s/import")
    public ResponseEntity<Map> importData(@RequestParam(value = "config") String config ,@RequestBody List<IBIZSample0007DTO> dtos) {
        Map rs=new HashMap();
        if(ObjectUtils.isEmpty(dtos)){
            rs.put("rst", 1);
            rs.put("msg", "未传入内容");
            return ResponseEntity.status(HttpStatus.NO_CONTENT).body(rs);
        }
        else{
            List<IBIZSample0007> list=ibizSample0007DtoMapping.toDomain(dtos);
            List<IBIZSample0007> rtList=new ArrayList();
            list.forEach(item->{
                if(ibizSample0007Service.save(item))
                    rtList.add(item);
            });
            rs.put("rst", 0);
            rs.put("data",rtList);
        }
        return  ResponseEntity.status(HttpStatus.OK).body(rs);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZSample0007-Remove-all')")
    @ApiOperation(value = "批量删除嵌套流程（子）", tags = {"嵌套流程（子）" },  notes = "批量删除嵌套流程（子）")
	@RequestMapping(method = RequestMethod.DELETE, value = {"ibizsample0007s","/ibizsample0007s/batch"})
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibizSample0007Service.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }
}
