package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.IBIZCustomerMG;
import cn.ibizlab.core.sample.service.IBIZCustomerMGService;
import cn.ibizlab.core.sample.filter.IBIZCustomerMGSearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"客户管理" })
@RestController("demoapi-ibizcustomermg")
@RequestMapping("${ibiz.rest.basePath.demoapi:/demoapi/}")
public class IBIZCustomerMGResource {

    @Autowired
    public IBIZCustomerMGService ibizCustomerMgService;

    @Autowired
    @Lazy
    public IBIZCustomerMGDTOMapping ibizCustomerMgdtoMapping;


    @ApiOperation(value = "创建Create", tags = {"客户管理" },  notes = "IBIZCustomerMG-Create")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZCustomerMG-Create-all')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizcustomermgs")
    public ResponseEntity<IBIZCustomerMGDTO> create
            (@Validated @RequestBody IBIZCustomerMGDTO dto) {
        IBIZCustomerMG domain = ibizCustomerMgdtoMapping.toDomain(dto);
        ibizCustomerMgService.create(domain);
        IBIZCustomerMG rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizCustomerMgdtoMapping.toDto(rt));
    }

    @ApiOperation(value = "获取Get", tags = {"客户管理" },  notes = "IBIZCustomerMG-Get")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZCustomerMG-Get-all')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizcustomermgs/{ibizCustomerId}")
    public ResponseEntity<IBIZCustomerMGDTO> getByIbizCustomerId
            (@PathVariable("ibizCustomerId") String ibizCustomerId) {
        IBIZCustomerMG rt = ibizCustomerMgService.get(ibizCustomerId);
        return ResponseEntity.status(HttpStatus.OK).body(ibizCustomerMgdtoMapping.toDto(rt));
    }

    @ApiOperation(value = "删除Remove", tags = {"客户管理" },  notes = "IBIZCustomerMG-Remove")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZCustomerMG-Remove-all')")
    @RequestMapping(method = RequestMethod.DELETE, value = "ibizcustomermgs/{ibizCustomerId}")
    public ResponseEntity<Boolean> removeByIbizCustomerId
            (@PathVariable("ibizCustomerId") String ibizCustomerId) {
        Boolean rt = ibizCustomerMgService.remove(ibizCustomerId);
        return ResponseEntity.status(HttpStatus.OK).body(rt);
    }

    @ApiOperation(value = "更新Update", tags = {"客户管理" },  notes = "IBIZCustomerMG-Update")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZCustomerMG-Update-all')")
    @RequestMapping(method = RequestMethod.PUT, value = "ibizcustomermgs/{ibizCustomerId}")
    public ResponseEntity<IBIZCustomerMGDTO> updateByIbizCustomerId
            (@PathVariable("ibizCustomerId") String ibizCustomerId, @Validated @RequestBody IBIZCustomerMGDTO dto) {
        IBIZCustomerMG domain = ibizCustomerMgdtoMapping.toDomain(dto);
        domain.setIbizCustomerId(ibizCustomerId);
        ibizCustomerMgService.update(domain);
        IBIZCustomerMG rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizCustomerMgdtoMapping.toDto(rt));
    }

    @ApiOperation(value = "校验CheckKey", tags = {"客户管理" },  notes = "IBIZCustomerMG-CheckKey")
    @RequestMapping(method = RequestMethod.POST, value = "ibizcustomermgs/checkkey")
    public ResponseEntity<Integer> checkKey
            (@Validated @RequestBody IBIZCustomerMGDTO dto) {
        IBIZCustomerMG domain = ibizCustomerMgdtoMapping.toDomain(dto);
        Integer rt = ibizCustomerMgService.checkKey(domain);
        return ResponseEntity.status(HttpStatus.OK).body(rt);
    }

    @ApiOperation(value = "草稿GetDraft", tags = {"客户管理" },  notes = "IBIZCustomerMG-GetDraft")
    @RequestMapping(method = RequestMethod.GET, value = "ibizcustomermgs/getdraft")
    public ResponseEntity<IBIZCustomerMGDTO> getDraft
            (IBIZCustomerMGDTO dto) {
        IBIZCustomerMG domain = ibizCustomerMgdtoMapping.toDomain(dto);
        IBIZCustomerMG rt = ibizCustomerMgService.getDraft(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizCustomerMgdtoMapping.toDto(rt));
    }

    @ApiOperation(value = "保存Save", tags = {"客户管理" },  notes = "IBIZCustomerMG-Save")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZCustomerMG-Save-all')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizcustomermgs/save")
    public ResponseEntity<IBIZCustomerMGDTO> save
            (@Validated @RequestBody IBIZCustomerMGDTO dto) {
        IBIZCustomerMG domain = ibizCustomerMgdtoMapping.toDomain(dto);
        ibizCustomerMgService.save(domain);
        IBIZCustomerMG rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizCustomerMgdtoMapping.toDto(rt));
    }

    @ApiOperation(value = "查询FetchDefault", tags = {"客户管理" },  notes = "IBIZCustomerMG-FetchDefault")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZCustomerMG-searchDefault-all','DemoSys-IBIZCustomerMG-Get-all')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizcustomermgs/fetchdefault")
    public ResponseEntity<List<IBIZCustomerMGDTO>> fetchDefault
            (IBIZCustomerMGSearchContext dto) {
        Page<IBIZCustomerMG> domains = ibizCustomerMgService.searchDefault(dto) ;
        List<IBIZCustomerMGDTO> list = ibizCustomerMgdtoMapping.toDto(domains.getContent());
            return ResponseEntity.status(HttpStatus.OK)
            .header("x-page", String.valueOf(dto.getPageable().getPageNumber()))
            .header("x-per-page", String.valueOf(dto.getPageable().getPageSize()))
            .header("x-total", String.valueOf(domains.getTotalElements()))
            .body(list);
    }


    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZCustomerMG-Create-all')")
    @ApiOperation(value = "批量新建客户管理", tags = {"客户管理" },  notes = "批量新建客户管理")
	@RequestMapping(method = RequestMethod.POST, value = "ibizcustomermgs/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBIZCustomerMGDTO> dtos) {
        ibizCustomerMgService.createBatch(ibizCustomerMgdtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZCustomerMG-Update-all')")
    @ApiOperation(value = "批量更新客户管理", tags = {"客户管理" },  notes = "批量更新客户管理")
	@RequestMapping(method = RequestMethod.PUT, value = "ibizcustomermgs/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBIZCustomerMGDTO> dtos) {
        ibizCustomerMgService.updateBatch(ibizCustomerMgdtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZCustomerMG-Save-all')")
    @ApiOperation(value = "批量保存客户管理", tags = {"客户管理" },  notes = "批量保存客户管理")
	@RequestMapping(method = RequestMethod.POST, value = "ibizcustomermgs/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBIZCustomerMGDTO> dtos) {
        ibizCustomerMgService.saveBatch(ibizCustomerMgdtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZCustomerMG-Save-all')")
    @ApiOperation(value = "批量导入客户管理", tags = {"客户管理" },  notes = "批量导入客户管理")
	@RequestMapping(method = RequestMethod.POST, value = "ibizcustomermgs/import")
    public ResponseEntity<Map> importData(@RequestParam(value = "config") String config ,@RequestBody List<IBIZCustomerMGDTO> dtos) {
        Map rs=new HashMap();
        if(ObjectUtils.isEmpty(dtos)){
            rs.put("rst", 1);
            rs.put("msg", "未传入内容");
            return ResponseEntity.status(HttpStatus.NO_CONTENT).body(rs);
        }
        else{
            List<IBIZCustomerMG> list=ibizCustomerMgdtoMapping.toDomain(dtos);
            List<IBIZCustomerMG> rtList=new ArrayList();
            list.forEach(item->{
                if(ibizCustomerMgService.save(item))
                    rtList.add(item);
            });
            rs.put("rst", 0);
            rs.put("data",rtList);
        }
        return  ResponseEntity.status(HttpStatus.OK).body(rs);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZCustomerMG-Remove-all')")
    @ApiOperation(value = "批量删除客户管理", tags = {"客户管理" },  notes = "批量删除客户管理")
	@RequestMapping(method = RequestMethod.DELETE, value = {"ibizcustomermgs","/ibizcustomermgs/batch"})
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibizCustomerMgService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }
}
