package cn.ibizlab.demoapi.rest;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.math.BigInteger;
import java.util.HashMap;
import lombok.extern.slf4j.Slf4j;
import com.alibaba.fastjson.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import org.springframework.http.HttpStatus;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.util.StringUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.access.prepost.PostAuthorize;
import org.springframework.validation.annotation.Validated;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import cn.ibizlab.demoapi.dto.*;
import cn.ibizlab.demoapi.mapping.*;
import cn.ibizlab.core.sample.domain.IBIZAPPEDITOR;
import cn.ibizlab.core.sample.service.IBIZAPPEDITORService;
import cn.ibizlab.core.sample.filter.IBIZAPPEDITORSearchContext;
import cn.ibizlab.util.annotation.VersionCheck;

@Slf4j
@Api(tags = {"编辑器" })
@RestController("demoapi-ibizappeditor")
@RequestMapping("${ibiz.rest.basePath.demoapi:/demoapi/}")
public class IBIZAPPEDITORResource {

    @Autowired
    public IBIZAPPEDITORService ibizappeditorService;

    @Autowired
    @Lazy
    public IBIZAPPEDITORDTOMapping ibizappeditordtoMapping;


    @ApiOperation(value = "创建Create", tags = {"编辑器" },  notes = "IBIZAPPEDITOR-Create")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZAPPEDITOR-Create-all') or hasPermission(this.ibizappeditordtoMapping.toDomain(#dto),'DemoSys-IBIZAPPEDITOR-Create')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizappeditors")
    public ResponseEntity<IBIZAPPEDITORDTO> create
            (@Validated @RequestBody IBIZAPPEDITORDTO dto) {
        IBIZAPPEDITOR domain = ibizappeditordtoMapping.toDomain(dto);
        ibizappeditorService.create(domain);
        IBIZAPPEDITOR rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizappeditordtoMapping.toDto(rt));
    }

    @ApiOperation(value = "获取Get", tags = {"编辑器" },  notes = "IBIZAPPEDITOR-Get")
    @PostAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZAPPEDITOR-Get-all') or hasPermission(this.ibizappeditordtoMapping.toDomain(returnObject.body),'DemoSys-IBIZAPPEDITOR-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizappeditors/{ibizappeditorid}")
    public ResponseEntity<IBIZAPPEDITORDTO> getByIbizappeditorid
            (@PathVariable("ibizappeditorid") String ibizappeditorid) {
        IBIZAPPEDITOR rt = ibizappeditorService.get(ibizappeditorid);
        return ResponseEntity.status(HttpStatus.OK).body(ibizappeditordtoMapping.toDto(rt));
    }

    @ApiOperation(value = "删除Remove", tags = {"编辑器" },  notes = "IBIZAPPEDITOR-Remove")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZAPPEDITOR-Remove-all') or hasPermission(this.ibizappeditorService.get(#ibizappeditorid),'DemoSys-IBIZAPPEDITOR-Remove')")
    @RequestMapping(method = RequestMethod.DELETE, value = "ibizappeditors/{ibizappeditorid}")
    public ResponseEntity<Boolean> removeByIbizappeditorid
            (@PathVariable("ibizappeditorid") String ibizappeditorid) {
        Boolean rt = ibizappeditorService.remove(ibizappeditorid);
        return ResponseEntity.status(HttpStatus.OK).body(rt);
    }

    @ApiOperation(value = "更新Update", tags = {"编辑器" },  notes = "IBIZAPPEDITOR-Update")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZAPPEDITOR-Update-all') or hasPermission(this.ibizappeditorService.get(#ibizappeditorid),'DemoSys-IBIZAPPEDITOR-Update')")
    @VersionCheck(entity = "ibizappeditor" , versionfield = "updateDate")
    @RequestMapping(method = RequestMethod.PUT, value = "ibizappeditors/{ibizappeditorid}")
    public ResponseEntity<IBIZAPPEDITORDTO> updateByIbizappeditorid
            (@PathVariable("ibizappeditorid") String ibizappeditorid, @Validated @RequestBody IBIZAPPEDITORDTO dto) {
        IBIZAPPEDITOR domain = ibizappeditordtoMapping.toDomain(dto);
        domain.setIbizappeditorid(ibizappeditorid);
        ibizappeditorService.update(domain);
        IBIZAPPEDITOR rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizappeditordtoMapping.toDto(rt));
    }

    @ApiOperation(value = "校验CheckKey", tags = {"编辑器" },  notes = "IBIZAPPEDITOR-CheckKey")
    @RequestMapping(method = RequestMethod.POST, value = "ibizappeditors/checkkey")
    public ResponseEntity<Integer> checkKey
            (@Validated @RequestBody IBIZAPPEDITORDTO dto) {
        IBIZAPPEDITOR domain = ibizappeditordtoMapping.toDomain(dto);
        Integer rt = ibizappeditorService.checkKey(domain);
        return ResponseEntity.status(HttpStatus.OK).body(rt);
    }

    @ApiOperation(value = "草稿GetDraft", tags = {"编辑器" },  notes = "IBIZAPPEDITOR-GetDraft")
    @RequestMapping(method = RequestMethod.GET, value = "ibizappeditors/getdraft")
    public ResponseEntity<IBIZAPPEDITORDTO> getDraft
            (IBIZAPPEDITORDTO dto) {
        IBIZAPPEDITOR domain = ibizappeditordtoMapping.toDomain(dto);
        IBIZAPPEDITOR rt = ibizappeditorService.getDraft(domain);
        return ResponseEntity.status(HttpStatus.OK).body(ibizappeditordtoMapping.toDto(rt));
    }

    @ApiOperation(value = "保存Save", tags = {"编辑器" },  notes = "IBIZAPPEDITOR-Save")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZAPPEDITOR-Save-all') or hasPermission(this.ibizappeditordtoMapping.toDomain(#dto),'DemoSys-IBIZAPPEDITOR-Save')")
    @RequestMapping(method = RequestMethod.POST, value = "ibizappeditors/save")
    public ResponseEntity<IBIZAPPEDITORDTO> save
            (@Validated @RequestBody IBIZAPPEDITORDTO dto) {
        IBIZAPPEDITOR domain = ibizappeditordtoMapping.toDomain(dto);
        ibizappeditorService.save(domain);
        IBIZAPPEDITOR rt = domain;
        return ResponseEntity.status(HttpStatus.OK).body(ibizappeditordtoMapping.toDto(rt));
    }

    @ApiOperation(value = "查询FetchDefault", tags = {"编辑器" },  notes = "IBIZAPPEDITOR-FetchDefault")
    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','DemoSys-IBIZAPPEDITOR-searchDefault-all','DemoSys-IBIZAPPEDITOR-Get-all') or hasPermission(#dto,'DemoSys-IBIZAPPEDITOR-Get')")
    @RequestMapping(method = RequestMethod.GET, value = "ibizappeditors/fetchdefault")
    public ResponseEntity<List<IBIZAPPEDITORDTO>> fetchDefault
            (IBIZAPPEDITORSearchContext dto) {
        Page<IBIZAPPEDITOR> domains = ibizappeditorService.searchDefault(dto) ;
        List<IBIZAPPEDITORDTO> list = ibizappeditordtoMapping.toDto(domains.getContent());
            return ResponseEntity.status(HttpStatus.OK)
            .header("x-page", String.valueOf(dto.getPageable().getPageNumber()))
            .header("x-per-page", String.valueOf(dto.getPageable().getPageSize()))
            .header("x-total", String.valueOf(domains.getTotalElements()))
            .body(list);
    }


    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZAPPEDITOR-Create-all')")
    @ApiOperation(value = "批量新建编辑器", tags = {"编辑器" },  notes = "批量新建编辑器")
	@RequestMapping(method = RequestMethod.POST, value = "ibizappeditors/batch")
    public ResponseEntity<Boolean> createBatch(@RequestBody List<IBIZAPPEDITORDTO> dtos) {
        ibizappeditorService.createBatch(ibizappeditordtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZAPPEDITOR-Update-all')")
    @ApiOperation(value = "批量更新编辑器", tags = {"编辑器" },  notes = "批量更新编辑器")
	@RequestMapping(method = RequestMethod.PUT, value = "ibizappeditors/batch")
    public ResponseEntity<Boolean> updateBatch(@RequestBody List<IBIZAPPEDITORDTO> dtos) {
        ibizappeditorService.updateBatch(ibizappeditordtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZAPPEDITOR-Save-all')")
    @ApiOperation(value = "批量保存编辑器", tags = {"编辑器" },  notes = "批量保存编辑器")
	@RequestMapping(method = RequestMethod.POST, value = "ibizappeditors/savebatch")
    public ResponseEntity<Boolean> saveBatch(@RequestBody List<IBIZAPPEDITORDTO> dtos) {
        ibizappeditorService.saveBatch(ibizappeditordtoMapping.toDomain(dtos));
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZAPPEDITOR-Save-all')")
    @ApiOperation(value = "批量导入编辑器", tags = {"编辑器" },  notes = "批量导入编辑器")
	@RequestMapping(method = RequestMethod.POST, value = "ibizappeditors/import")
    public ResponseEntity<Map> importData(@RequestParam(value = "config") String config ,@RequestBody List<IBIZAPPEDITORDTO> dtos) {
        Map rs=new HashMap();
        if(ObjectUtils.isEmpty(dtos)){
            rs.put("rst", 1);
            rs.put("msg", "未传入内容");
            return ResponseEntity.status(HttpStatus.NO_CONTENT).body(rs);
        }
        else{
            List<IBIZAPPEDITOR> list=ibizappeditordtoMapping.toDomain(dtos);
            List<IBIZAPPEDITOR> rtList=new ArrayList();
            list.forEach(item->{
                if(ibizappeditorService.save(item))
                    rtList.add(item);
            });
            rs.put("rst", 0);
            rs.put("data",rtList);
        }
        return  ResponseEntity.status(HttpStatus.OK).body(rs);
    }

    @PreAuthorize("hasAnyAuthority('ROLE_SUPERADMIN','demo-IBIZAPPEDITOR-Remove-all')")
    @ApiOperation(value = "批量删除编辑器", tags = {"编辑器" },  notes = "批量删除编辑器")
	@RequestMapping(method = RequestMethod.DELETE, value = {"ibizappeditors","/ibizappeditors/batch"})
    public ResponseEntity<Boolean> removeBatch(@RequestBody List<String> ids) {
        ibizappeditorService.removeBatch(ids);
        return  ResponseEntity.status(HttpStatus.OK).body(true);
    }
}
