package cn.ibizlab.demoapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.*;
import lombok.experimental.Accessors;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 服务DTO对象[IBIZUNIProductDTO]
 */
@Getter
@Setter
@NoArgsConstructor
@ApiModel("统一产品（索引主实体）")
public class IBIZUNIProductDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 建立时间
     */
    @JsonProperty("createdate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("建立时间")
    private Timestamp createDate;

    /**
     * 建立人
     */
    @JsonProperty("createman")
    @JSONField(name = "createman")
    @ApiModelProperty("建立人")
    private String createMan;

    /**
     * 统一产品标识
     */
    @JsonProperty("ibizuniproductid")
    @JSONField(name = "ibizuniproductid")
    @ApiModelProperty("统一产品标识")
    private String ibizuniProductId;

    /**
     * 产品名称
     */
    @JsonProperty("ibizuniproductname")
    @JSONField(name = "ibizuniproductname")
    @ApiModelProperty("产品名称")
    private String ibizuniProductName;

    /**
     * 分组类型
     */
    @JsonProperty("ibizuniproducttype")
    @JSONField(name = "ibizuniproducttype")
    @ApiModelProperty("分组类型")
    private String ibizuniProductType;

    /**
     * 单位
     */
    @JsonProperty("unit")
    @JSONField(name = "unit")
    @ApiModelProperty("单位")
    private String unit;

    /**
     * 单价
     */
    @JsonProperty("unitprice")
    @JSONField(name = "unitprice")
    @ApiModelProperty("单价")
    private BigDecimal unitPrice;

    /**
     * 更新时间
     */
    @JsonProperty("updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("更新时间")
    private Timestamp updateDate;

    /**
     * 更新人
     */
    @JsonProperty("updateman")
    @JSONField(name = "updateman")
    @ApiModelProperty("更新人")
    private String updateMan;


    /**
     * 设置 [产品名称]
     */
    public void setIbizuniProductName(String ibizuniProductName) {
        this.ibizuniProductName = ibizuniProductName;
        this.modify("ibizuniproductname", ibizuniProductName);
    }

    /**
     * 设置 [分组类型]
     */
    public void setIbizuniProductType(String ibizuniProductType) {
        this.ibizuniProductType = ibizuniProductType;
        this.modify("ibizuniproducttype", ibizuniProductType);
    }

    /**
     * 设置 [单位]
     */
    public void setUnit(String unit) {
        this.unit = unit;
        this.modify("unit", unit);
    }

    /**
     * 设置 [单价]
     */
    public void setUnitPrice(BigDecimal unitPrice) {
        this.unitPrice = unitPrice;
        this.modify("unitprice", unitPrice);
    }


}
