package cn.ibizlab.demoapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.*;
import lombok.experimental.Accessors;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 服务DTO对象[IBIZSample0007DTO]
 */
@Getter
@Setter
@NoArgsConstructor
@ApiModel("嵌套流程（子）")
public class IBIZSample0007DTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 建立时间
     */
    @JsonProperty("createdate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("建立时间")
    private Timestamp createDate;

    /**
     * 建立人
     */
    @JsonProperty("createman")
    @JSONField(name = "createman")
    @ApiModelProperty("建立人")
    private String createMan;

    /**
     * 公文时间
     */
    @JsonProperty("ddate")
    @JsonFormat(pattern = "yyyy-MM-dd", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "ddate" , format = "yyyy-MM-dd")
    @ApiModelProperty("公文时间")
    private Timestamp dDate;

    /**
     * 公文编号
     */
    @JsonProperty("dnum")
    @JSONField(name = "dnum")
    @ApiModelProperty("公文编号")
    private String dNum;

    /**
     * 正文
     */
    @JsonProperty("dtext")
    @JSONField(name = "dtext")
    @ApiModelProperty("正文")
    private String dText;

    /**
     * 嵌套流程（主）标识
     */
    @JsonProperty("ibizsample0006id")
    @JSONField(name = "ibizsample0006id")
    @ApiModelProperty("嵌套流程（主）标识")
    private String ibizSample0006Id;

    /**
     * 嵌套流程（主）名称
     */
    @JsonProperty("ibizsample0006name")
    @JSONField(name = "ibizsample0006name")
    @ApiModelProperty("嵌套流程（主）名称")
    private String ibizSample0006Name;

    /**
     * 嵌套流程（子）标识
     */
    @JsonProperty("ibizsample0007id")
    @JSONField(name = "ibizsample0007id")
    @ApiModelProperty("嵌套流程（子）标识")
    private String ibizSample0007Id;

    /**
     * 公文名称
     */
    @JsonProperty("ibizsample0007name")
    @JSONField(name = "ibizsample0007name")
    @ApiModelProperty("公文名称")
    private String ibizSample0007Name;

    /**
     * 更新时间
     */
    @JsonProperty("updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("更新时间")
    private Timestamp updateDate;

    /**
     * 更新人
     */
    @JsonProperty("updateman")
    @JSONField(name = "updateman")
    @ApiModelProperty("更新人")
    private String updateMan;

    /**
     * 工作流实例
     */
    @JsonProperty("wfinstanceid")
    @JSONField(name = "wfinstanceid")
    @ApiModelProperty("工作流实例")
    private String wfInstanceId;

    /**
     * 工作流步骤
     */
    @JsonProperty("wfstate")
    @JSONField(name = "wfstate")
    @ApiModelProperty("工作流步骤")
    private Integer wfState;

    /**
     * 会签步骤
     */
    @JsonProperty("wfstep")
    @JSONField(name = "wfstep")
    @ApiModelProperty("会签步骤")
    private String wfStep;

    /**
     * 工作流版本
     */
    @JsonProperty("wfversion")
    @JSONField(name = "wfversion")
    @ApiModelProperty("工作流版本")
    private String wfVersion;

    /**
     * 业务状态
     */
    @JsonProperty("ywstate")
    @JSONField(name = "ywstate")
    @ApiModelProperty("业务状态")
    private String ywState;


    /**
     * 设置 [公文时间]
     */
    public void setDDate(Timestamp dDate) {
        this.dDate = dDate;
        this.modify("ddate", dDate);
    }

    /**
     * 设置 [公文编号]
     */
    public void setDNum(String dNum) {
        this.dNum = dNum;
        this.modify("dnum", dNum);
    }

    /**
     * 设置 [正文]
     */
    public void setDText(String dText) {
        this.dText = dText;
        this.modify("dtext", dText);
    }

    /**
     * 设置 [嵌套流程（主）标识]
     */
    public void setIbizSample0006Id(String ibizSample0006Id) {
        this.ibizSample0006Id = ibizSample0006Id;
        this.modify("ibizsample0006id", ibizSample0006Id);
    }

    /**
     * 设置 [嵌套流程（主）名称]
     */
    public void setIbizSample0006Name(String ibizSample0006Name) {
        this.ibizSample0006Name = ibizSample0006Name;
        this.modify("ibizsample0006name", ibizSample0006Name);
    }

    /**
     * 设置 [公文名称]
     */
    public void setIbizSample0007Name(String ibizSample0007Name) {
        this.ibizSample0007Name = ibizSample0007Name;
        this.modify("ibizsample0007name", ibizSample0007Name);
    }

    /**
     * 设置 [工作流实例]
     */
    public void setWfInstanceId(String wfInstanceId) {
        this.wfInstanceId = wfInstanceId;
        this.modify("wfinstanceid", wfInstanceId);
    }

    /**
     * 设置 [工作流步骤]
     */
    public void setWfState(Integer wfState) {
        this.wfState = wfState;
        this.modify("wfstate", wfState);
    }

    /**
     * 设置 [会签步骤]
     */
    public void setWfStep(String wfStep) {
        this.wfStep = wfStep;
        this.modify("wfstep", wfStep);
    }

    /**
     * 设置 [工作流版本]
     */
    public void setWfVersion(String wfVersion) {
        this.wfVersion = wfVersion;
        this.modify("wfversion", wfVersion);
    }

    /**
     * 设置 [业务状态]
     */
    public void setYwState(String ywState) {
        this.ywState = ywState;
        this.modify("ywstate", ywState);
    }


}
