package cn.ibizlab.demoapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.*;
import lombok.experimental.Accessors;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 服务DTO对象[IBIZAccountDTO]
 */
@Getter
@Setter
@NoArgsConstructor
@ApiModel("账户")
public class IBIZAccountDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 开户银行号
     */
    @JsonProperty("bankaccountnum")
    @JSONField(name = "bankaccountnum")
    @ApiModelProperty("开户银行号")
    private String bankAccountNum;

    /**
     * 开户行
     */
    @JsonProperty("bankname")
    @JSONField(name = "bankname")
    @ApiModelProperty("开户行")
    private String bankName;

    /**
     * 建立时间
     */
    @JsonProperty("createdate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("建立时间")
    private Timestamp createDate;

    /**
     * 建立人
     */
    @JsonProperty("createman")
    @JSONField(name = "createman")
    @ApiModelProperty("建立人")
    private String createMan;

    /**
     * 账户标识
     */
    @JsonProperty("ibizaccountid")
    @JSONField(name = "ibizaccountid")
    @ApiModelProperty("账户标识")
    private String ibizAccountId;

    /**
     * 账户名称
     */
    @JsonProperty("ibizaccountname")
    @JSONField(name = "ibizaccountname")
    @ApiModelProperty("账户名称")
    private String ibizAccountName;

    /**
     * 更新时间
     */
    @JsonProperty("updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("更新时间")
    private Timestamp updateDate;

    /**
     * 更新人
     */
    @JsonProperty("updateman")
    @JSONField(name = "updateman")
    @ApiModelProperty("更新人")
    private String updateMan;


    /**
     * 设置 [开户银行号]
     */
    public void setBankAccountNum(String bankAccountNum) {
        this.bankAccountNum = bankAccountNum;
        this.modify("bankaccountnum", bankAccountNum);
    }

    /**
     * 设置 [开户行]
     */
    public void setBankName(String bankName) {
        this.bankName = bankName;
        this.modify("bankname", bankName);
    }

    /**
     * 设置 [账户名称]
     */
    public void setIbizAccountName(String ibizAccountName) {
        this.ibizAccountName = ibizAccountName;
        this.modify("ibizaccountname", ibizAccountName);
    }


}
