package cn.ibizlab.demoapi.dto;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.math.BigInteger;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.alibaba.fastjson.annotation.JSONField;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import cn.ibizlab.util.domain.DTOBase;
import cn.ibizlab.util.domain.DTOClient;
import lombok.*;
import lombok.experimental.Accessors;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 服务DTO对象[IBIZAPPEXTENDEDITORDTO]
 */
@Getter
@Setter
@NoArgsConstructor
@ApiModel("扩展编辑器")
public class IBIZAPPEXTENDEDITORDTO extends DTOBase implements Serializable {

	private static final long serialVersionUID = 1L;

    /**
     * 数量
     */
    @JsonProperty("amount")
    @JSONField(name = "amount")
    @ApiModelProperty("数量")
    private Integer amount;

    /**
     * 建立时间
     */
    @JsonProperty("createdate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "createdate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("建立时间")
    private Timestamp createDate;

    /**
     * 建立人
     */
    @JsonProperty("createman")
    @JSONField(name = "createman")
    @ApiModelProperty("建立人")
    private String createMan;

    /**
     * 文档地址
     */
    @JsonProperty("documentaddress")
    @JSONField(name = "documentaddress")
    @ApiModelProperty("文档地址")
    private String documentaddress;

    /**
     * 扩展编辑器描述
     */
    @JsonProperty("extendeditordescription")
    @JSONField(name = "extendeditordescription")
    @ApiModelProperty("扩展编辑器描述")
    private String extendeditordescription;

    /**
     * 扩展编辑器类型
     */
    @JsonProperty("extendeditortype")
    @JSONField(name = "extendeditortype")
    @ApiModelProperty("扩展编辑器类型")
    private String extendeditortype;

    /**
     * 扩展标识
     */
    @JsonProperty("extensionflag")
    @JSONField(name = "extensionflag")
    @ApiModelProperty("扩展标识")
    private String extensionflag;

    /**
     * 扩展编辑器标识
     */
    @JsonProperty("ibizappextendeditorid")
    @JSONField(name = "ibizappextendeditorid")
    @ApiModelProperty("扩展编辑器标识")
    private String ibizappextendeditorid;

    /**
     * 扩展编辑器名称
     */
    @JsonProperty("ibizappextendeditorname")
    @JSONField(name = "ibizappextendeditorname")
    @ApiModelProperty("扩展编辑器名称")
    private String ibizappextendeditorName;

    /**
     * 更新时间
     */
    @JsonProperty("updatedate")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", locale = "zh", timezone = "GMT+8")
    @JSONField(name = "updatedate" , format = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("更新时间")
    private Timestamp updateDate;

    /**
     * 更新人
     */
    @JsonProperty("updateman")
    @JSONField(name = "updateman")
    @ApiModelProperty("更新人")
    private String updateMan;


    /**
     * 设置 [数量]
     */
    public void setAmount(Integer amount) {
        this.amount = amount;
        this.modify("amount", amount);
    }

    /**
     * 设置 [文档地址]
     */
    public void setDocumentaddress(String documentaddress) {
        this.documentaddress = documentaddress;
        this.modify("documentaddress", documentaddress);
    }

    /**
     * 设置 [扩展编辑器描述]
     */
    public void setExtendeditordescription(String extendeditordescription) {
        this.extendeditordescription = extendeditordescription;
        this.modify("extendeditordescription", extendeditordescription);
    }

    /**
     * 设置 [扩展编辑器类型]
     */
    public void setExtendeditortype(String extendeditortype) {
        this.extendeditortype = extendeditortype;
        this.modify("extendeditortype", extendeditortype);
    }

    /**
     * 设置 [扩展标识]
     */
    public void setExtensionflag(String extensionflag) {
        this.extensionflag = extensionflag;
        this.modify("extensionflag", extensionflag);
    }

    /**
     * 设置 [扩展编辑器名称]
     */
    public void setIbizappextendeditorName(String ibizappextendeditorName) {
        this.ibizappextendeditorName = ibizappextendeditorName;
        this.modify("ibizappextendeditorname", ibizappextendeditorName);
    }


}
