package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import com.baomidou.mybatisplus.extension.service.IService;
import com.baomidou.dynamic.datasource.annotation.DS;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.SpringContextHolder;
import cn.ibizlab.core.sample.domain.IBIZSupplier;
import cn.ibizlab.core.sample.filter.IBIZSupplierSearchContext;

public interface IBIZSupplierService extends IService<IBIZSupplier> {

    default IBIZSupplierService getSelf() {
        return SpringContextHolder.getBean(this.getClass());
    }

    IBIZSupplier get(IBIZSupplier et);
    default IBIZSupplier get(String key) {
        IBIZSupplier et = new IBIZSupplier();
        et.setSupplierId(key);
        return getSelf().get(et);
    }
    default List<IBIZSupplier> getByIds(Collection<String> ids) {
        List<IBIZSupplier> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZSupplier et = new IBIZSupplier();
            et.setSupplierId(key);
            entities.add(et);
        });
        return getSelf().getByEntities(entities);
    }
    List<IBIZSupplier> getByEntities(List<IBIZSupplier> entities);

    IBIZSupplier getDraft(IBIZSupplier et);

    Integer checkKey(IBIZSupplier et);

    boolean create(IBIZSupplier et);
    boolean createBatch(List<IBIZSupplier> list);

    boolean update(IBIZSupplier et);
    boolean updateBatch(List<IBIZSupplier> list);

    boolean save(IBIZSupplier et);
    boolean saveBatch(List<IBIZSupplier> list);

    default boolean remove(String key) {
        IBIZSupplier et = new IBIZSupplier();
        et.setSupplierId(key);
        return getSelf().remove(et);
    }
    default boolean remove(List<String> key) {
        return removeBatch(key);
    }
    boolean remove(IBIZSupplier et);

    default boolean removeBatch(Collection<String> ids) {
        List<IBIZSupplier> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZSupplier et = new IBIZSupplier();
            et.setSupplierId(key);
            entities.add(et);
        });
        return getSelf().removeByEntities(entities);
    }

    boolean removeByEntities(List<IBIZSupplier> entities);

    Page<IBIZSupplier> searchDefault(IBIZSupplierSearchContext context);
    List<IBIZSupplier> listDefault(IBIZSupplierSearchContext context);


    /**
     * 自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);

    /**
     * 自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);
}