package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import com.baomidou.mybatisplus.extension.service.IService;
import com.baomidou.dynamic.datasource.annotation.DS;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.SpringContextHolder;
import cn.ibizlab.core.sample.domain.IBIZOrderDetail;
import cn.ibizlab.core.sample.filter.IBIZOrderDetailSearchContext;
import cn.ibizlab.core.sample.domain.IBIZOrder;
import cn.ibizlab.core.sample.domain.IBIZUNIProduct;

public interface IBIZOrderDetailService extends IService<IBIZOrderDetail> {

    default IBIZOrderDetailService getSelf() {
        return SpringContextHolder.getBean(this.getClass());
    }

    IBIZOrderDetail get(IBIZOrderDetail et);
    default IBIZOrderDetail get(String key) {
        IBIZOrderDetail et = new IBIZOrderDetail();
        et.setIbizOrderDetailId(key);
        return getSelf().get(et);
    }
    default List<IBIZOrderDetail> getByIds(Collection<String> ids) {
        List<IBIZOrderDetail> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZOrderDetail et = new IBIZOrderDetail();
            et.setIbizOrderDetailId(key);
            entities.add(et);
        });
        return getSelf().getByEntities(entities);
    }
    List<IBIZOrderDetail> getByEntities(List<IBIZOrderDetail> entities);

    IBIZOrderDetail getDraft(IBIZOrderDetail et);

    Integer checkKey(IBIZOrderDetail et);

    boolean create(IBIZOrderDetail et);
    boolean createBatch(List<IBIZOrderDetail> list);

    boolean update(IBIZOrderDetail et);
    boolean updateBatch(List<IBIZOrderDetail> list);

    boolean save(IBIZOrderDetail et);
    boolean saveBatch(List<IBIZOrderDetail> list);

    default boolean remove(String key) {
        IBIZOrderDetail et = new IBIZOrderDetail();
        et.setIbizOrderDetailId(key);
        return getSelf().remove(et);
    }
    default boolean remove(List<String> key) {
        return removeBatch(key);
    }
    boolean remove(IBIZOrderDetail et);

    default boolean removeBatch(Collection<String> ids) {
        List<IBIZOrderDetail> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZOrderDetail et = new IBIZOrderDetail();
            et.setIbizOrderDetailId(key);
            entities.add(et);
        });
        return getSelf().removeByEntities(entities);
    }

    boolean removeByEntities(List<IBIZOrderDetail> entities);

    default IBIZOrderDetail createTemp(IBIZOrderDetail dto) {
        return dto;
    }

    default IBIZOrderDetail createTempMajor(IBIZOrderDetail dto) {
        return dto;
    }

    default IBIZOrderDetail updateTemp(IBIZOrderDetail dto) {
        return dto;
    }

    default IBIZOrderDetail updateTempMajor(IBIZOrderDetail dto) {
        return dto;
    }

    default List<String> removeTemp(List<String> keys) {
        return keys;
    }

    default List<String> removeTempMajor(List<String> keys) {
        return keys;
    }

    default IBIZOrderDetail getTemp(String key) {
        return null;
    }

    default IBIZOrderDetail getTempMajor(String key) {
        return null;
    }

    default IBIZOrderDetail getDraftTemp(IBIZOrderDetail dto) {
        return null;
    }

    default IBIZOrderDetail getDraftTempMajor(IBIZOrderDetail dto) {
        return null;
    }

    default IBIZOrderDetail countMoney(IBIZOrderDetail dto) {
        return dto;
    }

    default IBIZOrderDetail getUnitAndPrice(String key) {
        return null;
    }

    Page<IBIZOrderDetail> searchCsmxdy(IBIZOrderDetailSearchContext context);
    List<IBIZOrderDetail> listCsmxdy(IBIZOrderDetailSearchContext context);

    Page<IBIZOrderDetail> searchDefault(IBIZOrderDetailSearchContext context);
    List<IBIZOrderDetail> listDefault(IBIZOrderDetailSearchContext context);

    Page<IBIZOrderDetail> searchLogic0007(IBIZOrderDetailSearchContext context);
    List<IBIZOrderDetail> listLogic0007(IBIZOrderDetailSearchContext context);

    Page<IBIZOrderDetail> searchX(IBIZOrderDetailSearchContext context);
    List<IBIZOrderDetail> listX(IBIZOrderDetailSearchContext context);

    List<IBIZOrderDetail> selectByIbizOrderId(String ibizOrderId);
    boolean removeByIbizOrderId(String ibizOrderId);
    boolean resetByIbizOrderId(String ibizOrderId);
    boolean saveByIbizorder(cn.ibizlab.core.sample.domain.IBIZOrder ibizOrder,List<IBIZOrderDetail> list);
    default boolean saveByIbizOrderId(String ibizOrderId,List<IBIZOrderDetail> list) {
        cn.ibizlab.core.sample.domain.IBIZOrder et = new cn.ibizlab.core.sample.domain.IBIZOrder();
        et.setIbizOrderId(ibizOrderId);
        return getSelf().saveByIbizorder(et,list);
    }

    List<IBIZOrderDetail> selectByIbizuniProductId(String ibizuniProductId);
    boolean removeByIbizuniProductId(String ibizuniProductId);
    boolean resetByIbizuniProductId(String ibizuniProductId);
    boolean saveByIbizuniproduct(cn.ibizlab.core.sample.domain.IBIZUNIProduct ibizuniProduct,List<IBIZOrderDetail> list);
    default boolean saveByIbizuniProductId(String ibizuniProductId,List<IBIZOrderDetail> list) {
        cn.ibizlab.core.sample.domain.IBIZUNIProduct et = new cn.ibizlab.core.sample.domain.IBIZUNIProduct();
        et.setIbizuniProductId(ibizuniProductId);
        return getSelf().saveByIbizuniproduct(et,list);
    }


    /**
     * 自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);

    /**
     * 自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);
}