package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import com.baomidou.mybatisplus.extension.service.IService;
import com.baomidou.dynamic.datasource.annotation.DS;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.SpringContextHolder;
import cn.ibizlab.core.sample.domain.IBIZCustomer;
import cn.ibizlab.core.sample.filter.IBIZCustomerSearchContext;

public interface IBIZCustomerService extends IService<IBIZCustomer> {

    default IBIZCustomerService getSelf() {
        return SpringContextHolder.getBean(this.getClass());
    }

    IBIZCustomer get(IBIZCustomer et);
    default IBIZCustomer get(String key) {
        IBIZCustomer et = new IBIZCustomer();
        et.setIbizCustomerId(key);
        return getSelf().get(et);
    }
    default List<IBIZCustomer> getByIds(Collection<String> ids) {
        List<IBIZCustomer> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZCustomer et = new IBIZCustomer();
            et.setIbizCustomerId(key);
            entities.add(et);
        });
        return getSelf().getByEntities(entities);
    }
    List<IBIZCustomer> getByEntities(List<IBIZCustomer> entities);

    IBIZCustomer getDraft(IBIZCustomer et);

    Integer checkKey(IBIZCustomer et);

    boolean create(IBIZCustomer et);
    boolean createBatch(List<IBIZCustomer> list);

    boolean update(IBIZCustomer et);
    boolean updateBatch(List<IBIZCustomer> list);

    boolean save(IBIZCustomer et);
    boolean saveBatch(List<IBIZCustomer> list);

    default boolean remove(String key) {
        IBIZCustomer et = new IBIZCustomer();
        et.setIbizCustomerId(key);
        return getSelf().remove(et);
    }
    default boolean remove(List<String> key) {
        return removeBatch(key);
    }
    boolean remove(IBIZCustomer et);

    default boolean removeBatch(Collection<String> ids) {
        List<IBIZCustomer> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZCustomer et = new IBIZCustomer();
            et.setIbizCustomerId(key);
            entities.add(et);
        });
        return getSelf().removeByEntities(entities);
    }

    boolean removeByEntities(List<IBIZCustomer> entities);

    Page<IBIZCustomer> searchDefault(IBIZCustomerSearchContext context);
    List<IBIZCustomer> listDefault(IBIZCustomerSearchContext context);


    /**
     * 自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);

    /**
     * 自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);
}