package cn.ibizlab.core.sample.service;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import java.util.Collection;
import java.math.BigInteger;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.scheduling.annotation.Async;
import com.alibaba.fastjson.JSONObject;
import org.springframework.cache.annotation.CacheEvict;

import com.baomidou.mybatisplus.extension.service.IService;
import com.baomidou.dynamic.datasource.annotation.DS;
import cn.ibizlab.util.helper.CachedBeanCopier;
import cn.ibizlab.util.security.SpringContextHolder;
import cn.ibizlab.core.sample.domain.IBIZAPPEXTENDEDITOR;
import cn.ibizlab.core.sample.filter.IBIZAPPEXTENDEDITORSearchContext;

public interface IBIZAPPEXTENDEDITORService extends IService<IBIZAPPEXTENDEDITOR> {

    default IBIZAPPEXTENDEDITORService getSelf() {
        return SpringContextHolder.getBean(this.getClass());
    }

    IBIZAPPEXTENDEDITOR get(IBIZAPPEXTENDEDITOR et);
    default IBIZAPPEXTENDEDITOR get(String key) {
        IBIZAPPEXTENDEDITOR et = new IBIZAPPEXTENDEDITOR();
        et.setIbizappextendeditorid(key);
        return getSelf().get(et);
    }
    default List<IBIZAPPEXTENDEDITOR> getByIds(Collection<String> ids) {
        List<IBIZAPPEXTENDEDITOR> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZAPPEXTENDEDITOR et = new IBIZAPPEXTENDEDITOR();
            et.setIbizappextendeditorid(key);
            entities.add(et);
        });
        return getSelf().getByEntities(entities);
    }
    List<IBIZAPPEXTENDEDITOR> getByEntities(List<IBIZAPPEXTENDEDITOR> entities);

    IBIZAPPEXTENDEDITOR getDraft(IBIZAPPEXTENDEDITOR et);

    Integer checkKey(IBIZAPPEXTENDEDITOR et);

    boolean create(IBIZAPPEXTENDEDITOR et);
    boolean createBatch(List<IBIZAPPEXTENDEDITOR> list);

    boolean update(IBIZAPPEXTENDEDITOR et);
    boolean updateBatch(List<IBIZAPPEXTENDEDITOR> list);

    boolean save(IBIZAPPEXTENDEDITOR et);
    boolean saveBatch(List<IBIZAPPEXTENDEDITOR> list);

    default boolean remove(String key) {
        IBIZAPPEXTENDEDITOR et = new IBIZAPPEXTENDEDITOR();
        et.setIbizappextendeditorid(key);
        return getSelf().remove(et);
    }
    default boolean remove(List<String> key) {
        return removeBatch(key);
    }
    boolean remove(IBIZAPPEXTENDEDITOR et);

    default boolean removeBatch(Collection<String> ids) {
        List<IBIZAPPEXTENDEDITOR> entities =new ArrayList();
        ids.forEach(key -> {
            IBIZAPPEXTENDEDITOR et = new IBIZAPPEXTENDEDITOR();
            et.setIbizappextendeditorid(key);
            entities.add(et);
        });
        return getSelf().removeByEntities(entities);
    }

    boolean removeByEntities(List<IBIZAPPEXTENDEDITOR> entities);

    Page<IBIZAPPEXTENDEDITOR> searchDefault(IBIZAPPEXTENDEDITORSearchContext context);
    List<IBIZAPPEXTENDEDITOR> listDefault(IBIZAPPEXTENDEDITORSearchContext context);


    /**
     * 自定义查询SQL
     * @param sql  select * from table where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return select * from table where id = '1'
     */
    List<JSONObject> select(String sql, Map param);

    /**
     * 自定义SQL
     * @param sql  update table  set name ='test' where id =#{et.param}
     * @param param 参数列表  param.put("param","1");
     * @return     update table  set name ='test' where id = '1'
     */
    boolean execute(String sql, Map param);
}