package cn.ibizlab.core.sample.mapping;

import org.mapstruct.*;
import cn.ibizlab.core.sample.domain.IBIZSoftwareSuit;
import cn.ibizlab.core.sample.domain.IBIZUNIProduct;
import java.util.List;

@Mapper(componentModel = "spring", uses = {})
public interface IBIZSoftwareSuitInheritMapping {

    @Mappings({
            @Mapping(target ="focusNull",ignore = true),
            @Mapping(source ="ibizSoftwareSuitId",target = "ibizuniProductId"),
            @Mapping(source ="ibizSoftwareSuitName",target = "ibizuniProductName"),
    })
    IBIZUNIProduct toIbizuniProduct(IBIZSoftwareSuit ibizSoftwareSuit);

    @Mappings({
            @Mapping(target ="focusNull",ignore = true),
            @Mapping(source ="ibizuniProductId",target = "ibizSoftwareSuitId"),
            @Mapping(source ="ibizuniProductName",target = "ibizSoftwareSuitName"),
    })
    IBIZSoftwareSuit toIbizSoftwareSuit(IBIZUNIProduct ibizuniProduct);

    List<IBIZUNIProduct> toIbizuniProduct(List<IBIZSoftwareSuit> list);

    List<IBIZSoftwareSuit> toIbizSoftwareSuit(List<IBIZUNIProduct> list);

}
