package cn.ibizlab.core.sample.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import cn.ibizlab.util.filter.QueryWrapperContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.ibizlab.core.sample.domain.IBIZSample0014;
/**
 * 关系型数据实体[IBIZSample0014] 查询条件对象
 */
@Slf4j
@Getter
@Setter
@NoArgsConstructor
@ApiModel("员工")
public class IBIZSample0014SearchContext extends QueryWrapperContext<IBIZSample0014> {

    @JsonProperty("n_ibizsample0014name_like")
    @JSONField(name = "n_ibizsample0014name_like")
    @ApiModelProperty("员工名称LIKE")
	private String ibizSample0014NameLIKE;
	public IBIZSample0014SearchContext setIbizSample0014NameLIKE(String ibizSample0014NameLIKE) {
        this.ibizSample0014NameLIKE = ibizSample0014NameLIKE;
        if(!ObjectUtils.isEmpty(this.ibizSample0014NameLIKE)){
            this.getSearchCond().like("ibizsample0014name", ibizSample0014NameLIKE);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizsample0014id_eq")
    @JSONField(name = "n_ibizsample0014id_eq")
    @ApiModelProperty("员工标识EQ")
	private String ibizSample0014IdEQ;
	public IBIZSample0014SearchContext setIbizSample0014IdEQ(String ibizSample0014IdEQ) {
        this.ibizSample0014IdEQ = ibizSample0014IdEQ;
        if(!ObjectUtils.isEmpty(this.ibizSample0014IdEQ)){
            this.getSearchCond().eq("ibizsample0014id", ibizSample0014IdEQ);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizsample0003name_eq")
    @JSONField(name = "n_ibizsample0003name_eq")
    @ApiModelProperty("名称EQ")
	private String ibizsample0003NameEQ;
	public IBIZSample0014SearchContext setIbizsample0003NameEQ(String ibizsample0003NameEQ) {
        this.ibizsample0003NameEQ = ibizsample0003NameEQ;
        if(!ObjectUtils.isEmpty(this.ibizsample0003NameEQ)){
            this.getSearchCond().eq("ibizsample0003name", ibizsample0003NameEQ);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizsample0003name_like")
    @JSONField(name = "n_ibizsample0003name_like")
    @ApiModelProperty("名称LIKE")
	private String ibizsample0003NameLIKE;
	public IBIZSample0014SearchContext setIbizsample0003NameLIKE(String ibizsample0003NameLIKE) {
        this.ibizsample0003NameLIKE = ibizsample0003NameLIKE;
        if(!ObjectUtils.isEmpty(this.ibizsample0003NameLIKE)){
            this.getSearchCond().like("ibizsample0003name", ibizsample0003NameLIKE);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizsample0003id_eq")
    @JSONField(name = "n_ibizsample0003id_eq")
    @ApiModelProperty("IBIZSAMPLE0003标识EQ")
	private String ibizsample0003IdEQ;
	public IBIZSample0014SearchContext setIbizsample0003IdEQ(String ibizsample0003IdEQ) {
        this.ibizsample0003IdEQ = ibizsample0003IdEQ;
        if(!ObjectUtils.isEmpty(this.ibizsample0003IdEQ)){
            this.getSearchCond().eq("ibizsample0003id", ibizsample0003IdEQ);
        }
        return this;
    }
                    

    /**
	 * 启用快速搜索
	 */
	public void setQuery(String query)
	{
		this.query=query;
		if(!StringUtils.isEmpty(query)){
            this.getSearchCond().and( wrapper ->
                     wrapper.like("ibizsample0014name", query)
            );
		}
	}
}