package cn.ibizlab.core.sample.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import cn.ibizlab.util.filter.QueryWrapperContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.ibizlab.core.sample.domain.IBIZSample0009;
/**
 * 关系型数据实体[IBIZSample0009] 查询条件对象
 */
@Slf4j
@Getter
@Setter
@NoArgsConstructor
@ApiModel("商品价格明细")
public class IBIZSample0009SearchContext extends QueryWrapperContext<IBIZSample0009> {

    @JsonProperty("n_ibizsample0009name_like")
    @JSONField(name = "n_ibizsample0009name_like")
    @ApiModelProperty("商品价格明细名称LIKE")
	private String ibizSample0009NameLIKE;
	public IBIZSample0009SearchContext setIbizSample0009NameLIKE(String ibizSample0009NameLIKE) {
        this.ibizSample0009NameLIKE = ibizSample0009NameLIKE;
        if(!ObjectUtils.isEmpty(this.ibizSample0009NameLIKE)){
            this.getSearchCond().like("ibizsample0009name", ibizSample0009NameLIKE);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizsample0009id_eq")
    @JSONField(name = "n_ibizsample0009id_eq")
    @ApiModelProperty("商品价格明细标识EQ")
	private String ibizSample0009IdEQ;
	public IBIZSample0009SearchContext setIbizSample0009IdEQ(String ibizSample0009IdEQ) {
        this.ibizSample0009IdEQ = ibizSample0009IdEQ;
        if(!ObjectUtils.isEmpty(this.ibizSample0009IdEQ)){
            this.getSearchCond().eq("ibizsample0009id", ibizSample0009IdEQ);
        }
        return this;
    }
                    

    /**
	 * 启用快速搜索
	 */
	public void setQuery(String query)
	{
		this.query=query;
		if(!StringUtils.isEmpty(query)){
            this.getSearchCond().and( wrapper ->
                     wrapper.like("ibizsample0009name", query)
            );
		}
	}
}