package cn.ibizlab.core.sample.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import cn.ibizlab.util.filter.QueryWrapperContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.ibizlab.core.sample.domain.IBIZSample0003;
/**
 * 关系型数据实体[IBIZSample0003] 查询条件对象
 */
@Slf4j
@Getter
@Setter
@NoArgsConstructor
@ApiModel("示例实体03")
public class IBIZSample0003SearchContext extends QueryWrapperContext<IBIZSample0003> {

    @JsonProperty("n_ibizsample0003name_like")
    @JSONField(name = "n_ibizsample0003name_like")
    @ApiModelProperty("名称LIKE")
	private String ibizsample0003NameLIKE;
	public IBIZSample0003SearchContext setIbizsample0003NameLIKE(String ibizsample0003NameLIKE) {
        this.ibizsample0003NameLIKE = ibizsample0003NameLIKE;
        if(!ObjectUtils.isEmpty(this.ibizsample0003NameLIKE)){
            this.getSearchCond().like("ibizsample0003name", ibizsample0003NameLIKE);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizsample0003id_eq")
    @JSONField(name = "n_ibizsample0003id_eq")
    @ApiModelProperty("IBIZSAMPLE0003标识EQ")
	private String ibizsample0003IdEQ;
	public IBIZSample0003SearchContext setIbizsample0003IdEQ(String ibizsample0003IdEQ) {
        this.ibizsample0003IdEQ = ibizsample0003IdEQ;
        if(!ObjectUtils.isEmpty(this.ibizsample0003IdEQ)){
            this.getSearchCond().eq("ibizsample0003id", ibizsample0003IdEQ);
        }
        return this;
    }
                    
    @JsonProperty("n_pibizsample0003name_eq")
    @JSONField(name = "n_pibizsample0003name_eq")
    @ApiModelProperty("上级EQ")
	private String pibizsample0003NameEQ;
	public IBIZSample0003SearchContext setPibizsample0003NameEQ(String pibizsample0003NameEQ) {
        this.pibizsample0003NameEQ = pibizsample0003NameEQ;
        if(!ObjectUtils.isEmpty(this.pibizsample0003NameEQ)){
            this.getSearchCond().eq("pibizsample0003name", pibizsample0003NameEQ);
        }
        return this;
    }
                    
    @JsonProperty("n_pibizsample0003name_like")
    @JSONField(name = "n_pibizsample0003name_like")
    @ApiModelProperty("上级LIKE")
	private String pibizsample0003NameLIKE;
	public IBIZSample0003SearchContext setPibizsample0003NameLIKE(String pibizsample0003NameLIKE) {
        this.pibizsample0003NameLIKE = pibizsample0003NameLIKE;
        if(!ObjectUtils.isEmpty(this.pibizsample0003NameLIKE)){
            this.getSearchCond().like("pibizsample0003name", pibizsample0003NameLIKE);
        }
        return this;
    }
                    
    @JsonProperty("n_pibizsample0003id_eq")
    @JSONField(name = "n_pibizsample0003id_eq")
    @ApiModelProperty("IBIZSAMPLE0003标识EQ")
	private String pibizsample0003idEQ;
	public IBIZSample0003SearchContext setPibizsample0003idEQ(String pibizsample0003idEQ) {
        this.pibizsample0003idEQ = pibizsample0003idEQ;
        if(!ObjectUtils.isEmpty(this.pibizsample0003idEQ)){
            this.getSearchCond().eq("pibizsample0003id", pibizsample0003idEQ);
        }
        return this;
    }
                    

    /**
	 * 启用快速搜索
	 */
	public void setQuery(String query)
	{
		this.query=query;
		if(!StringUtils.isEmpty(query)){
            this.getSearchCond().and( wrapper ->
                     wrapper.like("ibizsample0003name", query)
            );
		}
	}
}