package cn.ibizlab.core.sample.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import cn.ibizlab.util.filter.QueryWrapperContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.ibizlab.core.sample.domain.IBIZQJ;
/**
 * 关系型数据实体[IBIZQJ] 查询条件对象
 */
@Slf4j
@Getter
@Setter
@NoArgsConstructor
@ApiModel("请假")
public class IBIZQJSearchContext extends QueryWrapperContext<IBIZQJ> {

    @JsonProperty("n_ibizqjname_like")
    @JSONField(name = "n_ibizqjname_like")
    @ApiModelProperty("请假名称LIKE")
	private String ibizqjNameLIKE;
	public IBIZQJSearchContext setIbizqjNameLIKE(String ibizqjNameLIKE) {
        this.ibizqjNameLIKE = ibizqjNameLIKE;
        if(!ObjectUtils.isEmpty(this.ibizqjNameLIKE)){
            this.getSearchCond().like("ibizqjname", ibizqjNameLIKE);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizqjid_eq")
    @JSONField(name = "n_ibizqjid_eq")
    @ApiModelProperty("请假标识EQ")
	private String ibizqjidEQ;
	public IBIZQJSearchContext setIbizqjidEQ(String ibizqjidEQ) {
        this.ibizqjidEQ = ibizqjidEQ;
        if(!ObjectUtils.isEmpty(this.ibizqjidEQ)){
            this.getSearchCond().eq("ibizqjid", ibizqjidEQ);
        }
        return this;
    }
                    

    /**
	 * 启用快速搜索
	 */
	public void setQuery(String query)
	{
		this.query=query;
		if(!StringUtils.isEmpty(query)){
            this.getSearchCond().and( wrapper ->
                     wrapper.like("ibizqjname", query)
            );
		}
	}
}