package cn.ibizlab.core.sample.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import cn.ibizlab.util.filter.QueryWrapperContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.ibizlab.core.sample.domain.IBIZOrderType;
/**
 * 关系型数据实体[IBIZOrderType] 查询条件对象
 */
@Slf4j
@Getter
@Setter
@NoArgsConstructor
@ApiModel("订单类型")
public class IBIZOrderTypeSearchContext extends QueryWrapperContext<IBIZOrderType> {

    @JsonProperty("n_ibizordertypename_like")
    @JSONField(name = "n_ibizordertypename_like")
    @ApiModelProperty("订单类型名称LIKE")
	private String ibizOrderTypeNameLIKE;
	public IBIZOrderTypeSearchContext setIbizOrderTypeNameLIKE(String ibizOrderTypeNameLIKE) {
        this.ibizOrderTypeNameLIKE = ibizOrderTypeNameLIKE;
        if(!ObjectUtils.isEmpty(this.ibizOrderTypeNameLIKE)){
            this.getSearchCond().like("ibizordertypename", ibizOrderTypeNameLIKE);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizordertypeid_eq")
    @JSONField(name = "n_ibizordertypeid_eq")
    @ApiModelProperty("订单类型标识EQ")
	private String ibizOrderTypeIdEQ;
	public IBIZOrderTypeSearchContext setIbizOrderTypeIdEQ(String ibizOrderTypeIdEQ) {
        this.ibizOrderTypeIdEQ = ibizOrderTypeIdEQ;
        if(!ObjectUtils.isEmpty(this.ibizOrderTypeIdEQ)){
            this.getSearchCond().eq("ibizordertypeid", ibizOrderTypeIdEQ);
        }
        return this;
    }
                    

    /**
	 * 启用快速搜索
	 */
	public void setQuery(String query)
	{
		this.query=query;
		if(!StringUtils.isEmpty(query)){
            this.getSearchCond().and( wrapper ->
                     wrapper.like("ibizordertypename", query)
            );
		}
	}
}