package cn.ibizlab.core.sample.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import cn.ibizlab.util.filter.QueryWrapperContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.ibizlab.core.sample.domain.IBIZOrderDetail;
/**
 * 关系型数据实体[IBIZOrderDetail] 查询条件对象
 */
@Slf4j
@Getter
@Setter
@NoArgsConstructor
@ApiModel("订单明细")
public class IBIZOrderDetailSearchContext extends QueryWrapperContext<IBIZOrderDetail> {

    @JsonProperty("n_ibizorderdetailname_like")
    @JSONField(name = "n_ibizorderdetailname_like")
    @ApiModelProperty("订单明细名称LIKE")
	private String ibizOrderDetailNameLIKE;
	public IBIZOrderDetailSearchContext setIbizOrderDetailNameLIKE(String ibizOrderDetailNameLIKE) {
        this.ibizOrderDetailNameLIKE = ibizOrderDetailNameLIKE;
        if(!ObjectUtils.isEmpty(this.ibizOrderDetailNameLIKE)){
            this.getSearchCond().like("ibizorderdetailname", ibizOrderDetailNameLIKE);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizorderdetailid_eq")
    @JSONField(name = "n_ibizorderdetailid_eq")
    @ApiModelProperty("订单明细标识EQ")
	private String ibizOrderDetailIdEQ;
	public IBIZOrderDetailSearchContext setIbizOrderDetailIdEQ(String ibizOrderDetailIdEQ) {
        this.ibizOrderDetailIdEQ = ibizOrderDetailIdEQ;
        if(!ObjectUtils.isEmpty(this.ibizOrderDetailIdEQ)){
            this.getSearchCond().eq("ibizorderdetailid", ibizOrderDetailIdEQ);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizordername_eq")
    @JSONField(name = "n_ibizordername_eq")
    @ApiModelProperty("订单名称EQ")
	private String ibizOrderNameEQ;
	public IBIZOrderDetailSearchContext setIbizOrderNameEQ(String ibizOrderNameEQ) {
        this.ibizOrderNameEQ = ibizOrderNameEQ;
        if(!ObjectUtils.isEmpty(this.ibizOrderNameEQ)){
            this.getSearchCond().eq("ibizordername", ibizOrderNameEQ);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizordername_like")
    @JSONField(name = "n_ibizordername_like")
    @ApiModelProperty("订单名称LIKE")
	private String ibizOrderNameLIKE;
	public IBIZOrderDetailSearchContext setIbizOrderNameLIKE(String ibizOrderNameLIKE) {
        this.ibizOrderNameLIKE = ibizOrderNameLIKE;
        if(!ObjectUtils.isEmpty(this.ibizOrderNameLIKE)){
            this.getSearchCond().like("ibizordername", ibizOrderNameLIKE);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizuniproductname_eq")
    @JSONField(name = "n_ibizuniproductname_eq")
    @ApiModelProperty("产品名称EQ")
	private String ibizuniProductNameEQ;
	public IBIZOrderDetailSearchContext setIbizuniProductNameEQ(String ibizuniProductNameEQ) {
        this.ibizuniProductNameEQ = ibizuniProductNameEQ;
        if(!ObjectUtils.isEmpty(this.ibizuniProductNameEQ)){
            this.getSearchCond().eq("ibizuniproductname", ibizuniProductNameEQ);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizuniproductname_like")
    @JSONField(name = "n_ibizuniproductname_like")
    @ApiModelProperty("产品名称LIKE")
	private String ibizuniProductNameLIKE;
	public IBIZOrderDetailSearchContext setIbizuniProductNameLIKE(String ibizuniProductNameLIKE) {
        this.ibizuniProductNameLIKE = ibizuniProductNameLIKE;
        if(!ObjectUtils.isEmpty(this.ibizuniProductNameLIKE)){
            this.getSearchCond().like("ibizuniproductname", ibizuniProductNameLIKE);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizorderid_eq")
    @JSONField(name = "n_ibizorderid_eq")
    @ApiModelProperty("订单标识EQ")
	private String ibizOrderIdEQ;
	public IBIZOrderDetailSearchContext setIbizOrderIdEQ(String ibizOrderIdEQ) {
        this.ibizOrderIdEQ = ibizOrderIdEQ;
        if(!ObjectUtils.isEmpty(this.ibizOrderIdEQ)){
            this.getSearchCond().eq("ibizorderid", ibizOrderIdEQ);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizuniproductid_eq")
    @JSONField(name = "n_ibizuniproductid_eq")
    @ApiModelProperty("统一产品标识EQ")
	private String ibizuniProductIdEQ;
	public IBIZOrderDetailSearchContext setIbizuniProductIdEQ(String ibizuniProductIdEQ) {
        this.ibizuniProductIdEQ = ibizuniProductIdEQ;
        if(!ObjectUtils.isEmpty(this.ibizuniProductIdEQ)){
            this.getSearchCond().eq("ibizuniproductid", ibizuniProductIdEQ);
        }
        return this;
    }
                    

    /**
	 * 启用快速搜索
	 */
	public void setQuery(String query)
	{
		this.query=query;
		if(!StringUtils.isEmpty(query)){
            this.getSearchCond().and( wrapper ->
                     wrapper.like("ibizorderdetailname", query)
            );
		}
	}
}