package cn.ibizlab.core.sample.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import cn.ibizlab.util.filter.QueryWrapperContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.ibizlab.core.sample.domain.IBIZAPPCTRL;
/**
 * 关系型数据实体[IBIZAPPCTRL] 查询条件对象
 */
@Slf4j
@Getter
@Setter
@NoArgsConstructor
@ApiModel("应用部件")
public class IBIZAPPCTRLSearchContext extends QueryWrapperContext<IBIZAPPCTRL> {

    @JsonProperty("n_ibizappctrlname_like")
    @JSONField(name = "n_ibizappctrlname_like")
    @ApiModelProperty("应用部件名称LIKE")
	private String ibizappctrlNameLIKE;
	public IBIZAPPCTRLSearchContext setIbizappctrlNameLIKE(String ibizappctrlNameLIKE) {
        this.ibizappctrlNameLIKE = ibizappctrlNameLIKE;
        if(!ObjectUtils.isEmpty(this.ibizappctrlNameLIKE)){
            this.getSearchCond().like("ibizappctrlname", ibizappctrlNameLIKE);
        }
        return this;
    }
                    
    @JsonProperty("n_ibizappctrlid_eq")
    @JSONField(name = "n_ibizappctrlid_eq")
    @ApiModelProperty("应用部件标识EQ")
	private String ibizappctrlidEQ;
	public IBIZAPPCTRLSearchContext setIbizappctrlidEQ(String ibizappctrlidEQ) {
        this.ibizappctrlidEQ = ibizappctrlidEQ;
        if(!ObjectUtils.isEmpty(this.ibizappctrlidEQ)){
            this.getSearchCond().eq("ibizappctrlid", ibizappctrlidEQ);
        }
        return this;
    }
                    

    /**
	 * 启用快速搜索
	 */
	public void setQuery(String query)
	{
		this.query=query;
		if(!StringUtils.isEmpty(query)){
            this.getSearchCond().and( wrapper ->
                     wrapper.like("ibizappctrlname", query)
            );
		}
	}
}