package cn.ibizlab.core.sample.filter;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.HashMap;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.alibaba.fastjson.annotation.JSONField;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import cn.ibizlab.util.filter.QueryWrapperContext;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import cn.ibizlab.core.sample.domain.DYNADASHBOARD;
/**
 * 关系型数据实体[DYNADASHBOARD] 查询条件对象
 */
@Slf4j
@Getter
@Setter
@NoArgsConstructor
@ApiModel("动态数据看板")
public class DYNADASHBOARDSearchContext extends QueryWrapperContext<DYNADASHBOARD> {

    @JsonProperty("n_dynadashboardid_eq")
    @JSONField(name = "n_dynadashboardid_eq")
    @ApiModelProperty("动态数据看板标识EQ")
	private String dynadashboardidEQ;
	public DYNADASHBOARDSearchContext setDynadashboardidEQ(String dynadashboardidEQ) {
        this.dynadashboardidEQ = dynadashboardidEQ;
        if(!ObjectUtils.isEmpty(this.dynadashboardidEQ)){
            this.getSearchCond().eq("dynadashboardid", dynadashboardidEQ);
        }
        return this;
    }
                    
    @JsonProperty("n_dynadashboardname_like")
    @JSONField(name = "n_dynadashboardname_like")
    @ApiModelProperty("动态数据看板名称LIKE")
	private String dynadashboardNameLIKE;
	public DYNADASHBOARDSearchContext setDynadashboardNameLIKE(String dynadashboardNameLIKE) {
        this.dynadashboardNameLIKE = dynadashboardNameLIKE;
        if(!ObjectUtils.isEmpty(this.dynadashboardNameLIKE)){
            this.getSearchCond().like("dynadashboardname", dynadashboardNameLIKE);
        }
        return this;
    }
                    

    /**
	 * 启用快速搜索
	 */
	public void setQuery(String query)
	{
		this.query=query;
		if(!StringUtils.isEmpty(query)){
            this.getSearchCond().and( wrapper ->
                     wrapper.like("dynadashboardname", query)
            );
		}
	}
}